/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.krad.bo.DataObjectAuthorizerBase;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.authorization.RequisitionDocumentAuthorizer;
import org.kuali.kfs.module.purap.service.SensitiveDataService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KRADServiceLocatorWeb.class, KRADUtils.class, SpringContext.class})
public class RequisitionDocumentAuthorizerTest {
    private static final String PRINCIPAL_ID = "4004609468";
    private RequisitionDocumentAuthorizer cut;
    @Mock
    private DocumentHeader documentHeaderMock;
    @Mock
    private PermissionService permissionSvcMock;
    @Mock
    private Person userMock;
    @Mock
    private RequisitionDocument requisitionDocument;
    @Mock
    private SensitiveDataService sensitiveDataSvcMock;
    @Mock
    private WorkflowDocument workflowDocumentMock;
    @Mock
    private WorkflowDocumentService workflowDocumentSvcMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(KRADUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)KRADUtils.getNamespaceCode(RequisitionDocument.class)).thenReturn((Object)"KFS-PURAP");
        PowerMockito.mockStatic(KRADServiceLocatorWeb.class, (Class[])new Class[0]);
        Mockito.when((Object)KRADServiceLocatorWeb.getWorkflowDocumentService()).thenReturn((Object)this.workflowDocumentSvcMock);
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
        Mockito.when((Object)SpringContext.getBean(SensitiveDataService.class)).thenReturn((Object)this.sensitiveDataSvcMock);
        Mockito.when((Object)this.userMock.getPrincipalId()).thenReturn((Object)PRINCIPAL_ID);
        Mockito.when((Object)this.requisitionDocument.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        Mockito.when((Object)this.workflowDocumentMock.getStatus()).thenReturn((Object)DocumentStatus.ENROUTE);
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        Mockito.when((Object)this.requisitionDocument.isDocumentStoppedInRouteNode("Commodity")).thenReturn((Object)true);
        this.cut = new RequisitionDocumentAuthorizer();
        DataObjectAuthorizerBase.setPermissionService((PermissionService)this.permissionSvcMock);
    }

    @After
    public void tearDown() {
        DataObjectAuthorizerBase.setPermissionService(null);
    }

    @Test
    public void getEditModes_NotComodityReviewNode() {
        HashSet<String> editModes = new HashSet<String>();
        editModes.add("restrictFullEntry");
        Set updatedEditModes = this.cut.getEditModes((Document)this.requisitionDocument, this.userMock, editModes);
        Assert.assertEquals((long)1L, (long)updatedEditModes.size());
        Assert.assertTrue((boolean)updatedEditModes.contains("restrictFullEntry"));
    }

    @Test
    public void getEditModes_CommodityReviewNode_NoItems() {
        Set<String> editModes = this.setupCommodityReviewEditModes();
        Set updatedEditModes = this.cut.getEditModes((Document)this.requisitionDocument, this.userMock, editModes);
        Assert.assertEquals((long)2L, (long)updatedEditModes.size());
        Assert.assertTrue((boolean)updatedEditModes.contains("restrictFullEntry"));
        Assert.assertTrue((boolean)updatedEditModes.contains("enableCommodityCode"));
    }

    private Set<String> setupCommodityReviewEditModes() {
        HashSet<String> editModes = new HashSet<String>();
        editModes.add("restrictFullEntry");
        editModes.add("enableCommodityCode");
        editModes.add("allowCapitalAssetEdit");
        return editModes;
    }

    @Test
    public void getEditModes_CommodityReviewNode_ItemsWithoutCommodityCodes() {
        Set<String> editModes = this.setupCommodityReviewEditModes();
        this.setupPurApItems(null);
        Set updatedEditModes = this.cut.getEditModes((Document)this.requisitionDocument, this.userMock, editModes);
        Assert.assertEquals((long)2L, (long)updatedEditModes.size());
        Assert.assertTrue((boolean)updatedEditModes.contains("restrictFullEntry"));
        Assert.assertTrue((boolean)updatedEditModes.contains("enableCommodityCode"));
    }

    @Test
    public void getEditModes_CommodityReviewNode_ItemsWithCommodityCodes_NoPermission() {
        Set<String> editModes = this.setupCommodityReviewEditModes();
        this.setupPurApItems("11");
        Set updatedEditModes = this.cut.getEditModes((Document)this.requisitionDocument, this.userMock, editModes);
        Assert.assertEquals((long)2L, (long)updatedEditModes.size());
        Assert.assertTrue((boolean)updatedEditModes.contains("restrictFullEntry"));
        Assert.assertTrue((boolean)updatedEditModes.contains("enableCommodityCode"));
    }

    private void setupPurApItems(String purchasingCommodityCode) {
        ArrayList<RequisitionItem> purApItems = new ArrayList<RequisitionItem>();
        RequisitionItem requisitionItemWithCommodityCode = new RequisitionItem();
        requisitionItemWithCommodityCode.setPurchasingCommodityCode(purchasingCommodityCode);
        purApItems.add(requisitionItemWithCommodityCode);
        RequisitionItem requisitionItemWithoutCommodityCode = new RequisitionItem();
        purApItems.add(requisitionItemWithoutCommodityCode);
        Mockito.when((Object)this.requisitionDocument.getItems()).thenReturn(purApItems);
    }

    @Test
    public void getEditModes_CommodityReviewNode_ItemsWithCommodityCodes_HasPermission() {
        Set<String> editModes = this.setupCommodityReviewEditModes();
        this.setupPurApItems("11");
        Mockito.when((Object)this.permissionSvcMock.isAuthorizedByTemplate((String)ArgumentMatchers.eq((Object)PRINCIPAL_ID), (String)ArgumentMatchers.eq((Object)KFSConstants.PermissionTemplate.MODIFY_ACCOUNTING_LINES.namespace), (String)ArgumentMatchers.eq((Object)KFSConstants.PermissionTemplate.MODIFY_ACCOUNTING_LINES.name), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)true);
        Set updatedEditModes = this.cut.getEditModes((Document)this.requisitionDocument, this.userMock, editModes);
        Assert.assertEquals((long)3L, (long)updatedEditModes.size());
        Assert.assertTrue((boolean)updatedEditModes.contains("restrictFullEntry"));
        Assert.assertTrue((boolean)updatedEditModes.contains("enableCommodityCode"));
        Assert.assertTrue((boolean)updatedEditModes.contains("allowCapitalAssetEdit"));
    }
}

