/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Map;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.CreditMemoDocumentTest;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocumentTest;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocumentTest;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.validation.PurapRuleTestBase;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoAccountPercentBetween0And100Validation;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoInitTabReferenceNumberValidation;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoInitTabRequiredFieldsValidation;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoItemQuantityValidation;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoObjectCodeValidation;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoPurchaseOrderForInvoicedItemsValidation;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoTotalMatchesVendorAmountValidation;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoTotalOverZeroValidation;
import org.kuali.kfs.module.purap.fixture.CreditMemoInitTabFixture;
import org.kuali.kfs.module.purap.fixture.PaymentRequestDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurApAccountingLineFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderAccountingLineFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AddAccountingLineEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.kfs.sys.fixture.AccountingLineFixture;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.vnd.VendorUtils;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.appleton)
public class CreditMemoDocumentRuleTest
extends PurapRuleTestBase {
    VendorCreditMemoDocument creditMemo;
    private Map<String, GenericValidation> validations;

    protected void setUp() throws Exception {
        super.setUp();
        CreditMemoDocumentTest cmDocTest = new CreditMemoDocumentTest();
        this.creditMemo = cmDocTest.buildSimpleDocument();
        this.validations = SpringContext.getBeansOfType(GenericValidation.class);
    }

    protected void tearDown() throws Exception {
        this.validations = null;
        this.creditMemo = null;
        super.tearDown();
    }

    public void testValidateInitTabRequiredFields_WithInvoiceWithTodayWithAmount() {
        this.creditMemo = CreditMemoInitTabFixture.WITH_INVOICE_WITH_DATE_WITH_AMOUNT.populateForRequiredness(this.creditMemo);
        Date today = ((PurapService)SpringContext.getBean(PurapService.class)).getDateFromOffsetFromToday(0);
        this.creditMemo.setCreditMemoDate(today);
        VendorCreditMemoInitTabRequiredFieldsValidation validation = (VendorCreditMemoInitTabRequiredFieldsValidation)this.validations.get("VendorCreditMemo-initTabRequiredFieldsValidation-test");
        CreditMemoDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateInitTabRequiredFields_WithInvoiceWithYesterdayWithAmount() {
        this.creditMemo = CreditMemoInitTabFixture.WITH_INVOICE_WITH_DATE_WITH_AMOUNT.populateForRequiredness(this.creditMemo);
        Date yesterday = ((PurapService)SpringContext.getBean(PurapService.class)).getDateFromOffsetFromToday(-1);
        this.creditMemo.setCreditMemoDate(yesterday);
        VendorCreditMemoInitTabRequiredFieldsValidation validation = (VendorCreditMemoInitTabRequiredFieldsValidation)this.validations.get("VendorCreditMemo-initTabRequiredFieldsValidation-test");
        CreditMemoDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateInitTabRequiredFields_WithInvoiceWithTomorrowWithAmount() {
        this.creditMemo = CreditMemoInitTabFixture.WITH_INVOICE_WITH_DATE_WITH_AMOUNT.populateForRequiredness(this.creditMemo);
        Date tomorrow = ((PurapService)SpringContext.getBean(PurapService.class)).getDateFromOffsetFromToday(1);
        this.creditMemo.setCreditMemoDate(tomorrow);
        VendorCreditMemoInitTabRequiredFieldsValidation validation = (VendorCreditMemoInitTabRequiredFieldsValidation)this.validations.get("VendorCreditMemo-initTabRequiredFieldsValidation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateInitTabRequiredFields_NoInvoiceWithTomorrowWithAmount() {
        this.creditMemo = CreditMemoInitTabFixture.NO_INVOICE_WITH_DATE_WITH_AMOUNT.populateForRequiredness(this.creditMemo);
        Date tomorrow = ((PurapService)SpringContext.getBean(PurapService.class)).getDateFromOffsetFromToday(1);
        this.creditMemo.setCreditMemoDate(tomorrow);
        VendorCreditMemoInitTabRequiredFieldsValidation validation = (VendorCreditMemoInitTabRequiredFieldsValidation)this.validations.get("VendorCreditMemo-initTabRequiredFieldsValidation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateInitTabRequiredFields_WithInvoiceWithTomorrowNoAmount() {
        this.creditMemo = CreditMemoInitTabFixture.WITH_INVOICE_WITH_DATE_NO_AMOUNT.populateForRequiredness(this.creditMemo);
        Date tomorrow = ((PurapService)SpringContext.getBean(PurapService.class)).getDateFromOffsetFromToday(1);
        this.creditMemo.setCreditMemoDate(tomorrow);
        VendorCreditMemoInitTabRequiredFieldsValidation validation = (VendorCreditMemoInitTabRequiredFieldsValidation)this.validations.get("VendorCreditMemo-initTabRequiredFieldsValidation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    private Integer prepareAndSavePO() throws Exception {
        PurchaseOrderDocumentTest poDocTest = new PurchaseOrderDocumentTest();
        PurchaseOrderDocument po = poDocTest.buildSimpleDocument();
        po.setApplicationDocumentStatus("Open");
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)po, (DocumentService)documentService);
        PurchaseOrderDocument poWithID = (PurchaseOrderDocument)documentService.getByDocumentHeaderId(po.getDocumentNumber());
        return poWithID.getPurapDocumentIdentifier();
    }

    private Integer prepareAndSavePREQ() throws Exception {
        PaymentRequestDocumentTest preqDocTest = new PaymentRequestDocumentTest();
        PaymentRequestDocument preq = preqDocTest.createPaymentRequestDocument(PaymentRequestDocumentFixture.PREQ_APPROVAL_REQUIRED, preqDocTest.createPurchaseOrderDocument(PurchaseOrderDocumentFixture.PO_APPROVAL_REQUIRED, false), true, new KualiDecimal[]{new KualiDecimal(100)});
        return preq.getPurapDocumentIdentifier();
    }

    public void testValidateInitTabReferenceNumbers_WithPOIDNoPREQIDNoVendorNum() throws Exception {
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        Integer poID = this.prepareAndSavePO();
        GlobalVariables.getUserSession().clearBackdoorUser();
        this.creditMemo.setPurchaseOrderIdentifier(poID);
        VendorCreditMemoInitTabReferenceNumberValidation validation = (VendorCreditMemoInitTabReferenceNumberValidation)this.validations.get("VendorCreditMemo-initTabReferenceNumberValidation-test");
        CreditMemoDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateInitTabReferenceNumbers_NoPOIDWithPREQIDNoVendorNum() throws Exception {
        Integer preqID = this.prepareAndSavePREQ();
        this.creditMemo.setPaymentRequestIdentifier(preqID);
        VendorCreditMemoInitTabReferenceNumberValidation validation = (VendorCreditMemoInitTabReferenceNumberValidation)this.validations.get("VendorCreditMemo-initTabReferenceNumberValidation-test");
        CreditMemoDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateInitTabReferenceNumbers_NoPOIDNoPREQIdWithVendorNum() {
        this.creditMemo = CreditMemoInitTabFixture.WITH_VENDOR_NUMBER.populateForReferenceNumbers(this.creditMemo);
        String vendorNumber = this.creditMemo.getVendorNumber();
        VendorDetail vendor = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDetail(VendorUtils.getVendorHeaderId((String)vendorNumber), VendorUtils.getVendorDetailId((String)vendorNumber));
        if (ObjectUtils.isNotNull((Object)vendor)) {
            VendorCreditMemoInitTabReferenceNumberValidation validation = (VendorCreditMemoInitTabReferenceNumberValidation)this.validations.get("VendorCreditMemo-initTabReferenceNumberValidation-test");
            CreditMemoDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
        } else {
            CreditMemoDocumentRuleTest.assertTrue((boolean)true);
        }
    }

    public void testValidateInitTabReferenceNumbers_NoPOIDNoPREQIdNoVendorNum() {
        VendorCreditMemoInitTabReferenceNumberValidation validation = (VendorCreditMemoInitTabReferenceNumberValidation)this.validations.get("VendorCreditMemo-initTabReferenceNumberValidation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateInitTabReferenceNumbers_WithPOIdNoPREQIdWithVendorNum() throws Exception {
        this.creditMemo = CreditMemoInitTabFixture.WITH_VENDOR_NUMBER.populateForReferenceNumbers(this.creditMemo);
        String vendorNumber = this.creditMemo.getVendorNumber();
        VendorDetail vendor = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDetail(VendorUtils.getVendorHeaderId((String)vendorNumber), VendorUtils.getVendorDetailId((String)vendorNumber));
        if (ObjectUtils.isNotNull((Object)vendor)) {
            GlobalVariables.getUserSession().setBackdoorUser("parke");
            Integer poID = this.prepareAndSavePO();
            GlobalVariables.getUserSession().clearBackdoorUser();
            this.creditMemo.setPurchaseOrderIdentifier(poID);
            VendorCreditMemoInitTabReferenceNumberValidation validation = (VendorCreditMemoInitTabReferenceNumberValidation)this.validations.get("VendorCreditMemo-initTabReferenceNumberValidation-test");
            CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
        } else {
            CreditMemoDocumentRuleTest.assertTrue((boolean)true);
        }
    }

    public void testValidateInitTabReferenceNumbers_NoPOIdWithPREQIdWithVendorNum() throws Exception {
        this.creditMemo = CreditMemoInitTabFixture.WITH_VENDOR_NUMBER.populateForReferenceNumbers(this.creditMemo);
        String vendorNumber = this.creditMemo.getVendorNumber();
        VendorDetail vendor = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDetail(VendorUtils.getVendorHeaderId((String)vendorNumber), VendorUtils.getVendorDetailId((String)vendorNumber));
        if (ObjectUtils.isNotNull((Object)vendor)) {
            Integer preqID = this.prepareAndSavePREQ();
            this.creditMemo.setPaymentRequestIdentifier(preqID);
            VendorCreditMemoInitTabReferenceNumberValidation validation = (VendorCreditMemoInitTabReferenceNumberValidation)this.validations.get("VendorCreditMemo-initTabReferenceNumberValidation-test");
            CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
        } else {
            CreditMemoDocumentRuleTest.assertTrue((boolean)true);
        }
    }

    public void testValidateInitTabReferenceNumbers_WithPOIdWithPREQIdNoVendorNum() throws Exception {
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        Integer poID = this.prepareAndSavePO();
        GlobalVariables.getUserSession().clearBackdoorUser();
        this.creditMemo.setPurchaseOrderIdentifier(poID);
        Integer preqID = this.prepareAndSavePREQ();
        this.creditMemo.setPaymentRequestIdentifier(preqID);
        VendorCreditMemoInitTabReferenceNumberValidation validation = (VendorCreditMemoInitTabReferenceNumberValidation)this.validations.get("VendorCreditMemo-initTabReferenceNumberValidation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateItemQuantity_POType_EquivalentQuantity() {
        this.creditMemo.setPurchaseOrderIdentifier(new Integer(99999));
        CreditMemoItem item = (CreditMemoItem)this.creditMemo.getItemByLineNumber(1);
        item.setPoInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(1));
        String errorKeyPrefix = "document.item[" + Integer.toString(1) + "].";
        VendorCreditMemoItemQuantityValidation validation = (VendorCreditMemoItemQuantityValidation)this.validations.get("VendorCreditMemo-itemQuantityValidation");
        validation.setItemForValidation(item);
        CreditMemoDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateItemQuantity_PREQType_EquivalentQuantity() {
        this.creditMemo.setPaymentRequestIdentifier(new Integer(9999));
        CreditMemoItem item = (CreditMemoItem)this.creditMemo.getItemByLineNumber(1);
        item.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(1));
        String errorKeyPrefix = "document.item[" + Integer.toString(1) + "].";
        VendorCreditMemoItemQuantityValidation validation = (VendorCreditMemoItemQuantityValidation)this.validations.get("VendorCreditMemo-itemQuantityValidation");
        validation.setItemForValidation(item);
        CreditMemoDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateItemQuantity_POType_NullQuantity() {
        this.creditMemo.setPurchaseOrderIdentifier(new Integer(99999));
        CreditMemoItem item = (CreditMemoItem)this.creditMemo.getItemByLineNumber(1);
        item.setPoInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(null);
        String errorKeyPrefix = "document.item[" + Integer.toString(1) + "].";
        VendorCreditMemoItemQuantityValidation validation = (VendorCreditMemoItemQuantityValidation)this.validations.get("VendorCreditMemo-itemQuantityValidation");
        validation.setItemForValidation(item);
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateItemQuantity_PREQType_NullQuantity() {
        this.creditMemo.setPaymentRequestIdentifier(new Integer(9999));
        CreditMemoItem item = (CreditMemoItem)this.creditMemo.getItemByLineNumber(1);
        item.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(null);
        String errorKeyPrefix = "document.item[" + Integer.toString(1) + "].";
        VendorCreditMemoItemQuantityValidation validation = (VendorCreditMemoItemQuantityValidation)this.validations.get("VendorCreditMemo-itemQuantityValidation");
        validation.setItemForValidation(item);
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateItemQuantity_POType_NegativeQuantity() {
        this.creditMemo.setPurchaseOrderIdentifier(new Integer(99999));
        CreditMemoItem item = (CreditMemoItem)this.creditMemo.getItemByLineNumber(1);
        item.setPoInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(-1));
        String errorKeyPrefix = "document.item[" + Integer.toString(1) + "].";
        VendorCreditMemoItemQuantityValidation validation = (VendorCreditMemoItemQuantityValidation)this.validations.get("VendorCreditMemo-itemQuantityValidation");
        validation.setItemForValidation(item);
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateItemQuantity_PREQType_NegativeQuantity() {
        this.creditMemo.setPaymentRequestIdentifier(new Integer(9999));
        CreditMemoItem item = (CreditMemoItem)this.creditMemo.getItemByLineNumber(1);
        item.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(-1));
        String errorKeyPrefix = "document.item[" + Integer.toString(1) + "].";
        VendorCreditMemoItemQuantityValidation validation = (VendorCreditMemoItemQuantityValidation)this.validations.get("VendorCreditMemo-itemQuantityValidation");
        validation.setItemForValidation(item);
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateItemQuantity_POType_GreaterQuantity() {
        this.creditMemo.setPurchaseOrderIdentifier(new Integer(99999));
        CreditMemoItem item = (CreditMemoItem)this.creditMemo.getItemByLineNumber(1);
        item.setPoInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(2));
        String errorKeyPrefix = "document.item[" + Integer.toString(1) + "].";
        VendorCreditMemoItemQuantityValidation validation = (VendorCreditMemoItemQuantityValidation)this.validations.get("VendorCreditMemo-itemQuantityValidation");
        validation.setItemForValidation(item);
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateItemQuantity_PREQType_GreaterQuantity() {
        this.creditMemo.setPaymentRequestIdentifier(new Integer(9999));
        CreditMemoItem item = (CreditMemoItem)this.creditMemo.getItemByLineNumber(1);
        item.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(2));
        String errorKeyPrefix = "document.item[" + Integer.toString(1) + "].";
        VendorCreditMemoItemQuantityValidation validation = (VendorCreditMemoItemQuantityValidation)this.validations.get("VendorCreditMemo-itemQuantityValidation");
        validation.setItemForValidation(item);
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    private Integer prepareAndSavePOWithChanges(KualiDecimal itemInvoicedTotalQuantity, KualiDecimal itemOutstandingEncumberedAmount, BigDecimal itemUnitPrice) throws Exception {
        PurchaseOrderDocumentTest poDocTest = new PurchaseOrderDocumentTest();
        PurchaseOrderDocument po = poDocTest.buildSimpleDocument();
        PurchaseOrderItem poItem = (PurchaseOrderItem)po.getItemByLineNumber(1);
        poItem.setItemInvoicedTotalQuantity(itemInvoicedTotalQuantity);
        poItem.setItemUnitPrice(itemUnitPrice);
        poItem.setItemOutstandingEncumberedAmount(itemOutstandingEncumberedAmount);
        po.prepareForSave();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)po, (DocumentService)documentService);
        PurchaseOrderDocument poWithID = (PurchaseOrderDocument)documentService.getByDocumentHeaderId(po.getDocumentNumber());
        return poWithID.getPurapDocumentIdentifier();
    }

    public void testCheckPurchaseOrdersForInvoicedItems_NullChanges() throws Exception {
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        Integer poId = this.prepareAndSavePOWithChanges(null, null, null);
        GlobalVariables.getUserSession().clearBackdoorUser();
        this.creditMemo.setPurchaseOrderIdentifier(poId);
        VendorCreditMemoPurchaseOrderForInvoicedItemsValidation validation = (VendorCreditMemoPurchaseOrderForInvoicedItemsValidation)this.validations.get("VendorCreditMemo-purchaseOrderForInvoicedItemsValidation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testCheckPurchaseOrdersForInvoicedItems_NullOutstandingEncumberedAmount() throws Exception {
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        Integer poId = this.prepareAndSavePOWithChanges(null, null, new BigDecimal(1));
        GlobalVariables.getUserSession().clearBackdoorUser();
        this.creditMemo.setPurchaseOrderIdentifier(poId);
        VendorCreditMemoPurchaseOrderForInvoicedItemsValidation validation = (VendorCreditMemoPurchaseOrderForInvoicedItemsValidation)this.validations.get("VendorCreditMemo-purchaseOrderForInvoicedItemsValidation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testCheckPurchaseOrdersForInvoicedItems_NullUnitPrice() throws Exception {
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        Integer poId = this.prepareAndSavePOWithChanges(null, new KualiDecimal(0.5), null);
        GlobalVariables.getUserSession().clearBackdoorUser();
        this.creditMemo.setPurchaseOrderIdentifier(poId);
        VendorCreditMemoPurchaseOrderForInvoicedItemsValidation validation = (VendorCreditMemoPurchaseOrderForInvoicedItemsValidation)this.validations.get("VendorCreditMemo-purchaseOrderForInvoicedItemsValidation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testCheckPurchaseOrdersForInvoicedItems_WithUnitPriceLessThanOutstandingEncumberedAmount() throws Exception {
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        Integer poId = this.prepareAndSavePOWithChanges(null, new KualiDecimal(1), new BigDecimal(0.5));
        GlobalVariables.getUserSession().clearBackdoorUser();
        this.creditMemo.setPurchaseOrderIdentifier(poId);
        VendorCreditMemoPurchaseOrderForInvoicedItemsValidation validation = (VendorCreditMemoPurchaseOrderForInvoicedItemsValidation)this.validations.get("VendorCreditMemo-purchaseOrderForInvoicedItemsValidation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testCheckPurchaseOrdersForInvoicedItems_WithUnitPriceEqualToOutstandingEncumberedAmount() throws Exception {
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        Integer poId = this.prepareAndSavePOWithChanges(null, new KualiDecimal(1), new BigDecimal(1));
        GlobalVariables.getUserSession().clearBackdoorUser();
        this.creditMemo.setPurchaseOrderIdentifier(poId);
        VendorCreditMemoPurchaseOrderForInvoicedItemsValidation validation = (VendorCreditMemoPurchaseOrderForInvoicedItemsValidation)this.validations.get("VendorCreditMemo-purchaseOrderForInvoicedItemsValidation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateTotalMatchesVendorAmount_GrandTotalGreaterThanAmount() {
        this.creditMemo = CreditMemoInitTabFixture.LO_AMOUNT_HI_TOTAL.populateForAmounts(this.creditMemo);
        VendorCreditMemoTotalMatchesVendorAmountValidation validation = (VendorCreditMemoTotalMatchesVendorAmountValidation)this.validations.get("VendorCreditMemo-totalMatchesVendorAmountValidation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateTotalMatchesVendorAmount_AmountGreaterThanGrandTotal() {
        this.creditMemo = CreditMemoInitTabFixture.HI_AMOUNT_LO_TOTAL.populateForAmounts(this.creditMemo);
        VendorCreditMemoTotalMatchesVendorAmountValidation validation = (VendorCreditMemoTotalMatchesVendorAmountValidation)this.validations.get("VendorCreditMemo-totalMatchesVendorAmountValidation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateTotalOverZero_PositiveTotal() {
        this.creditMemo = CreditMemoInitTabFixture.HI_AMOUNT_HI_TOTAL.populateForAmounts(this.creditMemo);
        VendorCreditMemoTotalOverZeroValidation validation = (VendorCreditMemoTotalOverZeroValidation)this.validations.get("VendorCreditMemo-totalOverZeroValidation-test");
        CreditMemoDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemo)));
    }

    public void testValidateObjectCode_Happy() {
        PurApAccountingLine accountingLine = PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1.createPurApAccountingLine(PurApAccountingLineFixture.BASIC_ACCOUNT_1, AccountingLineFixture.LINE6);
        VendorCreditMemoObjectCodeValidation validation = (VendorCreditMemoObjectCodeValidation)this.validations.get("VendorCreditMemo-objectCodeValidation-test");
        CreditMemoDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", (Document)this.creditMemo, (AccountingLine)accountingLine)));
    }

    public void testVerifyAccountingStringsBetween0And100Percent_Happy() {
        PurApAccountingLine accountingLine = PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1.createPurApAccountingLine(PurApAccountingLineFixture.BASIC_ACCOUNT_1, AccountingLineFixture.LINE6);
        VendorCreditMemoAccountPercentBetween0And100Validation validation = (VendorCreditMemoAccountPercentBetween0And100Validation)this.validations.get("VendorCreditMemo-accountPercentBetween0And100Validation-test");
        CreditMemoDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", (Document)this.creditMemo, (AccountingLine)accountingLine)));
    }

    public void testVerifyAccountingStringsBetween0And100Percent_PercentTooHigh() {
        PurApAccountingLine accountingLine = PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1.createPurApAccountingLine(PurApAccountingLineFixture.BAD_ACCOUNT_PERCENT_TOO_HIGH, AccountingLineFixture.LINE6);
        VendorCreditMemoAccountPercentBetween0And100Validation validation = (VendorCreditMemoAccountPercentBetween0And100Validation)this.validations.get("VendorCreditMemo-accountPercentBetween0And100Validation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", (Document)this.creditMemo, (AccountingLine)accountingLine)));
    }

    public void testVerifyAccountingStringsBetween0And100Percent_PercentZero() {
        PurApAccountingLine accountingLine = PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1.createPurApAccountingLine(PurApAccountingLineFixture.BAD_ACCOUNT_PERCENT_ZERO, AccountingLineFixture.LINE6);
        VendorCreditMemoAccountPercentBetween0And100Validation validation = (VendorCreditMemoAccountPercentBetween0And100Validation)this.validations.get("VendorCreditMemo-accountPercentBetween0And100Validation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", (Document)this.creditMemo, (AccountingLine)accountingLine)));
    }

    public void testVerifyAccountingStringsBetween0And100Percent_PercentNegative() {
        PurApAccountingLine accountingLine = PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1.createPurApAccountingLine(PurApAccountingLineFixture.BAD_ACCOUNT_PERCENT_NEGATIVE, AccountingLineFixture.LINE6);
        VendorCreditMemoAccountPercentBetween0And100Validation validation = (VendorCreditMemoAccountPercentBetween0And100Validation)this.validations.get("VendorCreditMemo-accountPercentBetween0And100Validation-test");
        CreditMemoDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", (Document)this.creditMemo, (AccountingLine)accountingLine)));
    }
}

