/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccount;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.validation.PurapRuleTestBase;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableAccountPercentBetween0And100Validation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableAccountPercentValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableBelowTheLineValuesValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableCheckNegativeAccountsValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableHasAccountsValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableUniqueAccountingStringsValidation;
import org.kuali.kfs.module.purap.fixture.PurApAccountingLineFixture;
import org.kuali.kfs.module.purap.fixture.PurApItemFixture;
import org.kuali.kfs.module.purap.fixture.PurapAccountingServiceFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderAccountingLineFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.kfs.sys.fixture.AccountingLineFixture;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.parameter.ParameterEvaluatorService;

@ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
public class PurchasingAccountsPayableDocumentRuleTest
extends PurapRuleTestBase {
    private Map<String, GenericValidation> validations;
    ParameterService parameterService;

    protected void setUp() throws Exception {
        super.setUp();
        this.validations = SpringContext.getBeansOfType(GenericValidation.class);
        if (null == this.parameterService) {
            this.parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        }
    }

    protected void tearDown() throws Exception {
        this.validations = null;
        super.tearDown();
    }

    public void testCheckNegativeAccountsValidation_PositiveAmount() {
        RequisitionDocument doc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocument();
        PurchasingAccountsPayableCheckNegativeAccountsValidation validation = (PurchasingAccountsPayableCheckNegativeAccountsValidation)this.validations.get("PurchasingAccountsPayable-checkNegativeAccountsValidation-test");
        PurchasingAccountsPayableDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)doc)));
    }

    public void testCheckNegativeAccountsValidation_NegativeAmount() {
        RequisitionDocument doc = RequisitionDocumentFixture.REQ_WITH_NEGATIVE_AMOUNT.createRequisitionDocument();
        PurchasingAccountsPayableCheckNegativeAccountsValidation validation = (PurchasingAccountsPayableCheckNegativeAccountsValidation)this.validations.get("PurchasingAccountsPayable-checkNegativeAccountsValidation-test");
        PurchasingAccountsPayableDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)doc)));
    }

    private void validateBelowTheLineValues_TestHelper(String documentType, PurApItem item, String parameterString) {
        try {
            if (!this.parameterService.parameterExists(Class.forName((String)PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType)), parameterString).booleanValue()) {
                PurchasingAccountsPayableDocumentRuleTest.fail((String)("Parameter does not exist:  " + parameterString + " for " + documentType));
            } else if (((ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class)).getParameterEvaluator(Class.forName((String)PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType)), parameterString, item.getItemTypeCode()).evaluationSucceeds()) {
                RequisitionDocument doc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocument();
                PurchasingAccountsPayableBelowTheLineValuesValidation validation = (PurchasingAccountsPayableBelowTheLineValuesValidation)this.validations.get("PurchasingAccountsPayable-belowTheLineValuesValidation");
                item.setPurapDocument((PurchasingAccountsPayableDocument)doc);
                validation.setItemForValidation(item);
                PurchasingAccountsPayableDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)doc)));
            } else {
                RequisitionDocument doc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocument();
                PurchasingAccountsPayableBelowTheLineValuesValidation validation = (PurchasingAccountsPayableBelowTheLineValuesValidation)this.validations.get("PurchasingAccountsPayable-belowTheLineValuesValidation");
                item.setPurapDocument((PurchasingAccountsPayableDocument)doc);
                validation.setItemForValidation(item);
                PurchasingAccountsPayableDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)doc)));
            }
        }
        catch (ClassNotFoundException cnfe) {
            PurchasingAccountsPayableDocumentRuleTest.fail((String)cnfe.toString());
        }
    }

    public void testValidateBelowTheLineValues_Req_Freight_Positive() {
        String documentType = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(RequisitionDocument.class);
        PurApItem item = PurApItemFixture.VALID_FREIGHT_ITEM.createPurApItem(RequisitionItem.class);
        String parameterString = "ITEM_TYPES_ALLOWING_POSITIVE";
        this.validateBelowTheLineValues_TestHelper(documentType, item, parameterString);
    }

    public void testValidateBelowTheLineValues_Req_Freight_Negative() {
        String documentType = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(RequisitionDocument.class);
        PurApItem item = PurApItemFixture.NEGATIVE_FREIGHT_ITEM.createPurApItem(RequisitionItem.class);
        String parameterString = "ITEM_TYPES_ALLOWING_NEGATIVE";
        this.validateBelowTheLineValues_TestHelper(documentType, item, parameterString);
    }

    public void testValidateBelowTheLineValues_Req_Freight_Zero() {
        String documentType = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(RequisitionDocument.class);
        PurApItem item = PurApItemFixture.ZERO_FREIGHT_ITEM.createPurApItem(RequisitionItem.class);
        String parameterString = "ITEM_TYPES_ALLOWING_ZERO";
        this.validateBelowTheLineValues_TestHelper(documentType, item, parameterString);
    }

    public void testValidateBelowTheLineValues_Req_ShippingHandling_Positive() {
        String documentType = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(RequisitionDocument.class);
        PurApItem item = PurApItemFixture.VALID_SHIPPING_AND_HANDLING_ITEM.createPurApItem(RequisitionItem.class);
        String parameterString = "ITEM_TYPES_ALLOWING_POSITIVE";
        this.validateBelowTheLineValues_TestHelper(documentType, item, parameterString);
    }

    public void testValidateBelowTheLineValues_Req_ShippingHandling_Negative() {
        String documentType = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(RequisitionDocument.class);
        PurApItem item = PurApItemFixture.NEGATIVE_SHIPPING_AND_HANDLING_ITEM.createPurApItem(RequisitionItem.class);
        String parameterString = "ITEM_TYPES_ALLOWING_NEGATIVE";
        this.validateBelowTheLineValues_TestHelper(documentType, item, parameterString);
    }

    public void testValidateBelowTheLineValues_Req_ShippingHandling_Zero() {
        String documentType = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(RequisitionDocument.class);
        PurApItem item = PurApItemFixture.ZERO_SHIPPING_AND_HANDLING_ITEM.createPurApItem(RequisitionItem.class);
        String parameterString = "ITEM_TYPES_ALLOWING_ZERO";
        this.validateBelowTheLineValues_TestHelper(documentType, item, parameterString);
    }

    public void testValidateBelowTheLineValues_PREQ_Freight_Positive() {
        String documentType = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(PaymentRequestDocument.class);
        PurApItem item = PurApItemFixture.VALID_FREIGHT_ITEM.createPurApItem(PaymentRequestItem.class);
        String parameterString = "ITEM_TYPES_ALLOWING_POSITIVE";
        this.validateBelowTheLineValues_TestHelper(documentType, item, parameterString);
    }

    public void testValidateBelowTheLineValues_PREQ_Freight_Negative() {
        String documentType = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(PaymentRequestDocument.class);
        PurApItem item = PurApItemFixture.NEGATIVE_FREIGHT_ITEM.createPurApItem(PaymentRequestItem.class);
        String parameterString = "ITEM_TYPES_ALLOWING_NEGATIVE";
        this.validateBelowTheLineValues_TestHelper(documentType, item, parameterString);
    }

    public void testValidateBelowTheLineValues_PREQ_Freight_Zero() {
        String documentType = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(PaymentRequestDocument.class);
        PurApItem item = PurApItemFixture.ZERO_FREIGHT_ITEM.createPurApItem(PaymentRequestItem.class);
        String parameterString = "ITEM_TYPES_ALLOWING_ZERO";
        this.validateBelowTheLineValues_TestHelper(documentType, item, parameterString);
    }

    public void testValidateBelowTheLineValues_PREQ_ShippingHandling_Positive() {
        String documentType = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(PaymentRequestDocument.class);
        PurApItem item = PurApItemFixture.VALID_SHIPPING_AND_HANDLING_ITEM.createPurApItem(PaymentRequestItem.class);
        String parameterString = "ITEM_TYPES_ALLOWING_POSITIVE";
        this.validateBelowTheLineValues_TestHelper(documentType, item, parameterString);
    }

    public void testValidateBelowTheLineValues_PREQ_ShippingHandling_Negative() {
        String documentType = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(PaymentRequestDocument.class);
        PurApItem item = PurApItemFixture.NEGATIVE_SHIPPING_AND_HANDLING_ITEM.createPurApItem(PaymentRequestItem.class);
        String parameterString = "ITEM_TYPES_ALLOWING_NEGATIVE";
        this.validateBelowTheLineValues_TestHelper(documentType, item, parameterString);
    }

    public void testValidateBelowTheLineValues_PREQ_ShippingHandling_Zero() {
        String documentType = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(PaymentRequestDocument.class);
        PurApItem item = PurApItemFixture.ZERO_SHIPPING_AND_HANDLING_ITEM.createPurApItem(PaymentRequestItem.class);
        String parameterString = "ITEM_TYPES_ALLOWING_ZERO";
        this.validateBelowTheLineValues_TestHelper(documentType, item, parameterString);
    }

    public void testVerifyHasAccounts_Positive() {
        ArrayList<PurApAccountingLine> purAccounts = new ArrayList<PurApAccountingLine>();
        PurApAccountingLineFixture purApAcctLineFixture = PurApAccountingLineFixture.BASIC_ACCOUNT_1;
        PurApAccountingLine purApAcctLine1 = purApAcctLineFixture.createPurApAccountingLine(PaymentRequestAccount.class, AccountingLineFixture.PURAP_LINE1);
        purAccounts.add(purApAcctLine1);
        PurchaseOrderItem item = new PurchaseOrderItem();
        item.setSourceAccountingLines(purAccounts);
        PurchasingAccountsPayableHasAccountsValidation validation = (PurchasingAccountsPayableHasAccountsValidation)this.validations.get("PurchasingAccountsPayable-hasAccountsValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingAccountsPayableDocumentRuleTest.assertTrue((boolean)validation.validate(null));
    }

    public void testVerifyHasAccounts_Negative() {
        ArrayList purAccounts = new ArrayList();
        PurchaseOrderItem item = new PurchaseOrderItem();
        item.setSourceAccountingLines(purAccounts);
        PurchasingAccountsPayableHasAccountsValidation validation = (PurchasingAccountsPayableHasAccountsValidation)this.validations.get("PurchasingAccountsPayable-hasAccountsValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingAccountsPayableDocumentRuleTest.assertFalse((boolean)validation.validate(null));
    }

    public void testVerifyAccountPercent_FiftyFifty() {
        PurapAccountingServiceFixture fixture = PurapAccountingServiceFixture.REQ_PRORATION_TWO_ACCOUNTS;
        RequisitionDocument doc = fixture.generateRequisitionDocument_OneItem();
        List purAccounts = ((PurApItem)doc.getItems().get(0)).getSourceAccountingLines();
        PurchaseOrderItem item = new PurchaseOrderItem();
        item.setSourceAccountingLines(purAccounts);
        PurchasingAccountsPayableAccountPercentValidation validation = (PurchasingAccountsPayableAccountPercentValidation)this.validations.get("PurchasingAccountsPayable-accountPercentValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingAccountsPayableDocumentRuleTest.assertTrue((boolean)validation.validate(null));
    }

    public void testVerifyUniqueAccountingStrings_DifferentStrings() {
        ArrayList<PurApAccountingLine> purAccounts = new ArrayList<PurApAccountingLine>();
        PurApAccountingLineFixture purApAcctLineFixture = PurApAccountingLineFixture.ACCOUNT_50_PERCENT;
        PurApAccountingLine purApAcctLine1 = purApAcctLineFixture.createPurApAccountingLine(PaymentRequestAccount.class, AccountingLineFixture.PURAP_LINE1);
        purAccounts.add(purApAcctLine1);
        PurApAccountingLine purApAcctLine2 = purApAcctLineFixture.createPurApAccountingLine(PaymentRequestAccount.class, AccountingLineFixture.PURAP_LINE2);
        purAccounts.add(purApAcctLine2);
        PurchaseOrderItem item = new PurchaseOrderItem();
        item.setSourceAccountingLines(purAccounts);
        PurchasingAccountsPayableUniqueAccountingStringsValidation validation = (PurchasingAccountsPayableUniqueAccountingStringsValidation)this.validations.get("PurchasingAccountsPayable-uniqueAccountingStringsValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingAccountsPayableDocumentRuleTest.assertTrue((boolean)validation.validate(null));
    }

    public void testVerifyUniqueAccountingStrings_SameStrings() {
        ArrayList<PurApAccountingLine> purAccounts = new ArrayList<PurApAccountingLine>();
        PurApAccountingLineFixture purApAcctLineFixture = PurApAccountingLineFixture.ACCOUNT_50_PERCENT;
        PurApAccountingLine purApAcctLine1 = purApAcctLineFixture.createPurApAccountingLine(PaymentRequestAccount.class, AccountingLineFixture.PURAP_LINE1);
        purAccounts.add(purApAcctLine1);
        PurApAccountingLine purApAcctLine2 = purApAcctLineFixture.createPurApAccountingLine(PaymentRequestAccount.class, AccountingLineFixture.PURAP_LINE1);
        purAccounts.add(purApAcctLine2);
        PurchaseOrderItem item = new PurchaseOrderItem();
        item.setSourceAccountingLines(purAccounts);
        PurchasingAccountsPayableUniqueAccountingStringsValidation validation = (PurchasingAccountsPayableUniqueAccountingStringsValidation)this.validations.get("PurchasingAccountsPayable-uniqueAccountingStringsValidation");
        validation.setItemForValidation((PurApItem)item);
        PurchasingAccountsPayableDocumentRuleTest.assertFalse((boolean)validation.validate(null));
    }

    public void testVerifyAccountingStringsBetween0And100Percent_Positive() {
        PurApAccountingLine accountingLine = PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1.createPurApAccountingLine(PurApAccountingLineFixture.BASIC_ACCOUNT_1, AccountingLineFixture.PURAP_LINE1);
        PurchasingAccountsPayableAccountPercentBetween0And100Validation validation = (PurchasingAccountsPayableAccountPercentBetween0And100Validation)this.validations.get("PurchasingAccountsPayable-accountPercentBetween0And100Validation-test");
        validation.setAccountingLine(accountingLine);
        validation.setErrorPropertyName("accountLinePercent");
        validation.setItemIdentifier("1");
        PurchasingAccountsPayableDocumentRuleTest.assertTrue((boolean)validation.validate(null));
    }

    public void testVerifyAccountingStringsBetween0And100Percent_PercentTooHigh() {
        PurApAccountingLine accountingLine = PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1.createPurApAccountingLine(PurApAccountingLineFixture.BAD_ACCOUNT_PERCENT_TOO_HIGH, AccountingLineFixture.PURAP_LINE1);
        PurchasingAccountsPayableAccountPercentBetween0And100Validation validation = (PurchasingAccountsPayableAccountPercentBetween0And100Validation)this.validations.get("PurchasingAccountsPayable-accountPercentBetween0And100Validation-test");
        validation.setAccountingLine(accountingLine);
        validation.setErrorPropertyName("accountLinePercent");
        validation.setItemIdentifier("1");
        PurchasingAccountsPayableDocumentRuleTest.assertFalse((boolean)validation.validate(null));
    }

    public void testVerifyAccountingStringsBetween0And100Percent_PercentZero() {
        PurApAccountingLine accountingLine = PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1.createPurApAccountingLine(PurApAccountingLineFixture.BAD_ACCOUNT_PERCENT_ZERO, AccountingLineFixture.PURAP_LINE1);
        PurchasingAccountsPayableAccountPercentBetween0And100Validation validation = (PurchasingAccountsPayableAccountPercentBetween0And100Validation)this.validations.get("PurchasingAccountsPayable-accountPercentBetween0And100Validation-test");
        validation.setAccountingLine(accountingLine);
        validation.setErrorPropertyName("accountLinePercent");
        validation.setItemIdentifier("1");
        PurchasingAccountsPayableDocumentRuleTest.assertFalse((boolean)validation.validate(null));
    }

    public void testVerifyAccountingStringsBetween0And100Percent_PercentNegative() {
        PurApAccountingLine accountingLine = PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1.createPurApAccountingLine(PurApAccountingLineFixture.BAD_ACCOUNT_PERCENT_NEGATIVE, AccountingLineFixture.PURAP_LINE1);
        PurchasingAccountsPayableAccountPercentBetween0And100Validation validation = (PurchasingAccountsPayableAccountPercentBetween0And100Validation)this.validations.get("PurchasingAccountsPayable-accountPercentBetween0And100Validation-test");
        validation.setAccountingLine(accountingLine);
        validation.setErrorPropertyName("accountLinePercent");
        validation.setItemIdentifier("1");
        PurchasingAccountsPayableDocumentRuleTest.assertFalse((boolean)validation.validate(null));
    }
}

