/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoInitTabReferenceNumberValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class VendorCreditMemoInitTabReferenceNumberValidationTest {
    private VendorCreditMemoInitTabReferenceNumberValidation cut;
    @Mock
    private AttributedDocumentEvent eventMock;
    @Mock
    private PaymentRequestDocument paymentRequestDocumentMock;
    @Mock
    private PaymentRequestService paymentRequestSvcMock;
    @Mock
    private PurchaseOrderDocument purchaseOrderDocumentMock;
    @Mock
    private PurchaseOrderService purchaseOrderSvcMock;
    @Mock
    private VendorCreditMemoDocument vendorCreditMemoDocumentMock;
    @Mock
    private VendorDetail vendorDetailMock;
    @Mock
    private VendorService vendorSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.eventMock.getDocument()).thenReturn((Object)this.vendorCreditMemoDocumentMock);
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"");
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn(null);
        Mockito.when((Object)this.paymentRequestSvcMock.getPaymentRequestById(Integer.valueOf(1))).thenReturn((Object)this.paymentRequestDocumentMock);
        Mockito.when((Object)this.vendorSvcMock.getVendorDetail(Integer.valueOf(1000), Integer.valueOf(0))).thenReturn((Object)this.vendorDetailMock);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1))).thenReturn((Object)this.purchaseOrderDocumentMock);
        this.cut = new VendorCreditMemoInitTabReferenceNumberValidation();
        this.cut.setPaymentRequestService(this.paymentRequestSvcMock);
        this.cut.setPurchaseOrderService(this.purchaseOrderSvcMock);
        this.cut.setVendorService(this.vendorSvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    public void validate_OnlyPaymentRequestIdentifierSet_ExistingPaymentRequestDocument() {
        Assert.assertTrue((boolean)this.cut.validate(this.eventMock));
    }

    @Test
    public void validate_OnlyPaymentRequestIdentifierSet_NonExistentPaymentRequestDocument() {
        Mockito.when((Object)this.paymentRequestSvcMock.getPaymentRequestById(Integer.valueOf(1))).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validate(this.eventMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("paymentRequestIdentifier");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"errors.creditMemo.paymentRequest.invalid", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assert.assertEquals((String)"Expected payment request number as error message parameter", (Object)"1", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    public void validate_OnlyPaymentRequestIdentifierSet_ExistingPaymentRequestDocument_InProcess() {
        Mockito.when((Object)this.paymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        Assert.assertFalse((boolean)this.cut.validate(this.eventMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("paymentRequestIdentifier");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"errors.creditMemo.paymentRequest.invalid.status", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assert.assertEquals((String)"Expected payment request number as error message parameter", (Object)"1", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    public void validate_OnlyPaymentRequestIdentifierSet_ExistingPaymentRequestDocument_CancelledInProgress() {
        Mockito.when((Object)this.paymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled In Process");
        Assert.assertFalse((boolean)this.cut.validate(this.eventMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("paymentRequestIdentifier");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"errors.creditMemo.paymentRequest.invalid.status", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assert.assertEquals((String)"Expected payment request number as error message parameter", (Object)"1", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    public void validate_OnlyPaymentRequestIdentifierSet_ExistingPaymentRequestDocument_CancelledPostApApprove() {
        Mockito.when((Object)this.paymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled");
        Assert.assertFalse((boolean)this.cut.validate(this.eventMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("paymentRequestIdentifier");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"errors.creditMemo.paymentRequest.invalid.status", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assert.assertEquals((String)"Expected payment request number as error message parameter", (Object)"1", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    public void validate_OnlyVendorNumberSet_ExistingVendor() {
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"1000-0");
        Assert.assertTrue((boolean)this.cut.validate(this.eventMock));
    }

    @Test
    public void validate_OnlyVendorNumberSet_MissingVendor() {
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"1000-1");
        Assert.assertFalse((boolean)this.cut.validate(this.eventMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("vendorNumber");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"errors.creditMemo.vendorNumber.invalid", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assert.assertEquals((String)"Expected vendor number as error message parameter", (Object)"1000-1", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    public void validate_OnlyPurchaseOrderIdentifier_ExistingPurchaseOrder_Open() {
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.purchaseOrderDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Open");
        Assert.assertTrue((boolean)this.cut.validate(this.eventMock));
    }

    @Test
    public void validate_OnlyPurchaseOrderIdentifier_ExistingPurchaseOrder_Closed() {
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.purchaseOrderDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Closed");
        Assert.assertTrue((boolean)this.cut.validate(this.eventMock));
    }

    @Test
    public void validate_OnlyPurchaseOrderIdentifier_ExistingPurchaseOrder_InProcess() {
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.purchaseOrderDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"In Process");
        Assert.assertFalse((boolean)this.cut.validate(this.eventMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"errors.creditMemo.purchaseOrder.invalid.status", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assert.assertEquals((String)"Expected PO ID as error message parameter", (Object)"1", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    public void validate_OnlyPurchaseOrderIdentifier_MissingPurchaseOrder() {
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)2);
        Assert.assertFalse((boolean)this.cut.validate(this.eventMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"errors.creditMemo.purchaseOrder.invalid", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assert.assertEquals((String)"Expected PO ID as error message parameter", (Object)"2", (Object)((ErrorMessage)errorMessages.get(0)).getMessageParameters()[0]);
    }

    @Test
    public void validate_OnlyPurchaseOrderIdentifier_ExistingPurchaseOrder_PendingAction() {
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.purchaseOrderDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Open");
        Mockito.when((Object)this.purchaseOrderDocumentMock.isPendingActionIndicator()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cut.validate(this.eventMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.invoice.purchaseOrder.pending.action", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assert.assertEquals((long)0L, (long)((ErrorMessage)errorMessages.get(0)).getMessageParameters().length);
    }

    @Test
    public void validate_NoIdentifiersSet() {
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validate(this.eventMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"errors.creditMemo.required.fields", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assert.assertEquals((long)0L, (long)((ErrorMessage)errorMessages.get(0)).getMessageParameters().length);
    }

    @Test
    public void validate_PaymentRequestIdentifierAndVendorNumberSet() {
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"1000-0");
        Assert.assertFalse((boolean)this.cut.validate(this.eventMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"errors.creditMemo.required.fields", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assert.assertEquals((long)0L, (long)((ErrorMessage)errorMessages.get(0)).getMessageParameters().length);
    }

    @Test
    public void validate_PaymentRequestIdentifierAndPurchaseOrderIdentifierSet() {
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.purchaseOrderDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Open");
        Assert.assertFalse((boolean)this.cut.validate(this.eventMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"errors.creditMemo.required.fields", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assert.assertEquals((long)0L, (long)((ErrorMessage)errorMessages.get(0)).getMessageParameters().length);
    }

    @Test
    public void validate_VendorNumberAndPurchaseOrderIdentifierSet() {
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPaymentRequestIdentifier()).thenReturn(null);
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"1000-0");
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.purchaseOrderDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Open");
        Assert.assertFalse((boolean)this.cut.validate(this.eventMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"errors.creditMemo.required.fields", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assert.assertEquals((long)0L, (long)((ErrorMessage)errorMessages.get(0)).getMessageParameters().length);
    }

    @Test
    public void validate_PaymentRequestIdentifierVendorNumberAndPurchaseOrderIdentifierSet() {
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getVendorNumber()).thenReturn((Object)"1000-0");
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.purchaseOrderDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)"Open");
        Assert.assertFalse((boolean)this.cut.validate(this.eventMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("purchaseOrderIdentifier");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"errors.creditMemo.required.fields", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        Assert.assertEquals((long)0L, (long)((ErrorMessage)errorMessages.get(0)).getMessageParameters().length);
    }
}

