/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountRevisionService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.module.purap.util.SummaryAccount;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class GenerateEntriesCreateCreditMemoTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private VendorCreditMemoDocument creditMemoDocMock;
    @Mock
    private PurchaseOrderDocument poMock;
    @Mock
    private PaymentRequestDocument preqMock;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private GeneralLedgerPendingEntryService glPendingEntrySvcMock;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private PurchaseOrderService purchaseOrderSvcMock;
    @Mock
    private PurapAccountRevisionService purapAccountRevisionSvcMock;
    private List<CreditMemoItem> cmItems;
    private List<PurchaseOrderItem> poItems;
    private List<Object> dynamicMocks;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        this.cut.setGeneralLedgerPendingEntryService(this.glPendingEntrySvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setPurchaseOrderService(this.purchaseOrderSvcMock);
        this.cut.setPurapAccountRevisionService(this.purapAccountRevisionSvcMock);
        this.cmItems = new ArrayList<CreditMemoItem>();
        this.poItems = new ArrayList<PurchaseOrderItem>();
        this.dynamicMocks = new ArrayList<Object>();
    }

    private void execute() {
        this.cut.generateEntriesCreateCreditMemo(this.creditMemoDocMock);
    }

    private void prepareCreditMemo(boolean poSource, boolean preqSource) {
        this.creditMemoDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.creditMemoDocMock)).setGeneralLedgerPendingEntries(ArgumentMatchers.anyList());
        Mockito.when((Object)this.creditMemoDocMock.getDocumentNumber()).thenReturn((Object)"1");
        Mockito.when((Object)this.creditMemoDocMock.isSourceVendor()).thenReturn((Object)(!poSource && !preqSource ? 1 : 0));
        Mockito.when((Object)this.creditMemoDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.creditMemoDocMock.getItems()).thenReturn(this.cmItems);
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)poSource);
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPaymentRequest()).thenReturn((Object)preqSource);
        Mockito.when((Object)this.creditMemoDocMock.getPostingYearFromPendingGLEntries()).thenReturn((Object)2015);
        Mockito.when((Object)this.creditMemoDocMock.getPostingPeriodCodeFromPendingGLEntries()).thenReturn((Object)"01");
    }

    private void prepareBusinessObjectService() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialSystemOriginationCode", "01");
        fieldValues.put("documentNumber", "1");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, fieldValues)).thenReturn((Object)2);
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(null);
    }

    private void baseExpectations(boolean poSource, boolean preqSource, List<SummaryAccount> summaryAccounts) {
        this.prepareCreditMemo(poSource, preqSource);
        this.prepareBusinessObjectService();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.creditMemoDocMock)).thenReturn(summaryAccounts);
    }

    private void preparePO(String status) {
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1234))).thenReturn((Object)this.poMock);
        Mockito.when((Object)this.boServiceMock.save((PersistableBusinessObject)this.poMock)).thenReturn((Object)this.poMock);
        Mockito.when((Object)this.poMock.getApplicationDocumentStatus()).thenReturn((Object)status);
        Mockito.when((Object)this.poMock.getItems()).thenReturn(this.poItems);
    }

    private CreditMemoItem createCmItem(int lineNumber, double totalAmount, double quantity, ItemType type) {
        CreditMemoItem itemMock = (CreditMemoItem)Mockito.mock(CreditMemoItem.class);
        Mockito.when((Object)itemMock.getItemLineNumber()).thenReturn((Object)lineNumber);
        Mockito.when((Object)itemMock.getItemType()).thenReturn((Object)type);
        Mockito.when((Object)itemMock.getItemTypeCode()).thenReturn((Object)type.getItemTypeCode());
        Mockito.when((Object)itemMock.getTotalAmount()).thenReturn((Object)new KualiDecimal(totalAmount));
        Mockito.when((Object)itemMock.getItemQuantity()).thenReturn((Object)new KualiDecimal(quantity));
        this.dynamicMocks.add(itemMock);
        return itemMock;
    }

    private PurchaseOrderItem createPoItem(int lineNumber, double quantity, double amount, double invoicedQuantity, double newInvoicedQuantity, double invoicedAmount, double newInvoicedAmount, double outstandingQuantity, double newOutstandingQuantity, double outstandingAmount, double newOutstandingAmount, double unitPrice, double taxAmount, ItemType type, List<PurApAccountingLine> sourceAccountingLines) {
        ArrayList<PurApAccountingLine> sourceAccountingLinesCopy = new ArrayList<PurApAccountingLine>();
        sourceAccountingLinesCopy.addAll(sourceAccountingLines);
        PurchaseOrderItem itemMock = (PurchaseOrderItem)Mockito.mock(PurchaseOrderItem.class);
        Mockito.when((Object)itemMock.getItemLineNumber()).thenReturn((Object)lineNumber);
        Mockito.when((Object)itemMock.getItemType()).thenReturn((Object)type);
        Mockito.when((Object)itemMock.getItemTypeCode()).thenReturn((Object)type.getItemTypeCode());
        Mockito.when((Object)itemMock.getItemInvoicedTotalQuantity()).thenReturn((Object)new KualiDecimal(invoicedQuantity));
        Mockito.when((Object)itemMock.getItemOutstandingEncumberedQuantity()).thenReturn((Object)new KualiDecimal(outstandingQuantity));
        Mockito.when((Object)itemMock.getItemUnitPrice()).thenReturn((Object)new BigDecimal(unitPrice));
        Mockito.when((Object)itemMock.getItemTaxAmount()).thenReturn((Object)new KualiDecimal(taxAmount));
        Mockito.when((Object)itemMock.getItemQuantity()).thenReturn((Object)new KualiDecimal(quantity));
        Mockito.when((Object)itemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(outstandingAmount));
        Mockito.when((Object)itemMock.getItemInvoicedTotalAmount()).thenReturn((Object)new KualiDecimal(invoicedAmount));
        Mockito.when((Object)itemMock.getSourceAccountingLines()).thenReturn(sourceAccountingLinesCopy);
        Mockito.when((Object)itemMock.getTotalAmount()).thenReturn((Object)new KualiDecimal(amount));
        if (type.isQuantityBasedGeneralLedgerIndicator()) {
            itemMock.setItemInvoicedTotalQuantity(new KualiDecimal(newInvoicedQuantity));
            ((PurchaseOrderItem)Mockito.verify((Object)itemMock)).setItemInvoicedTotalQuantity((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
            itemMock.setItemOutstandingEncumberedQuantity(new KualiDecimal(newOutstandingQuantity));
            ((PurchaseOrderItem)Mockito.verify((Object)itemMock)).setItemOutstandingEncumberedQuantity((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        }
        itemMock.setItemOutstandingEncumberedAmount(new KualiDecimal(newOutstandingAmount));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock)).setItemOutstandingEncumberedAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        itemMock.setItemInvoicedTotalAmount(new KualiDecimal(newInvoicedAmount));
        ((PurchaseOrderItem)Mockito.verify((Object)itemMock)).setItemInvoicedTotalAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        this.dynamicMocks.add(itemMock);
        return itemMock;
    }

    private PurchaseOrderAccount createPoAccountingLine(double percent, double outstandingAmount, double newOutstandingAmount, Double altAmount, String objectCode) {
        SourceAccountingLine acctString = new SourceAccountingLine();
        acctString.setFinancialObjectCode(objectCode);
        PurchaseOrderAccount accountMock = (PurchaseOrderAccount)Mockito.mock(PurchaseOrderAccount.class);
        Mockito.when((Object)accountMock.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)accountMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal(percent));
        Mockito.when((Object)accountMock.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(outstandingAmount));
        Mockito.when((Object)accountMock.generateSourceAccountingLine()).thenReturn((Object)acctString);
        Mockito.when((Object)accountMock.compareTo(ArgumentMatchers.isA(PurchaseOrderAccount.class))).thenReturn((Object)0);
        accountMock.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(newOutstandingAmount));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountMock)).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        if (altAmount != null) {
            Mockito.when((Object)accountMock.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)new KualiDecimal(newOutstandingAmount));
            accountMock.setItemAccountOutstandingEncumbranceAmount(new KualiDecimal(altAmount.doubleValue()));
            ((PurchaseOrderAccount)Mockito.verify((Object)accountMock, (VerificationMode)Mockito.atLeastOnce())).setItemAccountOutstandingEncumbranceAmount((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        }
        this.dynamicMocks.add(accountMock);
        return accountMock;
    }

    private ItemType createItemType(String code, boolean lineItem, boolean quantityBased) {
        ItemType itemType = new ItemType();
        itemType.setItemTypeCode(code);
        itemType.setQuantityBasedGeneralLedgerIndicator(quantityBased);
        itemType.setAdditionalChargeIndicator(!lineItem);
        return itemType;
    }

    private void prepareItem(int lineNumber, double cmAmount, double cmQuantity, double poAmount, double poQuantity, double invoicedQuantity, double newInvoicedQuantity, double invoicedAmount, double newInvoicedAmount, double outstandingQuantity, double newOutstandingQuantity, double outstandingAmount, double newOutstandingAmount, double unitPrice, double taxAmount, ItemType type, List<PurApAccountingLine> sourceAccountingLines) {
        this.cmItems.add(this.createCmItem(lineNumber, cmAmount, cmQuantity, type));
        this.poItems.add(this.createPoItem(lineNumber, poQuantity, poAmount, invoicedQuantity, newInvoicedQuantity, invoicedAmount, newInvoicedAmount, outstandingQuantity, newOutstandingQuantity, outstandingAmount, newOutstandingAmount, unitPrice, taxAmount, type, sourceAccountingLines));
    }

    private void prepareItemsNoAccountingLines() {
        ItemType lineItemQty = this.createItemType("LINEQ", true, true);
        ItemType lineItemAmt = this.createItemType("LINEA", true, false);
        ItemType addlItem = this.createItemType("ADDL", false, false);
        this.prepareItem(1, 2.5, 1.0, 10.0, 4.0, 1.0, 0.0, 2.5, 0.0, 3.0, 4.0, 7.5, 10.0, 2.5, 0.0, lineItemQty, new ArrayList<PurApAccountingLine>());
        this.prepareItem(2, 2.0, 0.0, 10.0, 0.0, 0.0, 0.0, 4.0, 2.0, 0.0, 0.0, 6.0, 8.0, 0.0, 0.0, lineItemAmt, new ArrayList<PurApAccountingLine>());
        this.prepareItem(3, 1.0, 0.0, 10.0, 0.0, 0.0, 0.0, 3.0, 2.0, 0.0, 0.0, 7.0, 8.0, 0.0, 0.0, addlItem, new ArrayList<PurApAccountingLine>());
        this.prepareItem(4, 2.0, 0.0, 10.0, 0.0, 0.0, 0.0, 4.0, 2.0, 0.0, 0.0, 6.0, 8.0, 0.0, 5.0, lineItemAmt, new ArrayList<PurApAccountingLine>());
        this.prepareItem(5, 2.5, 1.0, 10.0, 4.0, 1.0, 0.0, 2.5, 0.0, 3.0, 4.0, 7.8, 10.4, 2.5, 0.4, lineItemQty, new ArrayList<PurApAccountingLine>());
    }

    private void prepareItemsAccountingLines(boolean encumbranceOpen) {
        ItemType lineItemAmt = this.createItemType("LINEA", true, false);
        ArrayList<Object> sourceAccountingLines = new ArrayList<PurApAccountingLine>();
        sourceAccountingLines.add(this.createPoAccountingLine(100.0, 7000.0, 8000.0, 8000.0, "A"));
        this.prepareItem(1, 1000.0, 0.0, 10000.0, 0.0, 0.0, 0.0, 3000.0, 2000.0, 0.0, 0.0, 7000.0, 8000.0, 0.0, 0.0, lineItemAmt, sourceAccountingLines);
        sourceAccountingLines = new ArrayList();
        sourceAccountingLines.add((PurApAccountingLine)this.createPoAccountingLine(50.0, 3500.0, 4000.0, null, "B"));
        sourceAccountingLines.add(this.createPoAccountingLine(50.0, 3500.0, 4000.0, 4000.0, "C"));
        this.prepareItem(2, 1000.0, 0.0, 10000.0, 0.0, 0.0, 0.0, 3000.0, 2000.0, 0.0, 0.0, 7000.0, 8000.0, 0.0, 0.0, lineItemAmt, sourceAccountingLines);
        sourceAccountingLines = new ArrayList();
        sourceAccountingLines.add((PurApAccountingLine)this.createPoAccountingLine(66.66, 4666.2, 5332.8, null, "C"));
        sourceAccountingLines.add(this.createPoAccountingLine(33.33, 2333.8, 2667.1, 2667.2, "D"));
        this.prepareItem(3, 1000.0, 0.0, 10000.0, 0.0, 0.0, 0.0, 3000.0, 2000.0, 0.0, 0.0, 7000.0, 8000.0, 0.0, 0.0, lineItemAmt, sourceAccountingLines);
        if (encumbranceOpen) {
            SourceAccountingLine acctString1 = new SourceAccountingLine();
            acctString1.setFinancialObjectCode("A");
            acctString1.setAmount(new KualiDecimal(1000));
            SourceAccountingLine acctString2 = new SourceAccountingLine();
            acctString2.setFinancialObjectCode("B");
            acctString2.setAmount(new KualiDecimal(500));
            SourceAccountingLine acctString3 = new SourceAccountingLine();
            acctString3.setFinancialObjectCode("C");
            acctString3.setAmount(new KualiDecimal(1166.6));
            SourceAccountingLine acctString4 = new SourceAccountingLine();
            acctString4.setFinancialObjectCode("D");
            acctString4.setAmount(new KualiDecimal(333.4));
            Mockito.when((Object)this.creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)acctString1), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
            Mockito.when((Object)this.creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)acctString2), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
            Mockito.when((Object)this.creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)acctString3), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
            Mockito.when((Object)this.creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)acctString4), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        }
    }

    @Test
    public void baseCase() {
        this.baseExpectations(false, false, null);
        this.execute();
    }

    @Test
    public void closedPONoItems() {
        this.baseExpectations(true, false, null);
        this.preparePO("Closed");
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.execute();
    }

    @Test
    public void closedPOFromPreqNoItems() {
        this.baseExpectations(false, true, null);
        this.preparePO("Closed");
        Mockito.when((Object)this.creditMemoDocMock.getPaymentRequestDocument()).thenReturn((Object)this.preqMock);
        Mockito.when((Object)this.preqMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.execute();
    }

    @Test
    public void closedPOWithItemsNoAccountingLines() {
        this.prepareItemsNoAccountingLines();
        this.baseExpectations(true, false, null);
        this.preparePO("Closed");
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.execute();
    }

    @Test
    public void openPOWithItemsNoAccountingLines() {
        this.prepareItemsNoAccountingLines();
        this.baseExpectations(true, false, null);
        this.preparePO("Open");
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.creditMemoDocMock.setGenerateEncumbranceEntries(true);
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.creditMemoDocMock)).setGenerateEncumbranceEntries(ArgumentMatchers.anyBoolean());
        this.creditMemoDocMock.setDebitCreditCodeForGLEntries("D");
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.creditMemoDocMock)).setDebitCreditCodeForGLEntries(ArgumentMatchers.anyString());
        this.execute();
    }

    @Test
    public void closedPOAccountingLines() {
        this.prepareItemsAccountingLines(false);
        this.baseExpectations(true, false, null);
        this.preparePO("Closed");
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.execute();
    }

    @Test
    public void openPOAccountingLines() {
        this.prepareItemsAccountingLines(true);
        this.baseExpectations(true, false, null);
        this.preparePO("Open");
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1234);
        this.creditMemoDocMock.setGenerateEncumbranceEntries(true);
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.creditMemoDocMock)).setGenerateEncumbranceEntries(ArgumentMatchers.anyBoolean());
        this.creditMemoDocMock.setDebitCreditCodeForGLEntries("D");
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.creditMemoDocMock)).setDebitCreditCodeForGLEntries(ArgumentMatchers.anyString());
        this.execute();
    }

    @Test
    public void summaryAccountHandling() {
        ArrayList<SummaryAccount> summaryAccounts = new ArrayList<SummaryAccount>();
        SummaryAccount summaryAccount = (SummaryAccount)Mockito.mock(SummaryAccount.class);
        SourceAccountingLine account = new SourceAccountingLine();
        Mockito.when((Object)summaryAccount.getAccount()).thenReturn((Object)account);
        summaryAccounts.add(summaryAccount);
        this.dynamicMocks.add(summaryAccount);
        this.baseExpectations(false, false, summaryAccounts);
        this.creditMemoDocMock.setGenerateEncumbranceEntries(false);
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.creditMemoDocMock)).setGenerateEncumbranceEntries(ArgumentMatchers.anyBoolean());
        this.creditMemoDocMock.setDebitCreditCodeForGLEntries("C");
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.creditMemoDocMock)).setDebitCreditCodeForGLEntries(ArgumentMatchers.anyString());
        Mockito.when((Object)this.creditMemoDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.eq((Object)account), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.purapAccountingSvcMock.generateUseTaxAccount((PurchasingAccountsPayableDocument)this.creditMemoDocMock)).thenReturn(new ArrayList());
        this.purapAccountRevisionSvcMock.saveCreditMemoAccountRevisions(new ArrayList(), Integer.valueOf(2015), "01");
        ((PurapAccountRevisionService)Mockito.verify((Object)this.purapAccountRevisionSvcMock)).saveCreditMemoAccountRevisions(ArgumentMatchers.anyList(), Integer.valueOf(ArgumentMatchers.anyInt()), ArgumentMatchers.anyString());
        this.execute();
    }
}

