/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import junit.framework.Assert;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceLoadSummary;
import org.kuali.kfs.module.purap.document.ElectronicInvoiceRejectDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocumentIntegTest;
import org.kuali.kfs.module.purap.fixture.ElectronicInvoiceLoadSummaryFixture;
import org.kuali.kfs.module.purap.fixture.ElectronicInvoiceRejectDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.appleton)
public class ElectronicInvoiceRejectDocumentIntegTest
extends KualiIntegTestBase {
    public static final Class<ElectronicInvoiceRejectDocument> DOCUMENT_CLASS = ElectronicInvoiceRejectDocument.class;
    private ElectronicInvoiceRejectDocument eirDoc = null;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.eirDoc = null;
        super.tearDown();
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public final void testSaveDocument() throws Exception {
        ElectronicInvoiceLoadSummary eils = ElectronicInvoiceLoadSummaryFixture.EILS_BASIC.createElectronicInvoiceLoadSummary();
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        boService.save((PersistableBusinessObject)eils);
        GlobalVariables.getUserSession().setBackdoorUser("kfs");
        this.eirDoc = ElectronicInvoiceRejectDocumentFixture.EIR_ONLY_REQUIRED_FIELDS.createElectronicInvoiceRejectDocument(eils);
        this.eirDoc.prepareForSave();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ElectronicInvoiceRejectDocumentIntegTest.assertFalse((boolean)DocumentStatus.ENROUTE.equals((Object)this.eirDoc.getDocumentHeader().getWorkflowDocument().getStatus()));
        this.saveDocument((Document)this.eirDoc, "saving copy source document", documentService);
        GlobalVariables.getUserSession().clearBackdoorUser();
        Document document = documentService.getByDocumentHeaderId(this.eirDoc.getDocumentNumber());
        ElectronicInvoiceRejectDocumentIntegTest.assertTrue((String)"Document should  be saved.", (boolean)document.getDocumentHeader().getWorkflowDocument().isSaved());
        Document result = documentService.getByDocumentHeaderId(this.eirDoc.getDocumentNumber());
        ElectronicInvoiceRejectDocumentIntegTest.assertMatch(this.eirDoc, result);
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public final void testSaveDocumentWithNonMatchingPO() throws Exception {
        ElectronicInvoiceLoadSummary eils = ElectronicInvoiceLoadSummaryFixture.EILS_BASIC.createElectronicInvoiceLoadSummary();
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        boService.save((PersistableBusinessObject)eils);
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        Integer poId = this.routePO();
        GlobalVariables.getUserSession().setBackdoorUser("kfs");
        this.eirDoc = ElectronicInvoiceRejectDocumentFixture.EIR_ONLY_REQUIRED_FIELDS.createElectronicInvoiceRejectDocument(eils);
        this.eirDoc.setPurchaseOrderIdentifier(poId);
        this.eirDoc.setInvoicePurchaseOrderNumber(poId.toString());
        this.eirDoc.prepareForSave();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ElectronicInvoiceRejectDocumentIntegTest.assertFalse((boolean)DocumentStatus.ENROUTE.equals((Object)this.eirDoc.getDocumentHeader().getWorkflowDocument().getStatus()));
        this.saveDocument((Document)this.eirDoc, "saving copy source document", documentService);
        GlobalVariables.getUserSession().clearBackdoorUser();
        Document document = documentService.getByDocumentHeaderId(this.eirDoc.getDocumentNumber());
        ElectronicInvoiceRejectDocumentIntegTest.assertTrue((String)"Document should  be saved.", (boolean)document.getDocumentHeader().getWorkflowDocument().isSaved());
        Document result = documentService.getByDocumentHeaderId(this.eirDoc.getDocumentNumber());
        ElectronicInvoiceRejectDocumentIntegTest.assertMatch(this.eirDoc, result);
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public final void testSaveDocumentWithMatchingPO() throws Exception {
        ElectronicInvoiceLoadSummary eils = ElectronicInvoiceLoadSummaryFixture.EILS_MATCHING.createElectronicInvoiceLoadSummary();
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        boService.save((PersistableBusinessObject)eils);
        GlobalVariables.getUserSession().setBackdoorUser("parke");
        Integer poId = this.routeMatchingPO();
        GlobalVariables.getUserSession().setBackdoorUser("kfs");
        this.eirDoc = ElectronicInvoiceRejectDocumentFixture.EIR_MATCHING.createElectronicInvoiceRejectDocument(eils);
        this.eirDoc.setPurchaseOrderIdentifier(poId);
        this.eirDoc.setInvoicePurchaseOrderNumber(poId.toString());
        this.eirDoc.prepareForSave();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        ElectronicInvoiceRejectDocumentIntegTest.assertFalse((boolean)DocumentStatus.ENROUTE.equals((Object)this.eirDoc.getDocumentHeader().getWorkflowDocument().getStatus()));
        this.saveDocument((Document)this.eirDoc, "saving copy source document", documentService);
        GlobalVariables.getUserSession().clearBackdoorUser();
        Document document = documentService.getByDocumentHeaderId(this.eirDoc.getDocumentNumber());
        ElectronicInvoiceRejectDocumentIntegTest.assertTrue((String)"Document should  be saved.", (boolean)document.getDocumentHeader().getWorkflowDocument().isSaved());
        Document result = documentService.getByDocumentHeaderId(this.eirDoc.getDocumentNumber());
        ElectronicInvoiceRejectDocumentIntegTest.assertMatch(this.eirDoc, result);
    }

    private void routeDocument(Document document, String annotation, DocumentService documentService) throws WorkflowException {
        try {
            documentService.routeDocument(document, annotation, null);
        }
        catch (ValidationException e) {
            ElectronicInvoiceRejectDocumentIntegTest.fail((String)(e.getMessage() + ", " + GlobalVariables.getMessageMap()));
        }
    }

    private void saveDocument(Document document, String annotation, DocumentService documentService) throws WorkflowException {
        try {
            documentService.saveDocument(document);
        }
        catch (ValidationException e) {
            ElectronicInvoiceRejectDocumentIntegTest.fail((String)(e.getMessage() + ", " + GlobalVariables.getMessageMap()));
        }
    }

    public static <T extends Document> void assertMatch(T document1, T document2) {
        Assert.assertEquals((String)document1.getDocumentNumber(), (String)document2.getDocumentNumber());
        Assert.assertEquals((String)document1.getDocumentHeader().getWorkflowDocument().getDocumentTypeName(), (String)document2.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        ElectronicInvoiceRejectDocument d1 = (ElectronicInvoiceRejectDocument)document1;
        ElectronicInvoiceRejectDocument d2 = (ElectronicInvoiceRejectDocument)document2;
        Assert.assertEquals((String)d1.getInvoiceFileName(), (String)d2.getInvoiceFileName());
        Assert.assertEquals((String)d1.getVendorDunsNumber(), (String)d2.getVendorDunsNumber());
        Assert.assertEquals((int)d1.getInvoiceRejectItems().size(), (int)d2.getInvoiceRejectItems().size());
        Assert.assertEquals((int)d1.getInvoiceRejectReasons().size(), (int)d2.getInvoiceRejectReasons().size());
    }

    private Integer routePO() {
        PurchaseOrderDocumentIntegTest purchaseOrderDocumentTest = new PurchaseOrderDocumentIntegTest();
        try {
            PurchaseOrderDocument poDocument = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS.createPurchaseOrderDocument();
            DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
            poDocument.prepareForSave();
            AccountingDocumentTestUtils.routeDocument((FinancialSystemTransactionalDocument)poDocument, (String)"saving copy source document", null, (DocumentService)documentService);
            WorkflowTestUtils.waitForDocumentApproval((String)poDocument.getDocumentNumber());
            return poDocument.getPurapDocumentIdentifier();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Integer routeMatchingPO() {
        PurchaseOrderDocumentIntegTest purchaseOrderDocumentTest = new PurchaseOrderDocumentIntegTest();
        try {
            PurchaseOrderDocument poDocument = PurchaseOrderDocumentFixture.EINVOICE_PO.createPurchaseOrderDocument();
            DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
            poDocument.prepareForSave();
            AccountingDocumentTestUtils.routeDocument((FinancialSystemTransactionalDocument)poDocument, (String)"saving copy source document", null, (DocumentService)documentService);
            WorkflowTestUtils.waitForDocumentApproval((String)poDocument.getDocumentNumber());
            return poDocument.getPurapDocumentIdentifier();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

