/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentWithCommodityCodeFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.IntegTestUtils;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.config.property.ConfigurationService;

@ConfigureContext(session=UserNameFixture.khuntley)
public class NegativeAPOIntegTest
extends KualiIntegTestBase {
    private RequisitionService reqService;
    private ConfigurationService kualiConfigurationService;
    private PurapService purapService;
    private RequisitionDocument requisitionDocument = null;

    protected void setUp() throws Exception {
        super.setUp();
        if (null == this.reqService) {
            this.reqService = (RequisitionService)SpringContext.getBean(RequisitionService.class);
        }
        if (null == this.kualiConfigurationService) {
            this.kualiConfigurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        }
        if (null == this.purapService) {
            this.purapService = (PurapService)SpringContext.getBean(PurapService.class);
        }
    }

    protected void tearDown() throws Exception {
        this.requisitionDocument = null;
        super.tearDown();
    }

    public void testInvalidAPOTotalGreaterThanAPOLimitNoRouting() throws Exception {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_NO_APO_VALID.createRequisitionDocument();
        String docId = requisitionDocument.getDocumentNumber();
        NegativeAPOIntegTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.requisitionTotal.greaterThan.APOLimit");
            NegativeAPOIntegTest.assertTrue((requisitionDocument.getNote(0).getNoteText().indexOf(reason) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testInvalidAPOTotalNotGreaterThanZero() throws Exception {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_APO_INVALID_TOTAL_NOT_GREATER_THAN_ZERO.createRequisitionDocument();
        String docId = requisitionDocument.getDocumentNumber();
        NegativeAPOIntegTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.requisitionTotal.notGreaterThan.zero");
            NegativeAPOIntegTest.assertTrue((requisitionDocument.getNote(0).getNoteText().indexOf(reason) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testInvalidAPORequisitionContainsRestrictedItem() throws Exception {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_APO_INVALID_CONTAINS_RESTRICTED_ITEM.createRequisitionDocument();
        String docId = requisitionDocument.getDocumentNumber();
        NegativeAPOIntegTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.requisition.contains.restricted.item");
            NegativeAPOIntegTest.assertTrue((requisitionDocument.getNote(0).getNoteText().indexOf(reason) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testInvalidAPOVendorNotSelected() throws Exception {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocument();
        String docId = requisitionDocument.getDocumentNumber();
        NegativeAPOIntegTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.vendor.not.selected.from.vendor.database");
            NegativeAPOIntegTest.assertTrue((requisitionDocument.getNote(0).getNoteText().indexOf(reason) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testInvalidAPOMissingVendorAddressFields() throws Exception {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_APO_VALID.createRequisitionDocument();
        requisitionDocument.setVendorCityName(null);
        String docId = requisitionDocument.getDocumentNumber();
        NegativeAPOIntegTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.missing.some.vendor.address.fields");
            NegativeAPOIntegTest.assertTrue((requisitionDocument.getNote(0).getNoteText().indexOf(reason) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testInvalidAPOVendorNotInDB() throws Exception {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_APO_INVALID_ERROR_RETRIEVING_VENDOR_FROM_DATABASE.createRequisitionDocument();
        String docId = requisitionDocument.getDocumentNumber();
        NegativeAPOIntegTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.error.retrieving.vendor.from.database");
            NegativeAPOIntegTest.assertTrue((requisitionDocument.getNote(0).getNoteText().indexOf(reason) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testInvalidAPOVendorIsRestricted() throws Exception {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_APO_INVALID_WITH_RESTRICTED_VENDOR.createRequisitionDocument();
        String docId = requisitionDocument.getDocumentNumber();
        NegativeAPOIntegTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.selected.vendor.is.restricted");
            NegativeAPOIntegTest.assertTrue((requisitionDocument.getNote(0).getNoteText().indexOf(reason) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testInvalidAPOPaymentTypeRecurring() throws Exception {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_APO_INVALID_PAYMENT_TYPE_RECURRING.createRequisitionDocument();
        String docId = requisitionDocument.getDocumentNumber();
        NegativeAPOIntegTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.paymentType.is.recurring");
            NegativeAPOIntegTest.assertTrue((requisitionDocument.getNote(0).getNoteText().indexOf(reason) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testInvalidAPOPOTotalLimitNonzero() throws Exception {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_APO_INVALID_PO_TOTAL_LIMIT_NON_ZERO.createRequisitionDocument();
        String docId = requisitionDocument.getDocumentNumber();
        NegativeAPOIntegTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.po.total.limit.is.not.empty");
            NegativeAPOIntegTest.assertTrue((requisitionDocument.getNote(0).getNoteText().indexOf(reason) >= 0 ? 1 : 0) != 0);
        }
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    public void testInvalidAPOHasAlternateVendorName() throws Exception {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_APO_INVALID_ALTERNATE_VENDOR_NAMES.createRequisitionDocument();
        String docId = requisitionDocument.getDocumentNumber();
        NegativeAPOIntegTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.requisition.contains.alternate.vendor.names");
            NegativeAPOIntegTest.assertTrue((requisitionDocument.getNote(0).getNoteText().indexOf(reason) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testInvalidAPOHasInactiveCommodityCode() throws Exception {
        IntegTestUtils.setSystemParameter(PurchaseOrderDocument.class, (String)"ITEMS_REQUIRE_COMMODITY_CODE_IND", (String)"Y");
        RequisitionDocumentWithCommodityCodeFixture fixture = RequisitionDocumentWithCommodityCodeFixture.REQ_APO_INACTIVE_COMMODITY_CODE;
        RequisitionDocument requisitionDocument = fixture.createRequisitionDocument();
        NegativeAPOIntegTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.requisition.contains.inactive.commodity.code");
            NegativeAPOIntegTest.assertTrue((requisitionDocument.getNote(0).getNoteText().indexOf(reason) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testInvalidAPOHasCommodityCodeWithSensitiveData() throws Exception {
        IntegTestUtils.setSystemParameter(PurchaseOrderDocument.class, (String)"ITEMS_REQUIRE_COMMODITY_CODE_IND", (String)"Y");
        RequisitionDocumentWithCommodityCodeFixture fixture = RequisitionDocumentWithCommodityCodeFixture.REQ_APO_COMMODITY_CODE_WITH_SENSITIVE_DATA;
        RequisitionDocument requisitionDocument = fixture.createRequisitionDocument();
        NegativeAPOIntegTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.requisition.contains.restricted.commodity.code");
            NegativeAPOIntegTest.assertTrue((requisitionDocument.getNote(0).getNoteText().indexOf(reason) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testInvalidAPOMissingCommodityCode() throws Exception {
        IntegTestUtils.setSystemParameter(PurchaseOrderDocument.class, (String)"ITEMS_REQUIRE_COMMODITY_CODE_IND", (String)"Y");
        RequisitionDocumentFixture fixture = RequisitionDocumentFixture.REQ_APO_VALID;
        RequisitionDocument requisitionDocument = fixture.createRequisitionDocument();
        requisitionDocument.refreshReferenceObject("vendorDetail");
        NegativeAPOIntegTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.requisition.missing.commodity.code");
            NegativeAPOIntegTest.assertTrue((requisitionDocument.getNote(0).getNoteText().indexOf(reason) >= 0 ? 1 : 0) != 0);
        }
    }
}

