/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service;

import java.io.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderView;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocumentIntegTest;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.fixture.PaymentRequestDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentWithCommodityCodeFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderVendorQuoteFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.IntegTestUtils;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.vnd.businessobject.ContractManager;
import org.kuali.kfs.vnd.businessobject.VendorCommodityCode;
import org.kuali.kfs.vnd.businessobject.VendorContract;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
public class PurchaseOrderServiceIntegTest
extends KualiIntegTestBase {
    private static final Logger LOG = LogManager.getLogger(PurchaseOrderServiceIntegTest.class);
    protected DocumentService docService;
    protected PurchaseOrderService poService;
    private PurapAccountingService purapAccountingService;

    protected void setUp() throws Exception {
        super.setUp();
        if (null == this.docService) {
            this.docService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        if (null == this.poService) {
            this.poService = (PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class);
        }
        if (this.purapAccountingService == null) {
            this.purapAccountingService = (PurapAccountingService)SpringContext.getBean(PurapAccountingService.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testPurchaseOrderRetransmit() throws Exception {
        PurchaseOrderDocument po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        po.setApplicationDocumentStatus("Open");
        po.refreshNonUpdateableReferences();
        po.prepareForSave();
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)po, (DocumentService)this.docService);
        PurchaseOrderDocument poRetrans = null;
        try {
            poRetrans = this.poService.createAndSavePotentialChangeDocument(po.getDocumentNumber(), "PORT", "Pending Retransmit");
            po = this.poService.getPurchaseOrderByDocumentNumber(po.getDocumentNumber());
        }
        catch (ValidationException ve) {
            PurchaseOrderServiceIntegTest.fail((String)("Validation errors creating PO retransmit document: " + IntegTestUtils.dumpMessageMapErrors()));
        }
        PurchaseOrderServiceIntegTest.assertMatchRetransmit(po, poRetrans);
        ((PurchaseOrderItem)poRetrans.getItem(0)).setItemSelectedForRetransmitIndicator(true);
        ByteArrayOutputStream baosPDF = new ByteArrayOutputStream();
        try {
            this.poService.retransmitPurchaseOrderPDF(poRetrans, baosPDF);
            PurchaseOrderServiceIntegTest.assertTrue((baosPDF.size() > 0 ? 1 : 0) != 0);
        }
        catch (ValidationException e) {
            PurchaseOrderServiceIntegTest.fail((String)("Caught ValidationException while trying to retransmit PO with doc id " + po.getDocumentNumber() + "\n" + IntegTestUtils.dumpMessageMapErrors()));
        }
        finally {
            if (baosPDF != null) {
                baosPDF.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testPurchaseOrderPrint() throws Exception {
        PurchaseOrderDocument po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        po.setApplicationDocumentStatus("Open");
        po.refreshNonUpdateableReferences();
        po.prepareForSave();
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)po, (DocumentService)this.docService);
        ByteArrayOutputStream baosPDF = new ByteArrayOutputStream();
        try {
            this.poService.performPrintPurchaseOrderPDFOnly(po.getDocumentNumber(), baosPDF);
            PurchaseOrderServiceIntegTest.assertTrue((baosPDF.size() > 0 ? 1 : 0) != 0);
        }
        catch (ValidationException e) {
            PurchaseOrderServiceIntegTest.fail((String)("Caught ValidationException while trying to retransmit PO with doc id " + po.getDocumentNumber() + "\n" + IntegTestUtils.dumpMessageMapErrors()));
        }
        finally {
            if (baosPDF != null) {
                baosPDF.reset();
            }
        }
    }

    public final void testGetInternalPurchasingDollarLimit() {
        PurchaseOrderDocument po = PurchaseOrderDocumentFixture.PO_WITH_VENDOR_CONTRACT.createPurchaseOrderDocument();
        VendorContract contract = new VendorContract();
        Integer contrID = po.getVendorContractGeneratedIdentifier();
        KualiDecimal contrAPOLimit = new KualiDecimal(120000.0);
        contract.setVendorContractGeneratedIdentifier(contrID);
        contract.setOrganizationAutomaticPurchaseOrderLimit(contrAPOLimit);
        ContractManager manager = new ContractManager();
        Integer mngrCode = po.getContractManagerCode();
        manager.setContractManagerCode(mngrCode);
        KualiDecimal mngrDDLimit = new KualiDecimal(100000.0);
        manager.setContractManagerDelegationDollarLimit(mngrDDLimit);
        VendorService vdService = (VendorService)SpringContext.getBean(VendorService.class);
        String chartCode = po.getChartOfAccountsCode();
        String orgCode = po.getOrganizationCode();
        KualiDecimal contrDLimit = vdService.getApoLimitFromContract(contrID, chartCode, orgCode);
        po.setVendorContractGeneratedIdentifier(null);
        po.setVendorContract(null);
        po.setContractManager(manager);
        KualiDecimal result = this.poService.getInternalPurchasingDollarLimit(po);
        PurchaseOrderServiceIntegTest.assertEquals((Object)result, (Object)mngrDDLimit);
        po.setVendorContractGeneratedIdentifier(contrID);
        po.setVendorContract(contract);
        po.setContractManagerCode(null);
        po.setContractManager(null);
        result = this.poService.getInternalPurchasingDollarLimit(po);
        PurchaseOrderServiceIntegTest.assertEquals((Object)result, (Object)contrDLimit);
        po.setVendorContractGeneratedIdentifier(contrID);
        po.setVendorContract(contract);
        po.setContractManagerCode(mngrCode);
        po.setContractManager(manager);
        po.setContractManagerCode(mngrCode);
        result = this.poService.getInternalPurchasingDollarLimit(po);
        PurchaseOrderServiceIntegTest.assertEquals((Object)result, (Object)contrDLimit);
        KualiDecimal mngrDDLimit1 = new KualiDecimal(150000.0);
        manager.setContractManagerDelegationDollarLimit(mngrDDLimit1);
        result = this.poService.getInternalPurchasingDollarLimit(po);
        PurchaseOrderServiceIntegTest.assertEquals((Object)result, (Object)mngrDDLimit1);
    }

    public static void assertMatchRetransmit(PurchaseOrderDocument doc1, PurchaseOrderDocument doc2) {
        if (StringUtils.isNotBlank((CharSequence)doc1.getPostingPeriodCode()) && StringUtils.isNotBlank((CharSequence)doc2.getPostingPeriodCode())) {
            PurchaseOrderServiceIntegTest.assertEquals((String)doc1.getPostingPeriodCode(), (String)doc2.getPostingPeriodCode());
        }
        PurchaseOrderServiceIntegTest.assertEquals((Object)doc1.getPostingYear(), (Object)doc2.getPostingYear());
        PurchaseOrderServiceIntegTest.assertEquals((Object)doc1.getVendorHeaderGeneratedIdentifier(), (Object)doc2.getVendorHeaderGeneratedIdentifier());
        PurchaseOrderServiceIntegTest.assertEquals((Object)doc1.getVendorDetailAssignedIdentifier(), (Object)doc2.getVendorDetailAssignedIdentifier());
        PurchaseOrderServiceIntegTest.assertEquals((String)doc1.getVendorName(), (String)doc2.getVendorName());
        PurchaseOrderServiceIntegTest.assertEquals((String)doc1.getVendorNumber(), (String)doc2.getVendorNumber());
        PurchaseOrderServiceIntegTest.assertEquals((String)doc1.getChartOfAccountsCode(), (String)doc2.getChartOfAccountsCode());
        PurchaseOrderServiceIntegTest.assertEquals((String)doc1.getOrganizationCode(), (String)doc2.getOrganizationCode());
        PurchaseOrderServiceIntegTest.assertEquals((String)doc1.getDeliveryCampusCode(), (String)doc2.getDeliveryCampusCode());
        PurchaseOrderServiceIntegTest.assertEquals((Object)doc1.getDeliveryRequiredDate(), (Object)doc2.getDeliveryRequiredDate());
        PurchaseOrderServiceIntegTest.assertEquals((String)doc1.getRequestorPersonName(), (String)doc2.getRequestorPersonName());
        PurchaseOrderServiceIntegTest.assertEquals((Object)doc1.getContractManagerCode(), (Object)doc2.getContractManagerCode());
        PurchaseOrderServiceIntegTest.assertEquals((String)doc1.getVendorContractName(), (String)doc2.getVendorContractName());
        PurchaseOrderServiceIntegTest.assertEquals((boolean)doc1.getPurchaseOrderAutomaticIndicator(), (boolean)doc2.getPurchaseOrderAutomaticIndicator());
        PurchaseOrderServiceIntegTest.assertEquals((String)doc1.getPurchaseOrderTransmissionMethodCode(), (String)doc2.getPurchaseOrderTransmissionMethodCode());
        PurchaseOrderServiceIntegTest.assertEquals((Object)doc1.getRequisitionIdentifier(), (Object)doc2.getRequisitionIdentifier());
        PurchaseOrderServiceIntegTest.assertEquals((Object)doc1.getPurchaseOrderPreviousIdentifier(), (Object)doc2.getPurchaseOrderPreviousIdentifier());
        PurchaseOrderServiceIntegTest.assertEquals((Object)doc1.getPurchaseOrderCreateTimestamp(), (Object)doc2.getPurchaseOrderCreateTimestamp());
    }

    public void testUpdateVendorCommodityCode() {
        PurchaseOrderDocument po = PurchaseOrderDocumentWithCommodityCodeFixture.PO_VALID_ACTIVE_COMMODITY_CODE_WITH_VENDOR_COMMODITY_CODE.createPurchaseOrderDocument();
        VendorDetail updatedVendor = this.poService.updateVendorWithMissingCommodityCodesIfNecessary(po);
        PurchaseOrderServiceIntegTest.assertFalse((updatedVendor == null ? 1 : 0) != 0);
        if (updatedVendor != null) {
            boolean foundMatching = false;
            for (VendorCommodityCode vcc : updatedVendor.getVendorCommodities()) {
                if (!vcc.getPurchasingCommodityCode().equals(((PurchaseOrderItem)po.getItem(0)).getPurchasingCommodityCode())) continue;
                foundMatching = true;
                break;
            }
            PurchaseOrderServiceIntegTest.assertTrue((boolean)foundMatching);
        }
    }

    public void testCreateAutomaticPurchaseOrderDocument() throws Exception {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_APO_VALID.createRequisitionDocument();
        this.routeRequisition(req);
        String docId = req.getDocumentNumber();
        this.poService.createAutomaticPurchaseOrderDocument(req);
        RequisitionDocument requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        String poDocId = ((PurchaseOrderView)requisitionDocument.getRelatedViews().getRelatedPurchaseOrderViews().get(0)).getDocumentNumber();
        PurchaseOrderDocument purchaseOrderDocument = (PurchaseOrderDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(poDocId);
        PurchaseOrderServiceIntegTest.assertTrue((boolean)purchaseOrderDocument.getPurchaseOrderAutomaticIndicator());
        PurchaseOrderServiceIntegTest.assertEquals((Object)purchaseOrderDocument.getContractManagerCode(), (Object)new Integer(99));
    }

    public void testCreatePurchaseOrderDocument() throws Exception {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_NO_APO_VALID.createRequisitionDocument();
        this.routeRequisition(req);
        String docId = req.getDocumentNumber();
        Integer contractManagerCode = new Integer(12);
        this.poService.createPurchaseOrderDocument(req, "parke", contractManagerCode);
        RequisitionDocument requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        String poDocId = ((PurchaseOrderView)requisitionDocument.getRelatedViews().getRelatedPurchaseOrderViews().get(0)).getDocumentNumber();
        PurchaseOrderDocument purchaseOrderDocument = (PurchaseOrderDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(poDocId);
        PurchaseOrderServiceIntegTest.assertEquals((String)purchaseOrderDocument.getApplicationDocumentStatus(), (String)"In Process");
        PurchaseOrderServiceIntegTest.assertEquals((Object)purchaseOrderDocument.getContractManagerCode(), (Object)contractManagerCode);
    }

    protected void routeRequisition(RequisitionDocument req) {
        try {
            AccountingDocumentTestUtils.routeDocument((AccountingDocument)req, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
        }
        catch (ValidationException ex) {
            PurchaseOrderServiceIntegTest.fail((String)("Validation problems routing document: " + IntegTestUtils.dumpMessageMapErrors() + "\n" + req));
        }
        catch (WorkflowException ex) {
            PurchaseOrderServiceIntegTest.fail((String)("Error routing document: " + ex.getMessage()));
        }
    }

    protected void routePurchaseOrder(PurchaseOrderDocument poDoc) throws Exception {
        try {
            AccountingDocumentTestUtils.testRouteDocument((FinancialSystemTransactionalDocument)poDoc, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
        }
        catch (ValidationException ex) {
            PurchaseOrderServiceIntegTest.fail((String)("Validation problems routing document: " + IntegTestUtils.dumpMessageMapErrors()));
        }
        catch (WorkflowException ex) {
            PurchaseOrderServiceIntegTest.fail((String)("Error routing document: " + ex.getMessage()));
        }
    }

    public void testCreateAndRoutePotentialChangeDocument() throws Exception {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_ALTERNATE_APO.createRequisitionDocument();
        for (RequisitionItem item : req.getItems()) {
            this.purapAccountingService.updateItemAccountAmounts((PurApItem)item);
        }
        this.routeRequisition(req);
        String docId = req.getDocumentNumber();
        this.poService.createAutomaticPurchaseOrderDocument(req);
        RequisitionDocument requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        String poDocId = ((PurchaseOrderView)requisitionDocument.getRelatedViews().getRelatedPurchaseOrderViews().get(0)).getDocumentNumber();
        PurchaseOrderDocument purchaseOrderDocument = (PurchaseOrderDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(poDocId);
        WorkflowTestUtils.waitForDocumentApproval((String)purchaseOrderDocument.getDocumentNumber());
        PurchaseOrderDocument newDocument = this.poService.createAndRoutePotentialChangeDocument(poDocId, "POV", "", null, "Pending Void");
        PurchaseOrderDocument oldDocument = (PurchaseOrderDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(poDocId);
        PurchaseOrderServiceIntegTest.assertEquals((String)oldDocument.getApplicationDocumentStatus(), (String)"Retired Version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrintPurchaseOrderQuoteRequestsListPDF() throws Exception {
        PurchaseOrderDocument po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        po.setApplicationDocumentStatus("Open");
        po.refreshNonUpdateableReferences();
        po.prepareForSave();
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)po, (DocumentService)this.docService);
        ByteArrayOutputStream baosPDF = new ByteArrayOutputStream();
        try {
            DateTimeService dtService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
            this.poService.printPurchaseOrderQuoteRequestsListPDF(po.getDocumentNumber(), baosPDF);
            PurchaseOrderServiceIntegTest.assertTrue((baosPDF.size() > 0 ? 1 : 0) != 0);
        }
        catch (ValidationException e) {
            LOG.warn("Caught ValidationException while trying to retransmit PO with doc id " + po.getDocumentNumber());
        }
        finally {
            if (baosPDF != null) {
                baosPDF.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrintPurchaseOrderQuotePDF() throws Exception {
        PurchaseOrderDocument po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        po.setApplicationDocumentStatus("Open");
        po.refreshNonUpdateableReferences();
        po.prepareForSave();
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)po, (DocumentService)this.docService);
        PurchaseOrderVendorQuote vendorQuote = PurchaseOrderVendorQuoteFixture.BASIC_VENDOR_QUOTE_1.createPurchaseOrderVendorQuote();
        vendorQuote.setDocumentNumber(po.getDocumentNumber());
        ByteArrayOutputStream baosPDF = new ByteArrayOutputStream();
        try {
            this.poService.printPurchaseOrderQuotePDF(po, vendorQuote, baosPDF);
            PurchaseOrderServiceIntegTest.assertTrue((baosPDF.size() > 0 ? 1 : 0) != 0);
            LOG.error("Attn From testPrintPurchaseOrderQuotePDF");
            LOG.error("baosPDF.size is : " + baosPDF.size());
            LOG.error("----------------------------------------");
        }
        catch (Exception e) {
            LOG.warn("Caught ValidationException while trying to print PO quote pdf with doc id " + po.getDocumentNumber());
        }
        finally {
            if (baosPDF != null) {
                baosPDF.reset();
            }
        }
    }

    public void testPerformPurchaseOrderFirstTransmitViaPrinting() throws Exception {
        PurchaseOrderDocument po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        po.setApplicationDocumentStatus("Open");
        po.refreshNonUpdateableReferences();
        po.prepareForSave();
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)po, (DocumentService)this.docService);
        try {
            this.poService.performPurchaseOrderFirstTransmitViaPrinting(po);
            PurchaseOrderServiceIntegTest.assertTrue((po.getPurchaseOrderFirstTransmissionTimestamp() != null ? 1 : 0) != 0);
            PurchaseOrderServiceIntegTest.assertTrue((po.getPurchaseOrderLastTransmitTimestamp() != null ? 1 : 0) != 0);
        }
        catch (ValidationException e) {
            LOG.warn("Caught ValidationException while trying to retransmit PO with doc id " + po.getDocumentNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPerformPurchaseOrderPreviewPrinting() throws Exception {
        PurchaseOrderDocument po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        po.setApplicationDocumentStatus("Open");
        po.refreshNonUpdateableReferences();
        po.prepareForSave();
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)po, (DocumentService)this.docService);
        ByteArrayOutputStream baosPDF = new ByteArrayOutputStream();
        try {
            DateTimeService dtService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
            StringBuffer sbFilename = new StringBuffer();
            sbFilename.append("PURAP_PO_QUOTE_REQUEST_LIST");
            sbFilename.append(po.getPurapDocumentIdentifier());
            sbFilename.append("_");
            sbFilename.append(dtService.getCurrentDate().getTime());
            sbFilename.append(".pdf");
            this.poService.performPurchaseOrderPreviewPrinting(po.getDocumentNumber(), baosPDF);
            PurchaseOrderServiceIntegTest.assertTrue((baosPDF.size() > 0 ? 1 : 0) != 0);
        }
        catch (ValidationException e) {
            LOG.warn("Caught ValidationException while trying to retransmit PO with doc id " + po.getDocumentNumber());
        }
        finally {
            if (baosPDF != null) {
                baosPDF.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPerformPrintPurchaseOrderPDFOnly() throws Exception {
        PurchaseOrderDocument po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        po.setApplicationDocumentStatus("Open");
        po.refreshNonUpdateableReferences();
        po.prepareForSave();
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)po, (DocumentService)this.docService);
        ByteArrayOutputStream baosPDF = new ByteArrayOutputStream();
        try {
            DateTimeService dtService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
            StringBuffer sbFilename = new StringBuffer();
            sbFilename.append("PURAP_PO_QUOTE_REQUEST_LIST");
            sbFilename.append(po.getPurapDocumentIdentifier());
            sbFilename.append("_");
            sbFilename.append(dtService.getCurrentDate().getTime());
            sbFilename.append(".pdf");
            this.poService.performPrintPurchaseOrderPDFOnly(po.getDocumentNumber(), baosPDF);
            PurchaseOrderServiceIntegTest.assertTrue((baosPDF.size() > 0 ? 1 : 0) != 0);
        }
        catch (ValidationException e) {
            LOG.warn("Caught ValidationException while trying to retransmit PO with doc id " + po.getDocumentNumber());
        }
        finally {
            if (baosPDF != null) {
                baosPDF.reset();
            }
        }
    }

    public void testCompletePurchaseOrder_NonB2B() throws Exception {
        PurchaseOrderDocument po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        po.setApplicationDocumentStatus("In Process");
        po.refreshNonUpdateableReferences();
        po.prepareForSave();
        AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)po, (DocumentService)this.docService);
        this.poService.completePurchaseOrder(po);
        PurchaseOrderServiceIntegTest.assertEquals((String)po.getApplicationDocumentStatus(), (String)"Open");
        PurchaseOrderServiceIntegTest.assertTrue((boolean)po.isPurchaseOrderCurrentIndicator());
        PurchaseOrderServiceIntegTest.assertNotNull((Object)po.getPurchaseOrderInitialOpenTimestamp());
    }

    public void testCompletePurchaseOrder_B2B() throws Exception {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_B2B_WITH_PO_VENDOR.createRequisitionDocument();
        String docId = requisitionDocument.getDocumentNumber();
        this.routeRequisition(requisitionDocument);
        this.poService.createAutomaticPurchaseOrderDocument(requisitionDocument);
        requisitionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
        String poDocId = ((PurchaseOrderView)requisitionDocument.getRelatedViews().getRelatedPurchaseOrderViews().get(0)).getDocumentNumber();
        PurchaseOrderDocument purchaseOrderDocument = (PurchaseOrderDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(poDocId);
        WorkflowTestUtils.waitForDocumentApproval((String)purchaseOrderDocument.getDocumentNumber());
        this.poService.completePurchaseOrder(purchaseOrderDocument);
        PurchaseOrderServiceIntegTest.assertEquals((String)purchaseOrderDocument.getApplicationDocumentStatus(), (String)"Open");
        PurchaseOrderServiceIntegTest.assertTrue((boolean)purchaseOrderDocument.isPurchaseOrderCurrentIndicator());
        PurchaseOrderServiceIntegTest.assertNotNull((Object)purchaseOrderDocument.getPurchaseOrderInitialOpenTimestamp());
    }

    public void testIsPurchaseOrderOpenForProcessing_HappyPath() throws Exception {
        PurchaseOrderDocument poDocument = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS.createPurchaseOrderDocument();
        poDocument.prepareForSave();
        PurchaseOrderServiceIntegTest.assertFalse((boolean)DocumentStatus.ENROUTE.equals((Object)poDocument.getDocumentHeader().getWorkflowDocument().getStatus()));
        this.routePurchaseOrder(poDocument);
        WorkflowTestUtils.waitForDocumentApproval((String)poDocument.getDocumentNumber());
        PurchaseOrderServiceIntegTest.assertTrue((boolean)this.poService.isPurchaseOrderOpenForProcessing(poDocument.getPurapDocumentIdentifier()));
    }

    @ConfigureContext(session=UserNameFixture.appleton, shouldCommitTransactions=true)
    public void testIsPurchaseOrderOpenForProcessing_With_PREQ() throws Exception {
        PaymentRequestDocumentIntegTest preqDocTest = new PaymentRequestDocumentIntegTest();
        PurchaseOrderDocument purchaseOrderDocument = preqDocTest.createPurchaseOrderDocument(PurchaseOrderDocumentFixture.PO_APPROVAL_REQUIRED, true, new Integer(((SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class)).getNextAvailableSequenceNumber("AP_PUR_DOC_LNK_ID").toString()));
        PaymentRequestDocument paymentRequestDocument = preqDocTest.createPaymentRequestDocument(PaymentRequestDocumentFixture.PREQ_APPROVAL_REQUIRED, purchaseOrderDocument, true, new KualiDecimal[]{new KualiDecimal(100)});
        paymentRequestDocument.setAccountsPayablePurchasingDocumentLinkIdentifier(purchaseOrderDocument.getAccountsPayablePurchasingDocumentLinkIdentifier());
        paymentRequestDocument.setApplicationDocumentStatus("In Process");
        this.docService.saveDocument((Document)paymentRequestDocument);
        PurchaseOrderServiceIntegTest.assertFalse((boolean)this.poService.isPurchaseOrderOpenForProcessing(purchaseOrderDocument));
    }
}

