/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.fp.document.DisbursementVoucherDocument;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.ReceivingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.document.service.impl.PurchasingAccountsPayableModuleServiceImpl;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PurchasingAccountsPayableModuleServiceImplTest {
    private static final Integer REQUISITION_IDENTIFIER = 12345;
    private static final String REQUISITION_INITIATOR = "mbaxter";
    private static final String DOCUMENT_NUMBER = "123456";
    private static final String PREQ_NOTE_TEXT = "PREQ reissued inside PDP.";
    private static final String CM_NOTE_TEXT = "CM reissued inside PDP.";
    @Spy
    private PurchasingAccountsPayableModuleServiceImpl cutSpy = new PurchasingAccountsPayableModuleServiceImpl();
    @Mock
    private Document documentMock;
    @Mock
    private AccountsPayableDocument accountsPayableDocumentMock;
    @Mock
    private DocumentHeader documentHeaderMock;
    @Mock
    private PaymentRequestDocument paymentRequestDocumentMock;
    @Mock
    private PurchaseOrderDocument purchaseOrderDocumentMock;
    @Mock
    private RequisitionDocument requisitionDocumentMock;
    @Mock
    private RequisitionService requisitionSvcMock;
    @Mock
    private VendorCreditMemoDocument vendorCreditMemoDocumentMock;
    @Mock
    private DisbursementVoucherDocument disbursementVoucherDocumentMock;
    @Mock
    private ReceivingDocument receivingDocumentMock;
    @Mock
    private WorkflowDocument workflowDocumentMock;
    @Mock
    private ParameterService parameterServiceMock;
    @Mock
    private PaymentRequestService paymentRequestServiceMock;
    @Mock
    private CreditMemoService creditMemoServiceMock;
    @Mock
    private DocumentService documentServiceMock;
    @Mock
    private NoteService noteServiceMock;
    @Mock
    private AccountsPayableService accountsPayableServiceMock;
    @Mock
    private Note noteMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.paymentRequestDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocumentMock);
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocumentMock);
        Mockito.when((Object)this.purchaseOrderDocumentMock.getRequisitionIdentifier()).thenReturn((Object)REQUISITION_IDENTIFIER);
        Mockito.when((Object)this.requisitionSvcMock.getRequisitionById(REQUISITION_IDENTIFIER)).thenReturn((Object)this.requisitionDocumentMock);
        Mockito.when((Object)this.requisitionDocumentMock.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        Mockito.when((Object)this.workflowDocumentMock.getInitiatorPrincipalId()).thenReturn((Object)REQUISITION_INITIATOR);
        Mockito.when((Object)this.accountsPayableDocumentMock.getPurchaseOrderDocument()).thenReturn(null);
        ((ParameterService)Mockito.doReturn((Object)PREQ_NOTE_TEXT).when((Object)this.parameterServiceMock)).getParameterValueAsString(PaymentRequestDocument.class, "REISSUE_NOTE");
        ((ParameterService)Mockito.doReturn((Object)CM_NOTE_TEXT).when((Object)this.parameterServiceMock)).getParameterValueAsString(VendorCreditMemoDocument.class, "REISSUE_NOTE");
        ((PaymentRequestService)Mockito.doReturn((Object)this.paymentRequestDocumentMock).when((Object)this.paymentRequestServiceMock)).getPaymentRequestByDocumentNumber(DOCUMENT_NUMBER);
        ((CreditMemoService)Mockito.doReturn((Object)this.vendorCreditMemoDocumentMock).when((Object)this.creditMemoServiceMock)).getCreditMemoByDocumentNumber(DOCUMENT_NUMBER);
        ((PurchasingAccountsPayableModuleServiceImpl)Mockito.doReturn((Object)"2").when((Object)this.cutSpy)).getSystemUserPrincipalId();
        Mockito.when((Object)this.documentServiceMock.createNoteFromDocument((Document)Mockito.any(), Mockito.anyString())).thenReturn((Object)this.noteMock);
        this.cutSpy.setRequisitionService(this.requisitionSvcMock);
        this.cutSpy.setParameterService(this.parameterServiceMock);
        this.cutSpy.setPaymentRequestService(this.paymentRequestServiceMock);
        this.cutSpy.setCreditMemoService(this.creditMemoServiceMock);
        this.cutSpy.setDocumentService(this.documentServiceMock);
        this.cutSpy.setNoteService(this.noteServiceMock);
        this.cutSpy.setAccountsPayableService(this.accountsPayableServiceMock);
    }

    @Test
    public void determineRelatedRequisitionInitiatorPrincipalId_NoRelatedREQ() {
        Assert.assertNull((Object)this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId(this.documentMock));
    }

    @Test
    public void determineRelatedRequisitionInitiatorPrincipalId_AccountsPayable_NoPO() {
        Assert.assertNull((Object)this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)this.accountsPayableDocumentMock));
    }

    @Test
    public void determineRelatedRequisitionInitiatorPrincipalId_PREQ_HasRelatedREQ() {
        String principalId = this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)this.paymentRequestDocumentMock);
        Assert.assertEquals((Object)REQUISITION_INITIATOR, (Object)principalId);
    }

    @Test
    public void determineRelatedRequisitionInitiatorPrincipalId_CM_HasRelatedREQ() {
        String principalId = this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)this.vendorCreditMemoDocumentMock);
        Assert.assertEquals((Object)REQUISITION_INITIATOR, (Object)principalId);
    }

    @Test
    public void determineRelatedRequisitionInitiatorPrincipalId_PO_HasRelatedREQ() {
        String principalId = this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)this.purchaseOrderDocumentMock);
        Assert.assertEquals((Object)REQUISITION_INITIATOR, (Object)principalId);
    }

    @Test
    public void determineRelatedRequisitionInitiatorPrincipalId_REQS_NoRelatedREQ() {
        Assert.assertNull((Object)this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)this.requisitionDocumentMock));
    }

    @Test
    public void determineRelatedRequisitionInitiatorPrincipalId_Not_PREQ_CM_PO() {
        Assert.assertNull((Object)this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)this.receivingDocumentMock));
    }

    @Test
    public void determineRelatedRequisitionInitiatorPrincipalId_NotPurapDocument() {
        Assert.assertNull((Object)this.cutSpy.determineRelatedRequisitionInitiatorPrincipalId((Document)this.disbursementVoucherDocumentMock));
    }

    @Test
    public void handlePurchasingBatchReissue_PREQ() {
        ((PaymentRequestDocument)Mockito.doReturn((Object)"Cancelled").when((Object)this.paymentRequestDocumentMock)).getApplicationDocumentStatus();
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "PREQ");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).createNoteFromDocument((Document)this.paymentRequestDocumentMock, PREQ_NOTE_TEXT);
        ((NoteService)Mockito.verify((Object)this.noteServiceMock)).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock)).revertToPreviousAppDocStatus((AccountsPayableDocument)this.paymentRequestDocumentMock);
        ((Note)Mockito.verify((Object)this.noteMock)).setAuthorUniversalIdentifier("2");
    }

    @Test
    public void handlePurchasingBatchReissue_PREQ_notFound() {
        ((PaymentRequestService)Mockito.doReturn(null).when((Object)this.paymentRequestServiceMock)).getPaymentRequestByDocumentNumber(DOCUMENT_NUMBER);
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "PREQ");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).createNoteFromDocument((Document)ArgumentMatchers.any(), (String)ArgumentMatchers.any(String.class));
        ((NoteService)Mockito.verify((Object)this.noteServiceMock, (VerificationMode)Mockito.never())).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock, (VerificationMode)Mockito.never())).revertToPreviousAppDocStatus((AccountsPayableDocument)ArgumentMatchers.any());
    }

    @Test
    public void handlePurchasingBatchReissue_PREQ_wrong_status() {
        ((PaymentRequestDocument)Mockito.doReturn((Object)"Department-Approved").when((Object)this.paymentRequestDocumentMock)).getApplicationDocumentStatus();
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "PREQ");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).createNoteFromDocument((Document)ArgumentMatchers.any(PaymentRequestDocument.class), (String)ArgumentMatchers.any(String.class));
        ((NoteService)Mockito.verify((Object)this.noteServiceMock, (VerificationMode)Mockito.never())).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock, (VerificationMode)Mockito.never())).revertToPreviousAppDocStatus((AccountsPayableDocument)ArgumentMatchers.any(PaymentRequestDocument.class));
    }

    @Test
    public void handlePurchasingBatchReissue_CM() {
        ((VendorCreditMemoDocument)Mockito.doReturn((Object)"Cancelled").when((Object)this.vendorCreditMemoDocumentMock)).getApplicationDocumentStatus();
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "CM");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).createNoteFromDocument((Document)this.vendorCreditMemoDocumentMock, CM_NOTE_TEXT);
        ((NoteService)Mockito.verify((Object)this.noteServiceMock)).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock)).revertToPreviousAppDocStatus((AccountsPayableDocument)this.vendorCreditMemoDocumentMock);
    }

    @Test
    public void handlePurchasingBatchReissue_CM_wrong_status() {
        ((VendorCreditMemoDocument)Mockito.doReturn((Object)"Complete").when((Object)this.vendorCreditMemoDocumentMock)).getApplicationDocumentStatus();
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "CM");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).createNoteFromDocument((Document)ArgumentMatchers.any(VendorCreditMemoDocument.class), (String)ArgumentMatchers.any(String.class));
        ((NoteService)Mockito.verify((Object)this.noteServiceMock, (VerificationMode)Mockito.never())).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock, (VerificationMode)Mockito.never())).revertToPreviousAppDocStatus((AccountsPayableDocument)ArgumentMatchers.any(VendorCreditMemoDocument.class));
    }

    @Test
    public void handlePurchasingBatchReissue_CM_notFound() {
        ((CreditMemoService)Mockito.doReturn(null).when((Object)this.creditMemoServiceMock)).getCreditMemoByDocumentNumber(DOCUMENT_NUMBER);
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "CM");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).createNoteFromDocument((Document)ArgumentMatchers.any(), (String)ArgumentMatchers.any(String.class));
        ((NoteService)Mockito.verify((Object)this.noteServiceMock, (VerificationMode)Mockito.never())).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock, (VerificationMode)Mockito.never())).revertToPreviousAppDocStatus((AccountsPayableDocument)ArgumentMatchers.any());
    }

    @Test
    public void handlePurchasingBatchReissue_Not_PREQ_CM() {
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "THLD");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).createNoteFromDocument((Document)ArgumentMatchers.any(), (String)ArgumentMatchers.any(String.class));
        ((NoteService)Mockito.verify((Object)this.noteServiceMock, (VerificationMode)Mockito.never())).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock, (VerificationMode)Mockito.never())).revertToPreviousAppDocStatus((AccountsPayableDocument)ArgumentMatchers.any());
    }

    @Test
    public void handlePurchasingBatchReissue_NotPurapDocument() {
        this.cutSpy.handlePurchasingBatchReissue(DOCUMENT_NUMBER, "DV");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.never())).createNoteFromDocument((Document)ArgumentMatchers.any(), (String)ArgumentMatchers.any(String.class));
        ((NoteService)Mockito.verify((Object)this.noteServiceMock, (VerificationMode)Mockito.never())).save((Note)ArgumentMatchers.any(Note.class));
        ((AccountsPayableService)Mockito.verify((Object)this.accountsPayableServiceMock, (VerificationMode)Mockito.never())).revertToPreviousAppDocStatus((AccountsPayableDocument)ArgumentMatchers.any());
    }
}

