/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.sql.Date;
import java.util.Calendar;
import java.util.Map;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.validation.PurapRuleIntegTestBase;
import org.kuali.kfs.module.purap.document.validation.impl.PaymentRequestDateForContinueValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PaymentRequestInvoiceValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PaymentRequestPayDateNotPastValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PaymentRequestTaxAreaValidation;
import org.kuali.kfs.module.purap.fixture.PaymentRequestInvoiceTabFixture;
import org.kuali.kfs.module.purap.fixture.PaymentRequestTaxTabFixture;
import org.kuali.kfs.module.purap.util.TestPaymentRequestPayDateNotPastValidation;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.mockito.Mockito;
import org.springframework.util.AutoPopulatingList;

@ConfigureContext(session=UserNameFixture.appleton)
public class PaymentRequestDocumentRuleIntegTest
extends PurapRuleIntegTestBase {
    private DocumentService documentService;
    private Map<String, GenericValidation> validations;
    PaymentRequestDocument preq;

    protected void setUp() throws Exception {
        super.setUp();
        if (null == this.documentService) {
            this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        this.preq = (PaymentRequestDocument)this.documentService.getNewDocument(PaymentRequestDocument.class);
        this.validations = SpringContext.getBeansOfType(GenericValidation.class);
    }

    protected void tearDown() throws Exception {
        this.validations = null;
        this.preq = null;
        super.tearDown();
    }

    public void testProcessInvoiceValidation_With_All() {
        this.preq = PaymentRequestInvoiceTabFixture.WITH_POID_WITH_DATE_WITH_NUMBER_WITH_AMOUNT.populate(this.preq);
        PaymentRequestInvoiceValidation validation = (PaymentRequestInvoiceValidation)this.validations.get("PaymentRequest-invoiceValidation-test");
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
    }

    public void testProcessInvoiceValidation_Without_PO_ID() {
        this.preq = PaymentRequestInvoiceTabFixture.NO_POID_WITH_DATE_WITH_NUMBER_WITH_AMOUNT.populate(this.preq);
        PaymentRequestInvoiceValidation validation = (PaymentRequestInvoiceValidation)this.validations.get("PaymentRequest-invoiceValidation-test");
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
    }

    public void testProcessInvoiceValidation_Without_Date() {
        this.preq = PaymentRequestInvoiceTabFixture.WITH_POID_NO_DATE_WITH_NUMBER_WITH_AMOUNT.populate(this.preq);
        PaymentRequestInvoiceValidation validation = (PaymentRequestInvoiceValidation)this.validations.get("PaymentRequest-invoiceValidation-test");
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
    }

    public void testProcessInvoiceValidation_Without_Number() {
        this.preq = PaymentRequestInvoiceTabFixture.WITH_POID_WITH_DATE_NO_NUMBER_WITH_AMOUNT.populate(this.preq);
        PaymentRequestInvoiceValidation validation = (PaymentRequestInvoiceValidation)this.validations.get("PaymentRequest-invoiceValidation-test");
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
    }

    public void testProcessInvoiceValidation_Without_Amount() {
        this.preq = PaymentRequestInvoiceTabFixture.WITH_POID_WITH_DATE_WITH_NUMBER_NO_AMOUNT.populate(this.preq);
        PaymentRequestInvoiceValidation validation = (PaymentRequestInvoiceValidation)this.validations.get("PaymentRequest-invoiceValidation-test");
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
    }

    private Date getDateFromOffsetFromToday(int offsetDays) {
        Calendar calendar = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentCalendar();
        calendar.add(5, offsetDays);
        return new Date(calendar.getTimeInMillis());
    }

    public void testProcessPaymentRequestDateValidationForContinue_BeforeToday() {
        this.preq = PaymentRequestInvoiceTabFixture.WITH_POID_WITH_DATE_WITH_NUMBER_WITH_AMOUNT.populate(this.preq);
        Date yesterday = this.getDateFromOffsetFromToday(-1);
        this.preq.setInvoiceDate(yesterday);
        PaymentRequestDateForContinueValidation validation = (PaymentRequestDateForContinueValidation)this.validations.get("PaymentRequest-dateForContinueValidation-test");
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
    }

    public void testProcessPaymentRequestDateValidationForContinue_AfterToday() {
        this.preq = PaymentRequestInvoiceTabFixture.WITH_POID_WITH_DATE_WITH_NUMBER_WITH_AMOUNT.populate(this.preq);
        Date tomorrow = this.getDateFromOffsetFromToday(1);
        this.preq.setInvoiceDate(tomorrow);
        PaymentRequestDateForContinueValidation validation = (PaymentRequestDateForContinueValidation)this.validations.get("PaymentRequest-dateForContinueValidation-test");
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
    }

    public void testProcessPaymentRequestDateValidationForContinue_Today() {
        this.preq = PaymentRequestInvoiceTabFixture.WITH_POID_WITH_DATE_WITH_NUMBER_WITH_AMOUNT.populate(this.preq);
        Date today = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
        this.preq.setInvoiceDate(today);
        PaymentRequestDateForContinueValidation validation = (PaymentRequestDateForContinueValidation)this.validations.get("PaymentRequest-dateForContinueValidation-test");
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
    }

    public void testValidatePaymentRequestDates_PastAndInitiatedDocument() throws Exception {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        PaymentRequestService paymentRequestService = (PaymentRequestService)SpringContext.getBean(PaymentRequestService.class);
        Date yesterday = this.getDateFromOffsetFromToday(-1);
        PaymentRequestDocumentRuleIntegTest.assertFalse((String)"Something is wrong with the test.  Error map was not empty before document saving called", (boolean)GlobalVariables.getMessageMap().hasErrors());
        PaymentRequestDocument document1 = (PaymentRequestDocument)documentService.getNewDocument(PaymentRequestDocument.class);
        document1.setPaymentRequestPayDate(yesterday);
        PaymentRequestPayDateNotPastValidation validation = (PaymentRequestPayDateNotPastValidation)this.validations.get("PaymentRequest-payDateNotPastValidation-test");
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document1)));
        AutoPopulatingList l = GlobalVariables.getMessageMap().getMessages("document.paymentRequestPayDate");
        boolean correctError = false;
        for (ErrorMessage m : l) {
            if (!"errors.invalid.pay.date".equals(m.getErrorKey())) continue;
            correctError = true;
            break;
        }
        PaymentRequestDocumentRuleIntegTest.assertTrue((String)"Unable to find error message key 'errors.invalid.pay.date'", (boolean)correctError);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    public void testValidatePaymentRequestDates_PastAndPersistedDocument() throws Exception {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        Date yesterday = this.getDateFromOffsetFromToday(-1);
        TestPaymentRequestPayDateNotPastValidation validation = (TestPaymentRequestPayDateNotPastValidation)this.validations.get("TestPaymentRequest-payDateNotPastValidation-test");
        validation.setTestDate(yesterday);
        WorkflowDocument workflowDocument = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        PaymentRequestDocument document2 = (PaymentRequestDocument)documentService.getNewDocument(PaymentRequestDocument.class);
        document2.getDocumentHeader().setWorkflowDocument(workflowDocument);
        document2.setPaymentRequestPayDate(yesterday);
        PaymentRequestDocumentRuleIntegTest.assertTrue((String)"Didn't change past pay date, so doucment should validate successfully.", (boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document2)));
        PaymentRequestDocumentRuleIntegTest.assertFalse((String)("Error map should be empty: " + GlobalVariables.getMessageMap().getErrorMessages()), (boolean)GlobalVariables.getMessageMap().hasErrors());
        document2.setPaymentRequestPayDate(this.getDateFromOffsetFromToday(-2));
        PaymentRequestDocumentRuleIntegTest.assertFalse((String)"changed past pay date to another past pay date, so document should fail.", (boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document2)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((String)"Error map should not be empty", (boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        document2.setPaymentRequestPayDate(this.getDateFromOffsetFromToday(3));
        PaymentRequestDocumentRuleIntegTest.assertTrue((String)"Changed past pay date to future, so doucment should validate successfully.", (boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document2)));
        PaymentRequestDocumentRuleIntegTest.assertFalse((String)("Error map should be empty: " + GlobalVariables.getMessageMap().getErrorMessages()), (boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    public void testValidatePaymentRequestDates_FutureAndPersistedDocument() throws Exception {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        Date tomorrow = this.getDateFromOffsetFromToday(1);
        TestPaymentRequestPayDateNotPastValidation validation = (TestPaymentRequestPayDateNotPastValidation)this.validations.get("TestPaymentRequest-payDateNotPastValidation-test");
        validation.setTestDate(tomorrow);
        WorkflowDocument workflowDocument = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        PaymentRequestDocument document2 = (PaymentRequestDocument)documentService.getNewDocument(PaymentRequestDocument.class);
        document2.getDocumentHeader().setWorkflowDocument(workflowDocument);
        document2.setPaymentRequestPayDate(tomorrow);
        PaymentRequestDocumentRuleIntegTest.assertTrue((String)"Didn't change future pay date, so doucment should validate successfully.", (boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document2)));
        PaymentRequestDocumentRuleIntegTest.assertFalse((String)("Error map should be empty: " + GlobalVariables.getMessageMap().getErrorMessages()), (boolean)GlobalVariables.getMessageMap().hasErrors());
        document2.setPaymentRequestPayDate(this.getDateFromOffsetFromToday(-2));
        PaymentRequestDocumentRuleIntegTest.assertFalse((String)"changed future pay date to  past pay date, so document should fail.", (boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document2)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((String)"Error map should not be empty", (boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        document2.setPaymentRequestPayDate(this.getDateFromOffsetFromToday(3));
        PaymentRequestDocumentRuleIntegTest.assertTrue((String)"Changed future pay date to another future date, so doucment should validate successfully.", (boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)document2)));
        PaymentRequestDocumentRuleIntegTest.assertFalse((String)("Error map should be empty: " + GlobalVariables.getMessageMap().getErrorMessages()), (boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    public void testValidatePaymentRequestDates_Today() {
        Date today = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
        this.preq.setPaymentRequestPayDate(today);
        PaymentRequestPayDateNotPastValidation validation = (PaymentRequestPayDateNotPastValidation)this.validations.get("PaymentRequest-payDateNotPastValidation-test");
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
    }

    public void testValidatePaymentRequestDates_Tomorrow() {
        Date tomorrow = this.getDateFromOffsetFromToday(1);
        this.preq.setPaymentRequestPayDate(tomorrow);
        PaymentRequestPayDateNotPastValidation validation = (PaymentRequestPayDateNotPastValidation)this.validations.get("PaymentRequest-payDateNotPastValidation-test");
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
    }

    public void testProcessPreCalculateTaxAreaBusinessRules() {
        MessageMap errMap = GlobalVariables.getMessageMap();
        String pre = "document.tax*.";
        PaymentRequestTaxAreaValidation validation = (PaymentRequestTaxAreaValidation)this.validations.get("PaymentRequest-taxAreaValidation-test");
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.INCOME_EMPTY.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxClassificationCode", "errors.paymentRequest.tax.field.required"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 1 ? 1 : 0) != 0);
        PaymentRequestTaxTabFixture.INCOME_N_OTHERS_EMPTY.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.INCOME_N_OTHERS_NOTEMPTY.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxFederalPercent", "errors.paymentRequest.tax.field.disallowed.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxStatePercent", "errors.paymentRequest.tax.field.disallowed.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxCountryCode", "errors.paymentRequest.tax.field.disallowed.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxNQIId", "errors.paymentRequest.tax.field.disallowed.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 7 ? 1 : 0) != 0);
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.INCOME_NOTN_TAX_COUNTRY_EMPTY.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxFederalPercent", "errors.paymentRequest.tax.field.required.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxStatePercent", "errors.paymentRequest.tax.field.required.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxCountryCode", "errors.paymentRequest.tax.field.required.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 3 ? 1 : 0) != 0);
        PaymentRequestTaxTabFixture.INCOME_F_TAX_VALID.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.INCOME_F_FED_INVALID.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxFederalPercent", "errors.paymentRequest.tax.field.value.invalid.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 1 ? 1 : 0) != 0);
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.INCOME_F_ST_INVALID.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxStatePercent", "errors.paymentRequest.tax.field.value.invalid.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 1 ? 1 : 0) != 0);
        PaymentRequestTaxTabFixture.INCOME_I_TAX_VALID.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.INCOME_I_FED_INVALID.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxFederalPercent", "errors.paymentRequest.tax.field.value.invalid.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 1 ? 1 : 0) != 0);
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.INCOME_I_ST_INVALID.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxStatePercent", "errors.paymentRequest.tax.field.value.invalid.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 1 ? 1 : 0) != 0);
        PaymentRequestTaxTabFixture.INCOME_R_TAX_VALID.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.INCOME_R_FED_INVALID.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxFederalPercent", "errors.paymentRequest.tax.field.value.invalid.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 1 ? 1 : 0) != 0);
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.INCOME_R_ST_INVALID.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxStatePercent", "errors.paymentRequest.tax.field.value.invalid.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 1 ? 1 : 0) != 0);
        PaymentRequestTaxTabFixture.FED_ZERO_ST_ZERO.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.FFD_ZERO_ST_NOTZERO.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 1 ? 1 : 0) != 0);
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.FED_NOTZERO_ST_ZERO.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxStatePercent", "errors.paymentRequest.tax.rate.must.not.zero.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 1 ? 1 : 0) != 0);
        PaymentRequestTaxTabFixture.GROSS_TAX_NOTZERO.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.GROSS_TAX_ZERO.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxFederalPercent", "errors.paymentRequest.tax.rate.must.not.zero.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 1 ? 1 : 0) != 0);
        PaymentRequestTaxTabFixture.FOREIGN_TAX_ZERO.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.FOREIGN_TAX_NOTZERO.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 2 ? 1 : 0) != 0);
        PaymentRequestTaxTabFixture.USAID_OTHER_INCOME_F_TAX_ZERO.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.USAID_INCOME_NOTF_TAX_NOTZERO.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxOtherExemptIndicator", "errors.paymentRequest.tax.field.required.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxClassificationCode", "errors.paymentRequest.tax.field.value.invalid.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 3 ? 1 : 0) != 0);
        PaymentRequestTaxTabFixture.OTHER_TAX_ZERO.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.OTHER_TAX_NOTZERO.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 1 ? 1 : 0) != 0);
        PaymentRequestTaxTabFixture.SW4_INCOME_F_TAX_ZERO.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.SW4_NEG_INCOME_NOTF_TAX_NOTZERO.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxSpecialW4Amount", "errors.paymentRequest.tax.field.value.must.not.negative"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxClassificationCode", "errors.paymentRequest.tax.field.value.invalid.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((errMap.getErrorCount() == 3 ? 1 : 0) != 0);
        errMap.clearErrorMessages();
        PaymentRequestTaxTabFixture.SW4_TREATY_GROSS_FOREIGN_USAID_OTHER.populate(this.preq);
        PaymentRequestDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.preq)));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxGrossUpIndicator", "errors.paymentRequest.tax.field.disallowed.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxForeignSourceIndicator", "errors.paymentRequest.tax.field.disallowed.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxUSAIDPerDiemIndicator", "errors.paymentRequest.tax.field.disallowed.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxOtherExemptIndicator", "errors.paymentRequest.tax.field.disallowed.if"));
        PaymentRequestDocumentRuleIntegTest.assertTrue((boolean)errMap.fieldHasMessage(pre + "taxSpecialW4Amount", "errors.paymentRequest.tax.field.disallowed.if"));
    }
}

