/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.document.validation.impl.PaymentRequestProcessItemValidation;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PaymentRequestProcessItemValidationTest {
    @Mock
    private PaymentRequestItem paymentRequestItemMock;
    private PaymentRequestProcessItemValidation cut;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PaymentRequestProcessItemValidation();
    }

    @Test
    public void validateItemWithoutAccounts_ValidExtendedCost_AccountListNotEmpty_ReturnsTrue() {
        Mockito.when((Object)this.paymentRequestItemMock.getExtendedPrice()).thenReturn((Object)new KualiDecimal(70));
        Mockito.when((Object)this.paymentRequestItemMock.isAccountListEmpty()).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.cut.validateItemWithoutAccounts(this.paymentRequestItemMock, "foo"));
    }

    @Test
    public void validateItemWithoutAccounts_ValidExtendedCost_NoAccount_ReturnsFalse() {
        Mockito.when((Object)this.paymentRequestItemMock.getExtendedPrice()).thenReturn((Object)new KualiDecimal(70));
        Mockito.when((Object)this.paymentRequestItemMock.isAccountListEmpty()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cut.validateItemWithoutAccounts(this.paymentRequestItemMock, "foo"));
    }

    @Test
    public void validateItemWithoutAccounts_NullExtendedCost_ReturnsTrue() {
        Mockito.when((Object)this.paymentRequestItemMock.getExtendedPrice()).thenReturn(null);
        Assert.assertTrue((boolean)this.cut.validateItemWithoutAccounts(this.paymentRequestItemMock, "foo"));
    }
}

