/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Map;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.document.PurchaseOrderAmendmentDocument;
import org.kuali.kfs.module.purap.document.validation.PurapRuleIntegTestBase;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderAmendmentDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.kfs.sys.document.validation.impl.CompositeValidation;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.parke)
public class PurchaseOrderAmendmentRuleIntegTest
extends PurapRuleIntegTestBase {
    private Map<String, CompositeValidation> validations;
    PurchaseOrderAmendmentDocument poAmendment;

    protected void setUp() throws Exception {
        super.setUp();
        this.poAmendment = new PurchaseOrderAmendmentDocument();
        this.validations = SpringContext.getBeansOfType(CompositeValidation.class);
    }

    protected void tearDown() throws Exception {
        this.validations = null;
        this.poAmendment = null;
        super.tearDown();
    }

    private void savePO(PurchaseOrderAmendmentDocument poAmend) {
        poAmend.prepareForSave();
        try {
            AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)poAmend, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
        }
        catch (Exception e) {
            throw new RuntimeException("Problems saving PO: " + e);
        }
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public void testAmendmentValidate_Open() {
        this.poAmendment = PurchaseOrderAmendmentDocumentFixture.PO_AMEND_STATUS_OPEN.createPurchaseOrderAmendmentDocument();
        this.savePO(this.poAmendment);
        CompositeValidation validation = this.validations.get("PurchaseOrderAmendment-routeDocumentValidation");
        PurchaseOrderAmendmentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.poAmendment)));
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public void testAmendmentValidate_NoItem() {
        this.poAmendment = PurchaseOrderAmendmentDocumentFixture.PO_AMEND_STATUS_OPEN.createPurchaseOrderAmendmentDocument();
        this.poAmendment.deleteItem(0);
        this.savePO(this.poAmendment);
        CompositeValidation validation = this.validations.get("PurchaseOrderAmendment-routeDocumentValidation");
        PurchaseOrderAmendmentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.poAmendment)));
    }
}

