/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.impl.PurchaseOrderServiceImpl;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderSplitValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PurchaseOrderSplitValidationTest {
    private PurchaseOrderSplitValidation cut;
    @Mock
    private ItemType itemTypeMock;
    @Mock
    private PurchaseOrderDocument poDocMock;
    private PurchaseOrderItem poItem1;
    private PurchaseOrderItem poItem2;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupPoItems();
        this.cut = new PurchaseOrderSplitValidation();
        this.cut.setPurchaseOrderService((PurchaseOrderService)new PurchaseOrderServiceImpl());
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private void setupPoItems() {
        this.itemTypeMock = (ItemType)Mockito.mock(ItemType.class);
        Mockito.when((Object)this.itemTypeMock.isLineItemIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.itemTypeMock.getItemTypeCode()).thenReturn((Object)"ITEM");
        this.poItem1 = this.setupPoItem();
        this.poItem2 = this.setupPoItem();
        Mockito.when((Object)this.poDocMock.getItems()).thenReturn(Arrays.asList(this.poItem1, this.poItem2));
    }

    private PurchaseOrderItem setupPoItem() {
        PurchaseOrderItem poItem = new PurchaseOrderItem();
        poItem.setItemType(this.itemTypeMock);
        poItem.setItemTypeCode("ITEM");
        return poItem;
    }

    @Test
    public void validate_OneMovingOneRemaining() {
        this.poItem1.setMovingToSplit(true);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.poDocMock)));
    }

    @Test
    public void validate_NoneMovingTwoRemaining() {
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.poDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.splitPurchaseOrder", "error.purchaseOrder.split.atLeastOneItem.mustMove"));
    }

    @Test
    public void validate_TwoMovingNoneRemaining() {
        this.poItem1.setMovingToSplit(true);
        this.poItem2.setMovingToSplit(true);
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.poDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.splitPurchaseOrder", "error.purchaseOrder.split.atLeastOneItem.mustRemain"));
    }
}

