/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableUniqueAccountingStringsValidation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PurchasingAccountsPayableUniqueAccountingStringsValidationTest {
    protected PurchasingAccountsPayableUniqueAccountingStringsValidation cut;
    @Mock
    protected PurApItem purApItemMock;
    @Spy
    protected PurchaseOrderAccount purchaseOrderAccount1Spy;
    @Spy
    protected PurchaseOrderAccount purchaseOrderAccount2Spy;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PurchasingAccountsPayableUniqueAccountingStringsValidation();
        ArrayList<PurchaseOrderAccount> sourceAccountingLines = new ArrayList<PurchaseOrderAccount>();
        this.partialMockSourceAccountingLine(this.purchaseOrderAccount1Spy);
        sourceAccountingLines.add(this.purchaseOrderAccount1Spy);
        this.partialMockSourceAccountingLine(this.purchaseOrderAccount2Spy);
        sourceAccountingLines.add(this.purchaseOrderAccount2Spy);
        Mockito.when((Object)this.purApItemMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        this.cut.setItemForValidation(this.purApItemMock);
    }

    private void partialMockSourceAccountingLine(PurchaseOrderAccount poa) {
        Mockito.when((Object)poa.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)poa.getAccountNumber()).thenReturn((Object)"1031400");
        Mockito.when((Object)poa.getFinancialObjectCode()).thenReturn((Object)"5000");
    }

    @Test
    public void validateTest_SHOULD_FAIL_WITHOUT_SEQUENCE_NUMBERS() {
        Assert.assertFalse((String)"Accounting Lines match so validation should fail.", (boolean)this.cut.validate(null));
    }

    @Test
    public void validateTest_SHOULD_FAIL_WITH_DIFFERENT_SEQUENCE_NUMBERS() {
        Mockito.when((Object)this.purchaseOrderAccount1Spy.getSequenceNumber()).thenReturn((Object)1);
        Mockito.when((Object)this.purchaseOrderAccount2Spy.getSequenceNumber()).thenReturn((Object)2);
        Assert.assertFalse((String)"Accounting Lines match so validation should fail even if sequence numbers are different.", (boolean)this.cut.validate(null));
    }

    @Test
    public void validateTest_SHOULD_SUCCEED() {
        Mockito.when((Object)this.purchaseOrderAccount2Spy.getAccountNumber()).thenReturn((Object)"1024600");
        Assert.assertTrue((String)"Accounting Lines don't match so validation should succeed.", (boolean)this.cut.validate(null));
    }
}

