/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.sql.Date;
import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.impl.PaymentRequestServiceImpl;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoInitTabRequiredFieldsValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class VendorCreditMemoInitTabRequiredFieldsValidationTest {
    private VendorCreditMemoInitTabRequiredFieldsValidation cut;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private VendorCreditMemoDocument creditMemoDocMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupCreditMemoDocMock();
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(VendorCreditMemoDocument.class, "creditMemoDate")).thenReturn((Object)"Credit Memo Date");
        this.cut = new VendorCreditMemoInitTabRequiredFieldsValidation();
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cut.setPaymentRequestService((PaymentRequestService)new PaymentRequestServiceImpl());
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private void setupCreditMemoDocMock() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoNumber()).thenReturn((Object)"12345");
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoDate()).thenReturn((Object)Date.valueOf(LocalDate.now()));
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(1));
    }

    @Test
    public void validate_WithInvoiceWithTodayWithAmount() {
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    public void validate_WithInvoiceWithYesterdayWithAmount() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoDate()).thenReturn((Object)Date.valueOf(LocalDate.now().minusDays(1L)));
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    public void validate_WithInvoiceWithTomorrowWithAmount() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoDate()).thenReturn((Object)Date.valueOf(LocalDate.now().plusDays(1L)));
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.invalid.invoice.date"));
    }

    @Test
    public void validate_NoInvoiceWithTomorrowWithAmount() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoDate()).thenReturn((Object)Date.valueOf(LocalDate.now().plusDays(1L)));
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoNumber()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)2L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.invalid.invoice.date"));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("creditMemoNumber", "error.required"));
    }

    @Test
    public void validate_WithInvoiceWithTomorrowNoAmount() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoDate()).thenReturn((Object)Date.valueOf(LocalDate.now().plusDays(1L)));
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)2L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.invalid.invoice.date"));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("creditMemoAmount", "error.required"));
    }
}

