/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoItemQuantityValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class VendorCreditMemoItemQuantityValidationTest {
    private VendorCreditMemoItemQuantityValidation cut;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private VendorCreditMemoDocument creditMemoDocMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupCreditMemoDocMock();
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeErrorLabel(CreditMemoItem.class, "itemQuantity")).thenReturn((Object)"Quantity");
        this.cut = new VendorCreditMemoItemQuantityValidation();
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private void setupCreditMemoDocMock() {
        CreditMemoItem item = new CreditMemoItem();
        item.setItemLineNumber(Integer.valueOf(1));
        item.setItemTypeCode("ITEM");
        ItemType itemType = new ItemType();
        itemType.setItemTypeCode("ITEM");
        itemType.setQuantityBasedGeneralLedgerIndicator(true);
        item.setItemType(itemType);
        item.setExtendedPrice(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(1));
        Mockito.when((Object)this.creditMemoDocMock.getItemByLineNumber(1)).thenReturn((Object)item);
    }

    @Test
    public void validate_POType_EquivalentQuantity() {
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)99999);
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPoInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(1));
        this.cut.setItemForValidation(item);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    public void validate_PREQType_EquivalentQuantity() {
        Mockito.when((Object)this.creditMemoDocMock.getPaymentRequestIdentifier()).thenReturn((Object)9999);
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(1));
        this.cut.setItemForValidation(item);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    public void validate_POType_NullQuantity() {
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)99999);
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPoInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(null);
        this.cut.setItemForValidation(item);
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.item[0].itemQuantity", "error.required"));
    }

    @Test
    public void validate_PREQType_NullQuantity() {
        Mockito.when((Object)this.creditMemoDocMock.getPaymentRequestIdentifier()).thenReturn((Object)9999);
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(null);
        this.cut.setItemForValidation(item);
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.item[0].itemQuantity", "error.required"));
    }

    @Test
    public void validate_POType_NegativeQuantity() {
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)99999);
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPoInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(-1));
        this.cut.setItemForValidation(item);
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.creditMemo.itemAmount.aboveZero"));
    }

    @Test
    public void validate_PREQType_NegativeQuantity() {
        Mockito.when((Object)this.creditMemoDocMock.getPaymentRequestIdentifier()).thenReturn((Object)9999);
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(-1));
        this.cut.setItemForValidation(item);
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.creditMemo.itemAmount.aboveZero"));
    }

    @Test
    public void validate_POType_GreaterQuantity() {
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)99999);
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPoInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(2));
        this.cut.setItemForValidation(item);
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.creditMemo.item.quantity.tooMuch"));
    }

    @Test
    public void validate_PREQType_GreaterQuantity() {
        Mockito.when((Object)this.creditMemoDocMock.getPaymentRequestIdentifier()).thenReturn((Object)9999);
        CreditMemoItem item = (CreditMemoItem)this.creditMemoDocMock.getItemByLineNumber(1);
        item.setPreqInvoicedTotalQuantity(new KualiDecimal(1));
        item.setItemQuantity(new KualiDecimal(2));
        this.cut.setItemForValidation(item);
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.creditMemo.item.quantity.tooMuch"));
    }
}

