/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoTotalMatchesVendorAmountValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class VendorCreditMemoTotalMatchesVendorAmountValidationTest {
    private VendorCreditMemoTotalMatchesVendorAmountValidation cut;
    @Mock
    private VendorCreditMemoDocument creditMemoDocMock;
    private ErrorMessage expectedErrorMessage = new ErrorMessage("errors.creditMemo.vendorInvoiceAmount.invalid", new String[0]);

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new VendorCreditMemoTotalMatchesVendorAmountValidation();
        KNSGlobalVariables.getMessageList().clear();
    }

    @Test
    public void validate_GrandTotalMatchesAmount_isUseTax() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)this.creditMemoDocMock.getGrandPreTaxTotal()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)this.creditMemoDocMock.isUseTaxIndicator()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    public void validate_GrandTotalGreaterThanAmount_isUseTax() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)this.creditMemoDocMock.getGrandPreTaxTotal()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)this.creditMemoDocMock.isUseTaxIndicator()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertTrue((boolean)KNSGlobalVariables.getMessageList().contains((Object)this.expectedErrorMessage));
    }

    @Test
    public void validate_AmountGreaterThanGrandTotal_isUseTax() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)this.creditMemoDocMock.getGrandPreTaxTotal()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)this.creditMemoDocMock.isUseTaxIndicator()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertTrue((boolean)KNSGlobalVariables.getMessageList().contains((Object)this.expectedErrorMessage));
    }

    @Test
    public void validate_GrandTotalGreaterThanAmount_isUseTax_isUnmatchedOverride() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)this.creditMemoDocMock.getGrandPreTaxTotal()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)this.creditMemoDocMock.isUseTaxIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.creditMemoDocMock.isUnmatchedOverride()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    public void validate_AmountGreaterThanGrandTotal_isUseTax_isUnmatchedOverride() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)this.creditMemoDocMock.getGrandPreTaxTotal()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)this.creditMemoDocMock.isUseTaxIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.creditMemoDocMock.isUnmatchedOverride()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    public void validate_GrandTotalMatchesAmount() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)this.creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(32));
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    public void validate_GrandTotalGreaterThanAmount() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)this.creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(32));
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertTrue((boolean)KNSGlobalVariables.getMessageList().contains((Object)this.expectedErrorMessage));
    }

    @Test
    public void validate_AmountGreaterThanGrandTotal() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)this.creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(16));
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertTrue((boolean)KNSGlobalVariables.getMessageList().contains((Object)this.expectedErrorMessage));
    }

    @Test
    public void validate_GrandTotalGreaterThanAmount_isUnmatchedOverride() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)this.creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)this.creditMemoDocMock.isUnmatchedOverride()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    public void validate_AmountGreaterThanGrandTotal_isUnmatchedOverride() {
        Mockito.when((Object)this.creditMemoDocMock.getCreditMemoAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)this.creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(16));
        Mockito.when((Object)this.creditMemoDocMock.isUnmatchedOverride()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }
}

