/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.fixture;

import java.math.BigDecimal;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.sys.fixture.AccountingLineFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public enum PurApAccountingLineFixture {
    BASIC_ACCOUNT_1(null, null, new BigDecimal("100"), new KualiDecimal(10)),
    BASIC_ACCOUNT_2(null, null, new BigDecimal("100"), null),
    ACCOUNT_50_PERCENT(null, null, new BigDecimal("50"), null),
    ACCOUNT_ONE_THIRD(null, null, new BigDecimal("33.33"), null),
    ACCOUNT_ONE_THIRD_PLUS_ONE_HUNDREDTH(null, null, new BigDecimal("33.34"), null),
    REQ_ACCOUNT_MULTI(null, null, new BigDecimal("100"), null),
    BAD_ACCOUNT_PERCENT_TOO_HIGH(null, null, new BigDecimal("101"), null),
    BAD_ACCOUNT_PERCENT_ZERO(null, null, new BigDecimal("0"), null),
    BAD_ACCOUNT_PERCENT_NEGATIVE(null, null, new BigDecimal("-1"), null);

    private Integer accountIdentifier;
    private Integer itemIdentifier;
    private BigDecimal accountLinePercent;
    private KualiDecimal alternateAmountForGLEntryCreation;

    private PurApAccountingLineFixture(Integer accountIdentifier, Integer itemIdentifier, BigDecimal accountLinePercent, KualiDecimal alternateAmountForGLEntryCreation) {
        this.accountIdentifier = accountIdentifier;
        this.itemIdentifier = itemIdentifier;
        this.accountLinePercent = accountLinePercent;
        this.alternateAmountForGLEntryCreation = alternateAmountForGLEntryCreation;
    }

    public PurApAccountingLine createPurApAccountingLine(Class clazz, AccountingLineFixture alFixture) {
        PurApAccountingLine line;
        try {
            line = (PurApAccountingLine)alFixture.createAccountingLine(clazz, "D");
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("item creation failed. class = " + clazz);
        }
        line.setSequenceNumber(Integer.valueOf(0));
        line.setAccountIdentifier(this.accountIdentifier);
        line.setItemIdentifier(this.itemIdentifier);
        line.setAccountLinePercent(this.accountLinePercent);
        line.setAlternateAmountForGLEntryCreation(this.alternateAmountForGLEntryCreation);
        line.refreshNonUpdateableReferences();
        return line;
    }
}

