/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountRevisionService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl.PurapGeneralLedgerTest;
import org.kuali.kfs.module.purap.util.SummaryAccount;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SpringContext.class})
public class GenerateEntriesCancelPaymentRequestTest
extends PurapGeneralLedgerTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurchaseOrderService purchaseOrderSvcMock;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private PurapAccountRevisionService purapAccountRevisionSvcMock;
    @Mock
    private AccountService accountSvcMock;
    @Mock
    private PaymentRequestDocument paymentRequestDocMock;
    @Mock
    private PurchaseOrderDocument purchaseOrderDocMock;
    @Mock
    private DateTimeService dateTimeSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurchaseOrderService(this.purchaseOrderSvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        this.cut.setPurapAccountRevisionService(this.purapAccountRevisionSvcMock);
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
    }

    @Test
    public void noAccountingLines() {
        Mockito.when((Object)this.paymentRequestDocMock.getItems()).thenReturn(new ArrayList());
        Mockito.when((Object)this.paymentRequestDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1000);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1000))).thenReturn((Object)this.purchaseOrderDocMock);
        Mockito.when((Object)((PurchaseOrderDocument)this.boServiceMock.save((PersistableBusinessObject)this.purchaseOrderDocMock))).thenReturn((Object)this.purchaseOrderDocMock);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocMock)).thenReturn(new ArrayList());
        this.paymentRequestDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.paymentRequestDocMock.getDocumentNumber()).thenReturn((Object)"1000");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1000");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, matcher)).thenReturn((Object)0);
        Mockito.when((Object)this.paymentRequestDocMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocMock);
        Mockito.when((Object)this.purchaseOrderDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Cancelled");
        this.paymentRequestDocMock.setDebitCreditCodeForGLEntries("D");
        this.paymentRequestDocMock.setGenerateEncumbranceEntries(true);
        Mockito.when((Object)this.paymentRequestDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(new ArrayList());
        this.cut.generateEntriesCancelAccountsPayableDocument((AccountsPayableDocument)this.paymentRequestDocMock);
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setDebitCreditCodeForGLEntries(ArgumentMatchers.anyString());
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setGenerateEncumbranceEntries(ArgumentMatchers.anyBoolean());
        this.verifyCommon();
    }

    @Test
    public void items() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        PurApItem item1 = this.getPaymentRequestItem(this.paymentRequestDocMock, 1, KDONE, new BigDecimal("100.00"), "ITEM");
        items.add(item1);
        ArrayList<PurchaseOrderAccount> lines = new ArrayList<PurchaseOrderAccount>();
        lines.add(this.getPurchaseOrderAccount(KDTWO, KDONE));
        item1.setSourceAccountingLines(lines);
        Mockito.when((Object)this.paymentRequestDocMock.getItems()).thenReturn(items);
        Mockito.when((Object)this.paymentRequestDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1000);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1000))).thenReturn((Object)this.purchaseOrderDocMock);
        Mockito.when((Object)this.purchaseOrderDocMock.getItems()).thenReturn(new ArrayList());
        Mockito.when((Object)this.paymentRequestDocMock.isUseTaxIndicator()).thenReturn((Object)false);
        Mockito.when((Object)((PurchaseOrderDocument)this.boServiceMock.save((PersistableBusinessObject)this.purchaseOrderDocMock))).thenReturn((Object)this.purchaseOrderDocMock);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocMock)).thenReturn(new ArrayList());
        this.paymentRequestDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.paymentRequestDocMock.getDocumentNumber()).thenReturn((Object)"1000");
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1000");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, matcher)).thenReturn((Object)0);
        Mockito.when((Object)this.paymentRequestDocMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocMock);
        Mockito.when((Object)this.purchaseOrderDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Closed");
        Mockito.when((Object)this.paymentRequestDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)this.boServiceMock.save(new ArrayList())).thenReturn(new ArrayList());
        this.cut.generateEntriesCancelAccountsPayableDocument((AccountsPayableDocument)this.paymentRequestDocMock);
        ((PurchaseOrderDocument)Mockito.verify((Object)this.purchaseOrderDocMock)).getItems();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).isUseTaxIndicator();
        this.verifyCommon();
    }

    @Test
    public void itemsAccountingLines() {
        ArrayList<PurApItem> items = new ArrayList<PurApItem>();
        PurApItem item1 = this.getPaymentRequestItem(this.paymentRequestDocMock, 1, KDONE, new BigDecimal("100.00"), "ITEM");
        items.add(item1);
        ArrayList<PurchaseOrderAccount> lines = new ArrayList<PurchaseOrderAccount>();
        lines.add(this.getPurchaseOrderAccount(KDTWO, KDONE));
        item1.setSourceAccountingLines(lines);
        Mockito.when((Object)this.paymentRequestDocMock.getItems()).thenReturn(items);
        Mockito.when((Object)this.paymentRequestDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1000);
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1000))).thenReturn((Object)this.purchaseOrderDocMock);
        Mockito.when((Object)this.purchaseOrderDocMock.getItems()).thenReturn(new ArrayList());
        Mockito.when((Object)this.paymentRequestDocMock.isUseTaxIndicator()).thenReturn((Object)false);
        Mockito.when((Object)((PurchaseOrderDocument)this.boServiceMock.save((PersistableBusinessObject)this.purchaseOrderDocMock))).thenReturn((Object)this.purchaseOrderDocMock);
        ArrayList<SummaryAccount> sas = new ArrayList<SummaryAccount>();
        SummaryAccount sa = new SummaryAccount();
        sa.setAccount(new SourceAccountingLine());
        sas.add(sa);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocMock)).thenReturn(sas);
        this.paymentRequestDocMock.setGeneralLedgerPendingEntries(new ArrayList());
        Mockito.when((Object)this.paymentRequestDocMock.getDocumentNumber()).thenReturn((Object)"1000");
        this.paymentRequestDocMock.setGenerateEncumbranceEntries(false);
        this.paymentRequestDocMock.setDebitCreditCodeForGLEntries("C");
        Mockito.when((Object)this.paymentRequestDocMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.any(), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any())).thenReturn((Object)true);
        HashMap<String, String> matcher = new HashMap<String, String>();
        matcher.put("financialSystemOriginationCode", "01");
        matcher.put("documentNumber", "1000");
        Mockito.when((Object)this.boServiceMock.countMatching(GeneralLedgerPendingEntry.class, matcher)).thenReturn((Object)1);
        Mockito.when((Object)this.paymentRequestDocMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocMock);
        Mockito.when((Object)this.purchaseOrderDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Closed");
        Mockito.when((Object)this.purapAccountingSvcMock.generateUseTaxAccount((PurchasingAccountsPayableDocument)this.paymentRequestDocMock)).thenReturn(new ArrayList());
        Mockito.when((Object)this.paymentRequestDocMock.getPurapDocumentIdentifier()).thenReturn((Object)1000);
        this.purapAccountingSvcMock.deleteSummaryAccounts(Integer.valueOf(1000), "PREQ");
        Mockito.when((Object)((AccountService)SpringContext.getBean(AccountService.class))).thenReturn((Object)this.accountSvcMock);
        this.accountSvcMock.populateAccountingLineChartIfNeeded((AccountingLine)ArgumentMatchers.any());
        Mockito.when((Object)((DateTimeService)SpringContext.getBean(DateTimeService.class))).thenReturn((Object)this.dateTimeSvcMock);
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn((Object)this.getTestTimestamp());
        Mockito.when((Object)this.paymentRequestDocMock.getPostingYearFromPendingGLEntries()).thenReturn((Object)2016);
        Mockito.when((Object)this.paymentRequestDocMock.getPostingPeriodCodeFromPendingGLEntries()).thenReturn((Object)"01");
        Mockito.when((Object)this.boServiceMock.save((List)ArgumentMatchers.any())).thenReturn(null);
        this.purapAccountRevisionSvcMock.cancelPaymentRequestAccountRevisions((List)ArgumentMatchers.any(), Integer.valueOf(ArgumentMatchers.anyInt()), ArgumentMatchers.anyString());
        Mockito.when((Object)this.paymentRequestDocMock.getGeneralLedgerPendingEntries()).thenReturn(new ArrayList());
        this.cut.generateEntriesCancelAccountsPayableDocument((AccountsPayableDocument)this.paymentRequestDocMock);
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).isUseTaxIndicator();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)ArgumentMatchers.any(), (GeneralLedgerPendingEntrySequenceHelper)ArgumentMatchers.any());
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock)).generateUseTaxAccount((PurchasingAccountsPayableDocument)this.paymentRequestDocMock);
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getPurapDocumentIdentifier();
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock, (VerificationMode)Mockito.times((int)2))).deleteSummaryAccounts(Integer.valueOf(1000), "PREQ");
        ((DateTimeService)Mockito.verify((Object)this.dateTimeSvcMock)).getCurrentTimestamp();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getPostingYearFromPendingGLEntries();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getPostingPeriodCodeFromPendingGLEntries();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setDebitCreditCodeForGLEntries(ArgumentMatchers.anyString());
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setGenerateEncumbranceEntries(ArgumentMatchers.anyBoolean());
        ((PurchaseOrderDocument)Mockito.verify((Object)this.purchaseOrderDocMock)).getItems();
        this.verifyCommon();
    }

    private Timestamp getTestTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.US);
        try {
            return new Timestamp(sdf.parse("20160701130000000").getTime());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Bad date string");
        }
    }

    private void verifyCommon() {
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock, (VerificationMode)Mockito.atLeastOnce())).getItems();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getPurchaseOrderIdentifier();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock, (VerificationMode)Mockito.times((int)2))).setGeneralLedgerPendingEntries(new ArrayList());
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getPurchaseOrderDocument();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getDocumentNumber();
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocMock)).getGeneralLedgerPendingEntries();
        ((PurchaseOrderService)Mockito.verify((Object)this.purchaseOrderSvcMock)).getCurrentPurchaseOrder(Integer.valueOf(1000));
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock)).countMatching((Class)ArgumentMatchers.eq(GeneralLedgerPendingEntry.class), ArgumentMatchers.anyMap());
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock, (VerificationMode)Mockito.atLeastOnce())).save(ArgumentMatchers.anyList());
        ((PurchaseOrderDocument)Mockito.verify((Object)this.purchaseOrderDocMock)).getApplicationDocumentStatus();
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock)).generateSummaryAccountsWithNoZeroTotalsNoUseTax((PurchasingAccountsPayableDocument)this.paymentRequestDocMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.paymentRequestDocMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purchaseOrderSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purchaseOrderDocMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purapAccountingSvcMock});
    }
}

