/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class GenerateEntriesVoidPurchaseOrderTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurchaseOrderDocument poMock;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private GeneralLedgerPendingEntryService glPendingEntrySvcMock;
    @Mock
    private BusinessObjectService boServiceMock;
    private List<PurApItem> poItems;
    private List<PurApItem> poActiveItems;
    private List<GeneralLedgerPendingEntry> glpes;
    private List<SourceAccountingLine> sourceAccountingLines;
    private List<Object> dynamicMocks;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        this.cut.setGeneralLedgerPendingEntryService(this.glPendingEntrySvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.poItems = new ArrayList<PurApItem>();
        this.poActiveItems = new ArrayList<PurApItem>();
        this.glpes = new ArrayList<GeneralLedgerPendingEntry>();
        this.sourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.dynamicMocks = new ArrayList<Object>();
    }

    private void execute() {
        this.cut.generateEntriesVoidPurchaseOrder(this.poMock);
        ((PurchaseOrderDocument)Mockito.verify((Object)this.poMock)).getItems();
        ((PurchaseOrderDocument)Mockito.verify((Object)this.poMock)).getItemsActiveOnly();
        ((PurchaseOrderDocument)Mockito.verify((Object)this.poMock, (VerificationMode)Mockito.times((int)2))).setGlOnlySourceAccountingLines(this.sourceAccountingLines);
        ((PurchaseOrderDocument)Mockito.verify((Object)this.poMock)).getGeneralLedgerPendingEntries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.poMock});
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock)).generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.poActiveItems);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purapAccountingSvcMock});
        ((GeneralLedgerPendingEntryService)Mockito.verify((Object)this.glPendingEntrySvcMock)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this.poMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.glPendingEntrySvcMock});
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock)).save(this.glpes);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.boServiceMock});
    }

    private void preparePO() {
        Mockito.when((Object)this.poMock.getItems()).thenReturn(this.poItems);
        Mockito.when((Object)this.poMock.getItemsActiveOnly()).thenReturn(this.poActiveItems);
        this.poMock.setGlOnlySourceAccountingLines(this.sourceAccountingLines);
        Mockito.when((Object)this.poMock.getGeneralLedgerPendingEntries()).thenReturn(this.glpes);
    }

    private void prepareItem(int lineNumber, double outstandingAmount, List<PurApAccountingLine> accountingLines, boolean active) {
        PurchaseOrderItem itemMock = (PurchaseOrderItem)Mockito.mock(PurchaseOrderItem.class);
        Mockito.when((Object)itemMock.getItemLineNumber()).thenReturn((Object)lineNumber);
        Mockito.when((Object)itemMock.isItemActiveIndicator()).thenReturn((Object)active);
        if (active) {
            Mockito.when((Object)itemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(outstandingAmount));
            Mockito.when((Object)itemMock.getSourceAccountingLines()).thenReturn(accountingLines);
            this.poActiveItems.add((PurApItem)itemMock);
        }
        this.poItems.add((PurApItem)itemMock);
        this.dynamicMocks.add(itemMock);
    }

    private PurchaseOrderAccount createPoAccountingLine(double percent, double newOutstandingAmount, Double altAmount) {
        PurchaseOrderAccount accountMock = (PurchaseOrderAccount)Mockito.mock(PurchaseOrderAccount.class);
        Mockito.when((Object)accountMock.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)accountMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal(percent));
        Mockito.when((Object)accountMock.compareTo(ArgumentMatchers.isA(PurchaseOrderAccount.class))).thenReturn((Object)0);
        accountMock.setAlternateAmountForGLEntryCreation(new KualiDecimal(newOutstandingAmount));
        ((PurchaseOrderAccount)Mockito.verify((Object)accountMock)).setAlternateAmountForGLEntryCreation((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        if (altAmount != null) {
            Mockito.when((Object)accountMock.getAlternateAmountForGLEntryCreation()).thenReturn((Object)new KualiDecimal(newOutstandingAmount));
            accountMock.setAlternateAmountForGLEntryCreation(new KualiDecimal(altAmount.doubleValue()));
            ((PurchaseOrderAccount)Mockito.verify((Object)accountMock, (VerificationMode)Mockito.times((int)2))).setAlternateAmountForGLEntryCreation((KualiDecimal)ArgumentMatchers.any(KualiDecimal.class));
        }
        this.sourceAccountingLines.add((SourceAccountingLine)accountMock);
        this.dynamicMocks.add(accountMock);
        return accountMock;
    }

    private void prepareItemsNoAccountingLines() {
        this.prepareItem(1, 10.0, new ArrayList<PurApAccountingLine>(), true);
        this.prepareItem(2, 15.0, new ArrayList<PurApAccountingLine>(), false);
    }

    private void prepareItemsWithAccountingLines() {
        ArrayList<Object> accountingLines = new ArrayList<PurApAccountingLine>();
        accountingLines.add(this.createPoAccountingLine(100.0, 10.0, 10.0));
        this.prepareItem(1, 10.0, accountingLines, true);
        accountingLines = new ArrayList();
        accountingLines.add((PurApAccountingLine)this.createPoAccountingLine(50.0, 5.0, null));
        accountingLines.add(this.createPoAccountingLine(50.0, 5.0, 5.0));
        this.prepareItem(2, 10.0, accountingLines, true);
        accountingLines = new ArrayList();
        accountingLines.add((PurApAccountingLine)this.createPoAccountingLine(66.66, 6666.0, null));
        accountingLines.add(this.createPoAccountingLine(33.33, 3333.0, 3334.0));
        this.prepareItem(3, 10000.0, accountingLines, true);
    }

    private void baseExpectations() {
        this.preparePO();
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.poActiveItems)).thenReturn(this.sourceAccountingLines);
        Mockito.when((Object)this.glPendingEntrySvcMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this.poMock)).thenReturn((Object)true);
        Mockito.when((Object)this.boServiceMock.save(this.glpes)).thenReturn(null);
    }

    @Test
    public void baseCase() {
        this.baseExpectations();
        this.execute();
    }

    @Test
    public void poWithItems() {
        this.baseExpectations();
        this.prepareItemsNoAccountingLines();
        this.execute();
    }

    @Test
    public void poWithAccountingLines() {
        this.baseExpectations();
        this.prepareItemsWithAccountingLines();
        this.execute();
    }
}

