/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.sql.Date;
import java.util.Objects;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.module.purap.util.PurApDateFormatUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.config.property.SimpleConfig;
import org.kuali.rice.core.impl.datetime.DateTimeServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ConfigContext.class, ElectronicInvoiceUtils.class, PurApDateFormatUtils.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class ElectronicInvoiceUtilsTest {
    @Mock
    private ParameterService parameterSvcMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.CXML_DATE_FORMAT)).thenReturn((Object)"0000-00-00");
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.KUALI_DATE_FORMAT)).thenReturn((Object)"00/00/0000");
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.CXML_SIMPLE_DATE_FORMAT)).thenReturn((Object)"yyyy-MM-dd");
        Properties props = new Properties();
        props.put("STRING_TO_DATE_FORMATS", "MM/dd/yyyy hh:mm a;MM/dd/yy;MM/dd/yyyy;MM-dd-yy;MM-dd-yyyy;MMddyy;MMMM dd;yyyy;MM/dd/yy HH:mm:ss;MM/dd/yyyy HH:mm:ss;MM-dd-yy HH:mm:ss;MMddyy HH:mm:ss;MMMM dd HH:mm:ss;yyyy HH:mm:ss");
        SimpleConfig config = new SimpleConfig(props);
        PowerMockito.mockStatic(ConfigContext.class, (Class[])new Class[0]);
        Mockito.when((Object)ConfigContext.getCurrentContextConfig()).thenReturn((Object)config);
        DateTimeServiceImpl dateTimeService = new DateTimeServiceImpl();
        dateTimeService.afterPropertiesSet();
        PowerMockito.mockStatic(ElectronicInvoiceUtils.class, (Answer)Mockito.CALLS_REAL_METHODS);
        PowerMockito.doReturn((Object)dateTimeService).when(ElectronicInvoiceUtils.class, "getDateTimeService", new Object[0]);
        PowerMockito.mockStatic(PurApDateFormatUtils.class, (Answer)Mockito.CALLS_REAL_METHODS);
        PowerMockito.doReturn((Object)this.parameterSvcMock).when(PurApDateFormatUtils.class, "getParameterService", new Object[0]);
    }

    @After
    public void tearDown() {
        ConfigContext.destroy();
    }

    @Test
    public void getDate_CDW_xml() {
        String invoiceDate = "2008-08-11T00:00:00-06:00";
        Date formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        Assert.assertEquals((Object)"2008-08-11", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    public void getDate_VWR_xml() {
        String invoiceDate = "2008-07-29";
        Date formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        Assert.assertEquals((Object)"2008-07-29", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    public void getDate_GuyBrown_xml() {
        String invoiceDate = "2008-07-29T12:00:00";
        Date formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        Assert.assertEquals((Object)"2008-07-29", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    public void getDate_BarnesAndNoble_xml() {
        String invoiceDate = "2008-07-23T12:00:00-12:00";
        Date formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        Assert.assertEquals((Object)"2008-07-23", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    public void getDate_RejectDocDate_KualiFormat() {
        String invoiceDate = "07/23/2008";
        Date formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        Assert.assertEquals((Object)"2008-07-23", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    public void getDate_invalidFormat() {
        String invoiceDate = "2008|07|23";
        Date formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        Assert.assertNull((Object)formattedDate);
    }

    @Test
    public void getDate_invalidFormat_null() {
        String invoiceDate = null;
        Date formattedDate = ElectronicInvoiceUtils.getDate(invoiceDate);
        Assert.assertNull((Object)formattedDate);
    }

    @Test
    public void stripSplChars() {
        String rawInvoiceId = "A1!B2#C3$D4%";
        String stripped = ElectronicInvoiceUtils.stripSplChars((String)rawInvoiceId);
        Assert.assertEquals((Object)"A1B2C3D4", (Object)stripped);
    }
}

