/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Created on Mar 9, 2005
 *
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.purap.document.ElectronicInvoiceRejectDocument;

import java.math.BigDecimal;

public class ElectronicInvoiceRejectItem extends PersistableBusinessObjectBase {

    // NOT NULL FIELDS
    private Integer invoiceRejectItemIdentifier;
    private Integer purapDocumentIdentifier;

    private Integer invoiceItemLineNumber;
    private BigDecimal invoiceItemQuantity;
    private String invoiceItemUnitOfMeasureCode;
    private String invoiceItemCatalogNumber;

    private String invoiceItemUnitPriceCurrencyCode;
    private String invoiceItemSubTotalCurrencyCode;
    private String invoiceItemSpecialHandlingCurrencyCode;
    private String invoiceItemShippingCurrencyCode;
    private String invoiceItemShippingDescription;
    private String invoiceItemTaxCurrencyCode;
    private String invoiceItemTaxDescription;
    private String invoiceItemGrossCurrencyCode;
    private String invoiceItemDiscountCurrencyCode;
    private String invoiceItemNetCurrencyCode;

    private BigDecimal invoiceItemUnitPrice;
    private BigDecimal invoiceItemSubTotalAmount;
    private BigDecimal invoiceItemSpecialHandlingAmount;
    private BigDecimal invoiceItemShippingAmount;
    private BigDecimal invoiceItemTaxAmount;
    private BigDecimal invoiceItemGrossAmount;
    private BigDecimal invoiceItemDiscountAmount;
    private BigDecimal invoiceItemNetAmount;

    private Integer invoiceReferenceItemLineNumber;
    private String invoiceReferenceItemSerialNumber;
    private String invoiceReferenceItemSupplierPartIdentifier;
    private String invoiceReferenceItemSupplierPartAuxiliaryIdentifier;
    private String invoiceReferenceItemDescription;
    private String invoiceReferenceItemManufacturerPartIdentifier;
    private String invoiceReferenceItemManufacturerName;
    private String invoiceReferenceItemCountryCode;
    private String invoiceReferenceItemCountryName;

    private boolean unitOfMeasureAcceptIndicator = false;
    private boolean catalogNumberAcceptIndicator = false;

    private ElectronicInvoiceRejectDocument electronicInvoiceRejectDocument;

    public ElectronicInvoiceRejectItem() {
        super();
    }

    public ElectronicInvoiceRejectItem(ElectronicInvoiceRejectDocument electronicInvoiceRejectDocument,
            ElectronicInvoiceItem eii) {
        super();

        this.electronicInvoiceRejectDocument = electronicInvoiceRejectDocument;
        try {
            this.invoiceItemLineNumber = Integer.parseInt(eii.getInvoiceLineNumber());
        } catch (NumberFormatException n) {
            this.invoiceItemLineNumber = null;
        }
        this.invoiceItemCatalogNumber = eii.getCatalogNumber();
        this.invoiceItemQuantity = eii.getInvoiceLineQuantityBigDecimal();
        this.invoiceItemUnitOfMeasureCode = eii.getUnitOfMeasure();
        this.invoiceReferenceItemLineNumber = eii.getReferenceLineNumberInteger();
        this.invoiceReferenceItemSerialNumber = eii.getReferenceSerialNumber();
        this.invoiceReferenceItemSupplierPartIdentifier = eii.getReferenceItemIDSupplierPartID();
        this.invoiceReferenceItemSupplierPartAuxiliaryIdentifier = eii.getReferenceItemIDSupplierPartAuxID();
        this.invoiceReferenceItemDescription = eii.getReferenceDescription();
        this.invoiceReferenceItemManufacturerPartIdentifier = eii.getReferenceManufacturerPartID();
        this.invoiceReferenceItemManufacturerName = eii.getReferenceManufacturerName();
        this.invoiceReferenceItemCountryCode = eii.getReferenceCountryCode();
        this.invoiceReferenceItemCountryName = eii.getReferenceCountryName();

        this.invoiceItemUnitPriceCurrencyCode = eii.getUnitPriceCurrency();
        this.invoiceItemSubTotalCurrencyCode = eii.getSubTotalAmountCurrency();
        this.invoiceItemSpecialHandlingCurrencyCode = eii.getInvoiceLineSpecialHandlingAmountCurrency();
        this.invoiceItemShippingCurrencyCode = eii.getInvoiceLineShippingAmountCurrency();
        this.invoiceItemShippingDescription = eii.getInvoiceLineShippingDescription();
        this.invoiceItemTaxCurrencyCode = eii.getTaxAmountCurrency();
        this.invoiceItemTaxDescription = eii.getTaxDescription();
        this.invoiceItemGrossCurrencyCode = eii.getInvoiceLineGrossAmountCurrency();
        this.invoiceItemDiscountCurrencyCode = eii.getInvoiceLineDiscountAmountCurrency();
        this.invoiceItemNetCurrencyCode = eii.getInvoiceLineNetAmountCurrency();

        this.invoiceItemUnitPrice = eii.getInvoiceLineUnitCostBigDecimal();
        this.invoiceItemSubTotalAmount = eii.getInvoiceLineSubTotalAmountBigDecimal();
        this.invoiceItemSpecialHandlingAmount = eii.getInvoiceLineSpecialHandlingAmountBigDecimal();
        this.invoiceItemShippingAmount = eii.getInvoiceLineShippingAmountBigDecimal();
        this.invoiceItemTaxAmount = eii.getInvoiceLineTaxAmountBigDecimal();
        this.invoiceItemGrossAmount = eii.getInvoiceLineGrossAmountBigDecimal();
        this.invoiceItemDiscountAmount = eii.getInvoiceLineDiscountAmountBigDecimal();
        this.invoiceItemNetAmount = eii.getInvoiceLineNetAmountBigDecimal();

        // setup the sub total amount so that the reject prints to the files correctly
        if (eii.getSubTotalAmount() == null || "".equals(eii.getSubTotalAmount())) {
            // the sub total amount of this electronic invoice item was not given
            if ((this.invoiceItemQuantity != null && (BigDecimal.ZERO.compareTo(this.invoiceItemQuantity) != 0))
                    && (this.invoiceItemUnitPrice != null
                        && BigDecimal.ZERO.compareTo(this.invoiceItemUnitPrice) != 0)) {
                // unit price and quantity are valid... calculate subtotal
                this.invoiceItemSubTotalAmount = this.invoiceItemQuantity.multiply(this.invoiceItemUnitPrice);
            } else if ((this.invoiceItemQuantity == null || "".equals(this.invoiceItemQuantity))
                    && (this.invoiceItemUnitPrice != null
                        && BigDecimal.ZERO.compareTo(this.invoiceItemUnitPrice) != 0)) {
                // quantity is empty but unit cost exists... use it
                this.invoiceItemSubTotalAmount = this.invoiceItemUnitPrice;
            } else {
                this.invoiceItemSubTotalAmount = null;
            }
        } else {
            this.invoiceItemSubTotalAmount = eii.getInvoiceLineSubTotalAmountBigDecimal();
        }
    }

    public Integer getPurapDocumentIdentifier() {
        return purapDocumentIdentifier;
    }

    public void setPurapDocumentIdentifier(Integer purapDocumentIdentifier) {
        this.purapDocumentIdentifier = purapDocumentIdentifier;
    }

    public ElectronicInvoiceRejectDocument getElectronicInvoiceRejectDocument() {
        return electronicInvoiceRejectDocument;
    }

    public void setElectronicInvoiceRejectDocument(ElectronicInvoiceRejectDocument electronicInvoiceRejectDocument) {
        this.electronicInvoiceRejectDocument = electronicInvoiceRejectDocument;
    }

    public Integer getInvoiceRejectItemIdentifier() {
        return invoiceRejectItemIdentifier;
    }

    public void setInvoiceRejectItemIdentifier(Integer id) {
        this.invoiceRejectItemIdentifier = id;
    }

    public String getInvoiceItemCatalogNumber() {
        return invoiceItemCatalogNumber;
    }

    public void setInvoiceItemCatalogNumber(String invoiceCatalogNumber) {
        this.invoiceItemCatalogNumber = invoiceCatalogNumber;
    }

    public BigDecimal getInvoiceItemDiscountAmount() {
        return invoiceItemDiscountAmount;
    }

    public void setInvoiceItemDiscountAmount(BigDecimal invoiceDiscountAmount) {
        this.invoiceItemDiscountAmount = invoiceDiscountAmount;
    }

    public String getInvoiceItemDiscountCurrencyCode() {
        return invoiceItemDiscountCurrencyCode;
    }

    public void setInvoiceItemDiscountCurrencyCode(String invoiceDiscountCurrencyCode) {
        this.invoiceItemDiscountCurrencyCode = invoiceDiscountCurrencyCode;
    }

    public BigDecimal getInvoiceItemGrossAmount() {
        return invoiceItemGrossAmount;
    }

    public void setInvoiceItemGrossAmount(BigDecimal invoiceGrossAmount) {
        this.invoiceItemGrossAmount = invoiceGrossAmount;
    }

    public String getInvoiceItemGrossCurrencyCode() {
        return invoiceItemGrossCurrencyCode;
    }

    public void setInvoiceItemGrossCurrencyCode(String invoiceGrossCurrencyCode) {
        this.invoiceItemGrossCurrencyCode = invoiceGrossCurrencyCode;
    }

    public BigDecimal getInvoiceItemQuantity() {
        return invoiceItemQuantity;
    }

    public void setInvoiceItemQuantity(BigDecimal invoiceItemQuantity) {
        this.invoiceItemQuantity = invoiceItemQuantity;
    }

    public String getInvoiceItemUnitOfMeasureCode() {
        return invoiceItemUnitOfMeasureCode;
    }

    public void setInvoiceItemUnitOfMeasureCode(String invoiceItemUnitOfMeasureCode) {
        this.invoiceItemUnitOfMeasureCode = invoiceItemUnitOfMeasureCode;
    }

    public BigDecimal getInvoiceItemNetAmount() {
        BigDecimal returnValue = this.getInvoiceItemSubTotalAmount();

        if (returnValue != null) {
            if (this.getInvoiceItemShippingAmount() != null) {
                returnValue = returnValue.add(this.getInvoiceItemShippingAmount());
            }

            if (this.getInvoiceItemSpecialHandlingAmount() != null) {
                returnValue = returnValue.add(this.getInvoiceItemSpecialHandlingAmount());
            }

            if (this.getInvoiceItemTaxAmount() != null) {
                returnValue = returnValue.add(this.getInvoiceItemTaxAmount());
            }

            this.invoiceItemGrossAmount = returnValue;

            if (this.getInvoiceItemDiscountAmount() != null) {
                returnValue = returnValue.subtract(this.getInvoiceItemDiscountAmount());
            }
            returnValue = returnValue.setScale(4, BigDecimal.ROUND_HALF_UP);

        }

        this.invoiceItemNetAmount = returnValue;

        return this.invoiceItemNetAmount;
    }

    public void setInvoiceItemNetAmount(BigDecimal invoiceNetAmount) {
        this.invoiceItemNetAmount = invoiceNetAmount;
    }

    public String getInvoiceItemNetCurrencyCode() {
        return invoiceItemNetCurrencyCode;
    }

    public void setInvoiceItemNetCurrencyCode(String invoiceNetCurrencyCode) {
        this.invoiceItemNetCurrencyCode = invoiceNetCurrencyCode;
    }

    public BigDecimal getInvoiceItemShippingAmount() {
        return invoiceItemShippingAmount;
    }

    public void setInvoiceItemShippingAmount(BigDecimal invoiceShippingAmount) {
        this.invoiceItemShippingAmount = invoiceShippingAmount;
    }

    public String getInvoiceItemShippingCurrencyCode() {
        return invoiceItemShippingCurrencyCode;
    }

    public void setInvoiceItemShippingCurrencyCode(String invoiceShippingCurrencyCode) {
        this.invoiceItemShippingCurrencyCode = invoiceShippingCurrencyCode;
    }

    public String getInvoiceItemShippingDescription() {
        return invoiceItemShippingDescription;
    }

    public void setInvoiceItemShippingDescription(String invoiceShippingDescription) {
        this.invoiceItemShippingDescription = invoiceShippingDescription;
    }

    public BigDecimal getInvoiceItemSpecialHandlingAmount() {
        return invoiceItemSpecialHandlingAmount;
    }

    public void setInvoiceItemSpecialHandlingAmount(BigDecimal invoiceSpecialHandlingAmount) {
        this.invoiceItemSpecialHandlingAmount = invoiceSpecialHandlingAmount;
    }

    public String getInvoiceItemSpecialHandlingCurrencyCode() {
        return invoiceItemSpecialHandlingCurrencyCode;
    }

    public void setInvoiceItemSpecialHandlingCurrencyCode(String invoiceSpecialHandlingCurrencyCode) {
        this.invoiceItemSpecialHandlingCurrencyCode = invoiceSpecialHandlingCurrencyCode;
    }

    public BigDecimal getInvoiceItemSubTotalAmount() {
        // this needs to be calculated when read
        BigDecimal returnValue;
        if ((this.invoiceItemQuantity != null && BigDecimal.ZERO.compareTo(this.invoiceItemQuantity) != 0)
                && (this.invoiceItemUnitPrice != null && BigDecimal.ZERO.compareTo(this.invoiceItemUnitPrice) != 0)) {
            // unit price and quantity are valid... calculate subtotal
            returnValue = this.invoiceItemQuantity.multiply(this.invoiceItemUnitPrice);
        } else if ((this.invoiceItemQuantity == null || "".equals(this.invoiceItemQuantity))
                && (this.invoiceItemUnitPrice != null && BigDecimal.ZERO.compareTo(this.invoiceItemUnitPrice) != 0)) {
            // quantity is empty but unit cost exists... use it
            returnValue = this.invoiceItemUnitPrice;
        } else {
            returnValue = null;
        }

        if (returnValue != null) {
            invoiceItemSubTotalAmount = returnValue.setScale(4, BigDecimal.ROUND_HALF_UP);
        } else {
            invoiceItemSubTotalAmount = null;
        }

        return invoiceItemSubTotalAmount;
    }

    public void setInvoiceItemSubTotalAmount(BigDecimal invoiceSubTotalAmount) {
        this.invoiceItemSubTotalAmount = invoiceSubTotalAmount;
    }

    public String getInvoiceItemSubTotalCurrencyCode() {
        return invoiceItemSubTotalCurrencyCode;
    }

    public void setInvoiceItemSubTotalCurrencyCode(String invoiceSubTotalCurrencyCode) {
        this.invoiceItemSubTotalCurrencyCode = invoiceSubTotalCurrencyCode;
    }

    public BigDecimal getInvoiceItemTaxAmount() {
        return invoiceItemTaxAmount;
    }

    public void setInvoiceItemTaxAmount(BigDecimal invoiceTaxAmount) {
        this.invoiceItemTaxAmount = invoiceTaxAmount;
    }

    public String getInvoiceItemTaxCurrencyCode() {
        return invoiceItemTaxCurrencyCode;
    }

    public void setInvoiceItemTaxCurrencyCode(String invoiceTaxCurrencyCode) {
        this.invoiceItemTaxCurrencyCode = invoiceTaxCurrencyCode;
    }

    public String getInvoiceItemTaxDescription() {
        return invoiceItemTaxDescription;
    }

    public void setInvoiceItemTaxDescription(String invoiceTaxDescription) {
        this.invoiceItemTaxDescription = invoiceTaxDescription;
    }

    public BigDecimal getInvoiceItemUnitPrice() {
        return invoiceItemUnitPrice;
    }

    public void setInvoiceItemUnitPrice(BigDecimal invoiceUnitPrice) {
        this.invoiceItemUnitPrice = invoiceUnitPrice;
    }

    public String getInvoiceItemUnitPriceCurrencyCode() {
        return invoiceItemUnitPriceCurrencyCode;
    }

    public void setInvoiceItemUnitPriceCurrencyCode(String invoiceUnitPriceCurrency) {
        this.invoiceItemUnitPriceCurrencyCode = invoiceUnitPriceCurrency;
    }

    public Integer getInvoiceItemLineNumber() {
        return invoiceItemLineNumber;
    }

    public void setInvoiceItemLineNumber(Integer itemLineNumber) {
        this.invoiceItemLineNumber = itemLineNumber;
    }

    public String getInvoiceReferenceItemCountryCode() {
        return invoiceReferenceItemCountryCode;
    }

    public void setInvoiceReferenceItemCountryCode(String itemReferenceCountryCode) {
        this.invoiceReferenceItemCountryCode = itemReferenceCountryCode;
    }

    public String getInvoiceReferenceItemCountryName() {
        return invoiceReferenceItemCountryName;
    }

    public void setInvoiceReferenceItemCountryName(String itemReferenceCountryName) {
        this.invoiceReferenceItemCountryName = itemReferenceCountryName;
    }

    public String getInvoiceReferenceItemDescription() {
        return invoiceReferenceItemDescription;
    }

    public void setInvoiceReferenceItemDescription(String itemReferenceDescription) {
        this.invoiceReferenceItemDescription = itemReferenceDescription;
    }

    public Integer getInvoiceReferenceItemLineNumber() {
        return invoiceReferenceItemLineNumber;
    }

    public void setInvoiceReferenceItemLineNumber(Integer itemReferenceLineNumber) {
        this.invoiceReferenceItemLineNumber = itemReferenceLineNumber;
    }

    public String getInvoiceReferenceItemManufacturerName() {
        return invoiceReferenceItemManufacturerName;
    }

    public void setInvoiceReferenceItemManufacturerName(String itemReferenceManufacturerName) {
        this.invoiceReferenceItemManufacturerName = itemReferenceManufacturerName;
    }

    public String getInvoiceReferenceItemManufacturerPartIdentifier() {
        return invoiceReferenceItemManufacturerPartIdentifier;
    }

    public void setInvoiceReferenceItemManufacturerPartIdentifier(String itemReferenceManufacturerPartId) {
        this.invoiceReferenceItemManufacturerPartIdentifier = itemReferenceManufacturerPartId;
    }

    public String getInvoiceReferenceItemSerialNumber() {
        return invoiceReferenceItemSerialNumber;
    }

    public void setInvoiceReferenceItemSerialNumber(String itemReferenceSerialNumber) {
        this.invoiceReferenceItemSerialNumber = itemReferenceSerialNumber;
    }

    public String getInvoiceReferenceItemSupplierPartAuxiliaryIdentifier() {
        return invoiceReferenceItemSupplierPartAuxiliaryIdentifier;
    }

    public void setInvoiceReferenceItemSupplierPartAuxiliaryIdentifier(String itemReferenceSupplierPartAuxId) {
        this.invoiceReferenceItemSupplierPartAuxiliaryIdentifier = itemReferenceSupplierPartAuxId;
    }

    public String getInvoiceReferenceItemSupplierPartIdentifier() {
        return invoiceReferenceItemSupplierPartIdentifier;
    }

    public void setInvoiceReferenceItemSupplierPartIdentifier(String itemReferenceSupplierPartId) {
        this.invoiceReferenceItemSupplierPartIdentifier = itemReferenceSupplierPartId;
    }

    public boolean isUnitOfMeasureAcceptIndicator() {
        return unitOfMeasureAcceptIndicator;
    }

    public void setUnitOfMeasureAcceptIndicator(boolean unitOfMeasureAcceptIndicator) {
        this.unitOfMeasureAcceptIndicator = unitOfMeasureAcceptIndicator;
    }

    public boolean isCatalogNumberAcceptIndicator() {
        return catalogNumberAcceptIndicator;
    }

    public void setCatalogNumberAcceptIndicator(boolean catalogNumberAcceptIndicator) {
        this.catalogNumberAcceptIndicator = catalogNumberAcceptIndicator;
    }

}
