/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.businessobject.AccountingLineParserBase;
import org.kuali.kfs.sys.document.AccountingDocument;

/**
 * This class is used to parse an PurApItem accounting line.
 */
public class PurApAccountingLineParser extends AccountingLineParserBase {

    protected static final String[] PURAP_FORMAT = {KFSPropertyConstants.CHART_OF_ACCOUNTS_CODE,
        KFSPropertyConstants.ACCOUNT_NUMBER, KFSPropertyConstants.SUB_ACCOUNT_NUMBER,
        KFSPropertyConstants.FINANCIAL_OBJECT_CODE, KFSPropertyConstants.FINANCIAL_SUB_OBJECT_CODE,
        KFSPropertyConstants.PROJECT_CODE, KFSPropertyConstants.ORGANIZATION_REFERENCE_ID,
        KFSPropertyConstants.PERCENT};

    public PurApAccountingLineParser() {
        super();
    }

    @Override
    public String[] getSourceAccountingLineFormat() {
        return removeChartFromFormatIfNeeded(PURAP_FORMAT);
    }

    @Override
    protected Class getSourceAccountingLineClass(final AccountingDocument accountingDocument) {
        if (accountingDocument instanceof RequisitionDocument) {
            return RequisitionAccount.class;
        } else if (accountingDocument instanceof PurchaseOrderDocument) {
            return PurchaseOrderAccount.class;
        } else {
            return super.getSourceAccountingLineClass(accountingDocument);
        }
    }

}
