/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.sys.businessobject.Country;

import java.sql.Date;
import java.sql.Timestamp;

public class PurchaseOrderVendorQuote extends PersistableBusinessObjectBase {

    private String documentNumber;
    private Integer purchaseOrderVendorQuoteIdentifier;
    private Integer vendorHeaderGeneratedIdentifier;
    private Integer vendorDetailAssignedIdentifier;
    private String vendorName;
    private String vendorLine1Address;
    private String vendorLine2Address;
    private String vendorCityName;
    private String vendorStateCode;
    private String vendorPostalCode;
    private String vendorPhoneNumber;
    private String vendorFaxNumber;
    private String vendorEmailAddress;
    private String vendorAttentionName;
    private String purchaseOrderQuoteTransmitTypeCode;
    private Timestamp purchaseOrderQuoteTransmitTimestamp;
    private Date purchaseOrderQuotePriceExpirationDate;
    private String purchaseOrderQuoteStatusCode;
    private Timestamp purchaseOrderQuoteAwardTimestamp;
    private String purchaseOrderQuoteRankNumber;
    private String vendorCountryCode;
    private String vendorAddressInternationalProvinceName;
    private boolean isTransmitPrintDisplayed = false;

    private PurchaseOrderDocument purchaseOrder;
    private PurchaseOrderQuoteStatus purchaseOrderQuoteStatus;
    private Country vendorCountry;

    //non-persisted variables
    protected boolean isPdfDisplayedToUserOnce;

    public PurchaseOrderVendorQuote() {

    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Integer getPurchaseOrderVendorQuoteIdentifier() {
        return purchaseOrderVendorQuoteIdentifier;
    }

    public Country getVendorCountry() {
        return vendorCountry;
    }

    public void setVendorCountry(Country vendorCountry) {
        this.vendorCountry = vendorCountry;
    }

    public void setPurchaseOrderVendorQuoteIdentifier(Integer purchaseOrderVendorQuoteIdentifier) {
        this.purchaseOrderVendorQuoteIdentifier = purchaseOrderVendorQuoteIdentifier;
    }

    public Integer getVendorHeaderGeneratedIdentifier() {
        return vendorHeaderGeneratedIdentifier;
    }

    public void setVendorHeaderGeneratedIdentifier(Integer vendorHeaderGeneratedIdentifier) {
        this.vendorHeaderGeneratedIdentifier = vendorHeaderGeneratedIdentifier;
    }

    public Integer getVendorDetailAssignedIdentifier() {
        return vendorDetailAssignedIdentifier;
    }

    public void setVendorDetailAssignedIdentifier(Integer vendorDetailAssignedIdentifier) {
        this.vendorDetailAssignedIdentifier = vendorDetailAssignedIdentifier;
    }

    public String getVendorAddressInternationalProvinceName() {
        return vendorAddressInternationalProvinceName;
    }

    public void setVendorAddressInternationalProvinceName(String vendorAddressInternationalProvinceName) {
        this.vendorAddressInternationalProvinceName = vendorAddressInternationalProvinceName;
    }

    public String getVendorNumber() {
        String vendorNumber = "";
        if (ObjectUtils.isNotNull(this.vendorHeaderGeneratedIdentifier)) {
            vendorNumber = this.vendorHeaderGeneratedIdentifier.toString();
        }
        if (ObjectUtils.isNotNull(this.vendorDetailAssignedIdentifier)) {
            vendorNumber += "-" + this.vendorDetailAssignedIdentifier.toString();
        }
        return vendorNumber;
    }

    public void setVendorNumber(String vendorNumber) {
        // do nothing
    }

    public String getVendorName() {
        return vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getVendorLine1Address() {
        return vendorLine1Address;
    }

    public void setVendorLine1Address(String vendorLine1Address) {
        this.vendorLine1Address = vendorLine1Address;
    }

    public String getVendorLine2Address() {
        return vendorLine2Address;
    }

    public void setVendorLine2Address(String vendorLine2Address) {
        this.vendorLine2Address = vendorLine2Address;
    }

    public String getVendorCityName() {
        return vendorCityName;
    }

    public void setVendorCityName(String vendorCityName) {
        this.vendorCityName = vendorCityName;
    }

    public String getVendorStateCode() {
        return vendorStateCode;
    }

    public void setVendorStateCode(String vendorStateCode) {
        this.vendorStateCode = vendorStateCode;
    }

    public String getVendorPostalCode() {
        return vendorPostalCode;
    }

    public void setVendorPostalCode(String vendorPostalCode) {
        this.vendorPostalCode = vendorPostalCode;
    }

    public String getVendorPhoneNumber() {
        return vendorPhoneNumber;
    }

    public void setVendorPhoneNumber(String vendorPhoneNumber) {
        this.vendorPhoneNumber = vendorPhoneNumber;
    }

    public String getVendorFaxNumber() {
        return vendorFaxNumber;
    }

    public void setVendorFaxNumber(String vendorFaxNumber) {
        this.vendorFaxNumber = vendorFaxNumber;
    }

    public String getVendorEmailAddress() {
        return vendorEmailAddress;
    }

    public void setVendorEmailAddress(String vendorEmailAddress) {
        this.vendorEmailAddress = vendorEmailAddress;
    }

    public String getVendorAttentionName() {
        return vendorAttentionName;
    }

    public void setVendorAttentionName(String vendorAttentionName) {
        this.vendorAttentionName = vendorAttentionName;
    }

    public String getPurchaseOrderQuoteTransmitTypeCode() {
        return purchaseOrderQuoteTransmitTypeCode;
    }

    public void setPurchaseOrderQuoteTransmitTypeCode(String purchaseOrderQuoteTransmitTypeCode) {
        this.purchaseOrderQuoteTransmitTypeCode = purchaseOrderQuoteTransmitTypeCode;
    }

    public Timestamp getPurchaseOrderQuoteTransmitTimestamp() {
        return purchaseOrderQuoteTransmitTimestamp;
    }

    public void setPurchaseOrderQuoteTransmitTimestamp(Timestamp purchaseOrderQuoteTransmitTimestamp) {
        this.purchaseOrderQuoteTransmitTimestamp = purchaseOrderQuoteTransmitTimestamp;
    }

    public Date getPurchaseOrderQuotePriceExpirationDate() {
        return purchaseOrderQuotePriceExpirationDate;
    }

    public void setPurchaseOrderQuotePriceExpirationDate(Date purchaseOrderQuotePriceExpirationDate) {
        this.purchaseOrderQuotePriceExpirationDate = purchaseOrderQuotePriceExpirationDate;
    }

    public String getPurchaseOrderQuoteStatusCode() {
        return purchaseOrderQuoteStatusCode;
    }

    public void setPurchaseOrderQuoteStatusCode(String purchaseOrderQuoteStatusCode) {
        this.purchaseOrderQuoteStatusCode = purchaseOrderQuoteStatusCode;
    }

    public Timestamp getPurchaseOrderQuoteAwardTimestamp() {
        return purchaseOrderQuoteAwardTimestamp;
    }

    public void setPurchaseOrderQuoteAwardTimestamp(Timestamp purchaseOrderQuoteAwardTimestamp) {
        this.purchaseOrderQuoteAwardTimestamp = purchaseOrderQuoteAwardTimestamp;
    }

    public String getPurchaseOrderQuoteRankNumber() {
        return purchaseOrderQuoteRankNumber;
    }

    public void setPurchaseOrderQuoteRankNumber(String purchaseOrderQuoteRankNumber) {
        this.purchaseOrderQuoteRankNumber = purchaseOrderQuoteRankNumber;
    }

    public PurchaseOrderDocument getPurchaseOrder() {
        return purchaseOrder;
    }

    /**
     * @deprecated
     */
    public void setPurchaseOrder(PurchaseOrderDocument purchaseOrder) {
        this.purchaseOrder = purchaseOrder;
    }

    public PurchaseOrderQuoteStatus getPurchaseOrderQuoteStatus() {
        return purchaseOrderQuoteStatus;
    }

    /**
     * @deprecated
     */
    public void setPurchaseOrderQuoteStatus(PurchaseOrderQuoteStatus purchaseOrderQuoteStatus) {
        this.purchaseOrderQuoteStatus = purchaseOrderQuoteStatus;
    }

    public String getVendorCountryCode() {
        return vendorCountryCode;
    }

    public void setVendorCountryCode(String vendorCountryCode) {
        this.vendorCountryCode = vendorCountryCode;
    }

    public boolean isTransmitPrintDisplayed() {
        return isTransmitPrintDisplayed;
    }

    public void setTransmitPrintDisplayed(boolean isTransmitPrintDisplayed) {
        this.isTransmitPrintDisplayed = isTransmitPrintDisplayed;
    }

    /**
     * @return true if the the pdf has already been displayed to the user one time. If false, its set to true and
     *         locks this out.
     */
    public boolean isPdfDisplayedToUserOnce() {
        boolean valueToReturn = isPdfDisplayedToUserOnce;

        //if not displayed, we will return false, but subsequent calls will return true.
        if (!valueToReturn) {
            isPdfDisplayedToUserOnce = true;
        }

        return valueToReturn;
    }

    public void setPdfDisplayedToUserOnce(boolean isPdfDisplayedToUserOnce) {
        this.isPdfDisplayedToUserOnce = isPdfDisplayedToUserOnce;
    }

}
