/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapPropertyConstants;
import org.kuali.kfs.sys.businessobject.UnitOfMeasure;
import org.kuali.rice.core.api.util.type.KualiDecimal;

import java.util.Locale;

public abstract class ReceivingItemBase extends PersistableBusinessObjectBase implements PurapEnterableItem,
        ReceivingItem {

    private Integer receivingItemIdentifier;
    private String documentNumber;
    private Integer purchaseOrderIdentifier;
    private Integer itemLineNumber;
    private String itemTypeCode;
    private String itemUnitOfMeasureCode;
    private String itemCatalogNumber;
    private String itemDescription;
    private KualiDecimal itemReceivedTotalQuantity;
    private KualiDecimal itemReturnedTotalQuantity;
    private KualiDecimal itemDamagedTotalQuantity;
    private String itemReasonAddedCode;
    protected KualiDecimal itemOriginalReceivedTotalQuantity;
    protected KualiDecimal itemOriginalReturnedTotalQuantity;
    protected KualiDecimal itemOriginalDamagedTotalQuantity;

    private ItemReasonAdded itemReasonAdded;
    private ItemType itemType;
    private UnitOfMeasure itemUnitOfMeasure;

    @Override
    public boolean isConsideredEntered() {
        //if all are not null then return true
        return !((ObjectUtils.isNull(this.getItemReceivedTotalQuantity())
                || this.getItemReceivedTotalQuantity().isZero())
                && (ObjectUtils.isNull(this.getItemDamagedTotalQuantity())
                || this.getItemDamagedTotalQuantity().isZero())
                && (ObjectUtils.isNull(this.getItemReturnedTotalQuantity())
                || this.getItemReturnedTotalQuantity().isZero()));
    }

    @Override
    public Integer getReceivingItemIdentifier() {
        return receivingItemIdentifier;
    }

    @Override
    public void setReceivingItemIdentifier(Integer receivingItemIdentifier) {
        this.receivingItemIdentifier = receivingItemIdentifier;
    }

    @Override
    public String getDocumentNumber() {
        return documentNumber;
    }

    @Override
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Override
    public Integer getPurchaseOrderIdentifier() {
        return purchaseOrderIdentifier;
    }

    @Override
    public void setPurchaseOrderIdentifier(Integer purchaseOrderIdentifier) {
        this.purchaseOrderIdentifier = purchaseOrderIdentifier;
    }

    @Override
    public Integer getItemLineNumber() {
        return itemLineNumber;
    }

    @Override
    public void setItemLineNumber(Integer itemLineNumber) {
        this.itemLineNumber = itemLineNumber;
    }

    @Override
    public String getItemTypeCode() {
        return itemTypeCode;
    }

    @Override
    public void setItemTypeCode(String itemTypeCode) {
        this.itemTypeCode = itemTypeCode;
    }

    @Override
    public String getItemUnitOfMeasureCode() {
        return itemUnitOfMeasureCode;
    }

    @Override
    public void setItemUnitOfMeasureCode(String itemUnitOfMeasureCode) {
        this.itemUnitOfMeasureCode = StringUtils.isNotBlank(itemUnitOfMeasureCode) ?
                itemUnitOfMeasureCode.toUpperCase(Locale.US) : itemUnitOfMeasureCode;
    }

    @Override
    public String getItemCatalogNumber() {
        return itemCatalogNumber;
    }

    @Override
    public void setItemCatalogNumber(String itemCatalogNumber) {
        this.itemCatalogNumber = itemCatalogNumber;
    }

    @Override
    public String getItemDescription() {
        return itemDescription;
    }

    @Override
    public void setItemDescription(String itemDescription) {
        this.itemDescription = itemDescription;
    }

    @Override
    public KualiDecimal getItemReceivedTotalQuantity() {
        return itemReceivedTotalQuantity;
    }

    @Override
    public void setItemReceivedTotalQuantity(KualiDecimal itemReceivedTotalQuantity) {
        this.itemReceivedTotalQuantity = itemReceivedTotalQuantity;
    }

    @Override
    public KualiDecimal getItemReturnedTotalQuantity() {
        return itemReturnedTotalQuantity;
    }

    @Override
    public void setItemReturnedTotalQuantity(KualiDecimal itemReturnedTotalQuantity) {
        this.itemReturnedTotalQuantity = itemReturnedTotalQuantity;
    }

    @Override
    public KualiDecimal getItemDamagedTotalQuantity() {
        return itemDamagedTotalQuantity;
    }

    @Override
    public void setItemDamagedTotalQuantity(KualiDecimal itemDamagedTotalQuantity) {
        this.itemDamagedTotalQuantity = itemDamagedTotalQuantity;
    }

    @Override
    public String getItemReasonAddedCode() {
        return itemReasonAddedCode;
    }

    @Override
    public void setItemReasonAddedCode(String itemReasonAddedCode) {
        this.itemReasonAddedCode = itemReasonAddedCode;
    }

    @Override
    public ItemType getItemType() {
        if (ObjectUtils.isNull(itemType)) {
            refreshReferenceObject(PurapPropertyConstants.ITEM_TYPE);
        }
        return itemType;
    }

    @Override
    public void setItemType(ItemType itemType) {
        this.itemType = itemType;
    }

    @Override
    public KualiDecimal getItemOriginalReceivedTotalQuantity() {
        return itemOriginalReceivedTotalQuantity;
    }

    @Override
    public void setItemOriginalReceivedTotalQuantity(KualiDecimal itemOriginalReceivedTotalQuantity) {
        this.itemOriginalReceivedTotalQuantity = itemOriginalReceivedTotalQuantity;
    }

    @Override
    public KualiDecimal getItemOriginalReturnedTotalQuantity() {
        return itemOriginalReturnedTotalQuantity;
    }

    @Override
    public void setItemOriginalReturnedTotalQuantity(KualiDecimal itemOriginalReturnedTotalQuantity) {
        this.itemOriginalReturnedTotalQuantity = itemOriginalReturnedTotalQuantity;
    }

    @Override
    public KualiDecimal getItemOriginalDamagedTotalQuantity() {
        return itemOriginalDamagedTotalQuantity;
    }

    @Override
    public void setItemOriginalDamagedTotalQuantity(KualiDecimal itemOriginalDamagedTotalQuantity) {
        this.itemOriginalDamagedTotalQuantity = itemOriginalDamagedTotalQuantity;
    }

    public ItemReasonAdded getItemReasonAdded() {
        if (itemReasonAdded != null) {
            return itemReasonAdded;
        } else if (itemReasonAddedCode != null) {
            refreshReferenceObject(PurapPropertyConstants.ITEM_REASON_ADDED);
        }
        return itemReasonAdded;
    }

    public void setItemReasonAdded(ItemReasonAdded itemReasonAdded) {
        this.itemReasonAdded = itemReasonAdded;
    }

    @Override
    public UnitOfMeasure getItemUnitOfMeasure() {
        if (ObjectUtils.isNull(itemUnitOfMeasure)
                || (!itemUnitOfMeasure.getItemUnitOfMeasureCode().equalsIgnoreCase(getItemUnitOfMeasureCode()))) {
            refreshReferenceObject(PurapPropertyConstants.ITEM_UNIT_OF_MEASURE);
        }
        return itemUnitOfMeasure;
    }

    @Override
    public void setItemUnitOfMeasure(UnitOfMeasure itemUnitOfMeasure) {
        this.itemUnitOfMeasure = itemUnitOfMeasure;
    }

}
