/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.document;

import org.kuali.kfs.krad.document.TransactionalDocument;
import org.kuali.kfs.module.purap.businessobject.Carrier;
import org.kuali.kfs.module.purap.businessobject.DeliveryRequiredDateReason;
import org.kuali.kfs.sys.businessobject.Country;
import org.kuali.kfs.vnd.businessobject.CampusParameter;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.exception.WorkflowException;

import java.sql.Date;

public interface ReceivingDocument extends TransactionalDocument, PurapItemOperations {

    String getCarrierCode();

    void setCarrierCode(String carrierCode);

    String getShipmentPackingSlipNumber();

    void setShipmentPackingSlipNumber(String shipmentPackingSlipNumber);

    String getShipmentReferenceNumber();

    void setShipmentReferenceNumber(String shipmentReferenceNumber);

    String getShipmentBillOfLadingNumber();

    void setShipmentBillOfLadingNumber(String shipmentBillOfLadingNumber);

    Date getShipmentReceivedDate();

    void setShipmentReceivedDate(Date shipmentReceivedDate);

    Integer getVendorHeaderGeneratedIdentifier();

    void setVendorHeaderGeneratedIdentifier(Integer vendorHeaderGeneratedIdentifier);

    Integer getVendorDetailAssignedIdentifier();

    void setVendorDetailAssignedIdentifier(Integer vendorDetailAssignedIdentifier);

    String getVendorName();

    void setVendorName(String vendorName);

    String getVendorLine1Address();

    void setVendorLine1Address(String vendorLine1Address);

    String getVendorLine2Address();

    void setVendorLine2Address(String vendorLine2Address);

    String getVendorCityName();

    void setVendorCityName(String vendorCityName);

    String getVendorStateCode();

    void setVendorStateCode(String vendorStateCode);

    String getVendorPostalCode();

    void setVendorPostalCode(String vendorPostalCode);

    String getVendorCountryCode();

    void setVendorCountryCode(String vendorCountryCode);

    String getDeliveryCampusCode();

    void setDeliveryCampusCode(String deliveryCampusCode);

    String getDeliveryBuildingCode();

    void setDeliveryBuildingCode(String deliveryBuildingCode);

    String getDeliveryBuildingName();

    void setDeliveryBuildingName(String deliveryBuildingName);

    String getDeliveryBuildingRoomNumber();

    void setDeliveryBuildingRoomNumber(String deliveryBuildingRoomNumber);

    String getDeliveryBuildingLine1Address();

    void setDeliveryBuildingLine1Address(String deliveryBuildingLine1Address);

    String getDeliveryBuildingLine2Address();

    void setDeliveryBuildingLine2Address(String deliveryBuildingLine2Address);

    String getDeliveryCityName();

    void setDeliveryCityName(String deliveryCityName);

    String getDeliveryStateCode();

    void setDeliveryStateCode(String deliveryStateCode);

    String getDeliveryPostalCode();

    void setDeliveryPostalCode(String deliveryPostalCode);

    String getDeliveryCountryCode();

    void setDeliveryCountryCode(String deliveryCountryCode);

    String getDeliveryCountryName();

    String getDeliveryToName();

    void setDeliveryToName(String deliveryToName);

    String getDeliveryToEmailAddress();

    void setDeliveryToEmailAddress(String deliveryToEmailAddress);

    String getDeliveryToPhoneNumber();

    void setDeliveryToPhoneNumber(String deliveryToPhoneNumber);

    Date getDeliveryRequiredDate();

    void setDeliveryRequiredDate(Date deliveryRequiredDate);

    String getDeliveryInstructionText();

    void setDeliveryInstructionText(String deliveryInstructionText);

    String getDeliveryRequiredDateReasonCode();

    void setDeliveryRequiredDateReasonCode(String deliveryRequiredDateReasonCode);

    CampusParameter getDeliveryCampus();

    Carrier getCarrier();

    DeliveryRequiredDateReason getDeliveryRequiredDateReason();

    Country getVendorCountry();

    VendorDetail getVendorDetail();

    String getVendorNumber();

    void setVendorNumber(String vendorNumber);

    Integer getVendorAddressGeneratedIdentifier();

    void setVendorAddressGeneratedIdentifier(Integer vendorAddressGeneratedIdentifier);

    Integer getAlternateVendorDetailAssignedIdentifier();

    void setAlternateVendorDetailAssignedIdentifier(Integer alternateVendorDetailAssignedIdentifier);

    Integer getAlternateVendorHeaderGeneratedIdentifier();

    void setAlternateVendorHeaderGeneratedIdentifier(Integer alternateVendorHeaderGeneratedIdentifier);

    String getAlternateVendorName();

    void setAlternateVendorName(String alternateVendorName);

    String getAlternateVendorNumber();

    void setAlternateVendorNumber(String alternateVendorNumber);

    boolean isDeliveryBuildingOtherIndicator();

    void setDeliveryBuildingOtherIndicator(boolean deliveryBuildingOtherIndicator);

    PurchaseOrderDocument getPurchaseOrderDocument();

    void setPurchaseOrderDocument(PurchaseOrderDocument po);

    void appSpecificRouteDocumentToUser(WorkflowDocument workflowDocument, String userNetworkId, String annotation,
            String responsibility) throws WorkflowException;

    Integer getAccountsPayablePurchasingDocumentLinkIdentifier();

    void setAccountsPayablePurchasingDocumentLinkIdentifier(Integer accountsPayablePurchasingDocumentLinkIdentifier);

    boolean getIsATypeOfPurAPRecDoc();

    boolean getIsATypeOfPurDoc();

    boolean getIsATypeOfPODoc();

    boolean getIsPODoc();

    boolean getIsReqsDoc();

    String getAppDocStatus();

    void setAppDocStatus(String appDocStatus);
}
