/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.options;

import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.module.purap.RequisitionStatuses;
import org.kuali.kfs.core.api.util.ConcreteKeyValue;
import org.kuali.kfs.core.api.util.KeyValue;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

/**
 * Value Finder for Requisition Statuses.
 */
public class RequisitionStatusValuesFinder extends KeyValuesBase {

    /**
     * Override this method to sort the Req statuses for proper display.
     */
    public List<KeyValue> getKeyValues() {
        // get all REQ statuses
        final Map<String, String> keyValues = RequisitionStatuses.getAllAppDocStatuses();
        SortedSet<String> sortedKeys = new TreeSet<>(keyValues.keySet());

        // generate output
        List<KeyValue> labels = new ArrayList<>();
        for (String sortedKey : sortedKeys) {
            labels.add(new ConcreteKeyValue(sortedKey, sortedKey));
        }
        return labels;
    }

}
