/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.service.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignment;
import org.kuali.kfs.module.purap.dataaccess.SensitiveDataDao;
import org.kuali.kfs.module.purap.document.dataaccess.PurchaseOrderDao;
import org.kuali.kfs.module.purap.service.SensitiveDataService;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SensitiveDataServiceImpl implements SensitiveDataService {

    private static final Logger LOG = LogManager.getLogger();

    private SensitiveDataDao sensitiveDataDao;
    private PurchaseOrderDao purchaseOrderDao;
    private BusinessObjectService businessObjectService;

    public SensitiveData getSensitiveDataByCode(String sensitiveDataCode) {
        LOG.debug("getSensitiveDataByCode(String) started");
        Map<String, Object> primaryKeys = new HashMap<>();
        primaryKeys.put("sensitiveDataCode", sensitiveDataCode);
        return businessObjectService.findByPrimaryKey(SensitiveData.class, primaryKeys);
    }

    public List<SensitiveData> getAllSensitiveDatas() {
        LOG.debug("getSensitiveDataByPoId(Integer) started");

        List<SensitiveData> sds = new ArrayList<>();
        Collection<SensitiveData> sdColl = businessObjectService.findAll(SensitiveData.class);
        for (Object sd : sdColl) {
            sds.add((SensitiveData) sd);
        }

        return sds;
    }

    public List<SensitiveData> getSensitiveDatasAssignedByRelatedDocId(
            Integer accountsPayablePurchasingDocumentLinkIdentifier) {
        Integer poId = purchaseOrderDao.getPurchaseOrderIdForCurrentPurchaseOrderByRelatedDocId(
                accountsPayablePurchasingDocumentLinkIdentifier);
        return getSensitiveDatasAssignedByPoId(poId);
    }

    public List<SensitiveData> getSensitiveDatasAssignedByPoId(Integer poId) {
        LOG.debug("getSensitiveDatasAssignedByPoId(Integer) started");
        return sensitiveDataDao.getSensitiveDatasAssignedByPoId(poId);
    }

    public void deletePurchaseOrderSensitiveDatas(Integer poId) {
        LOG.debug("deletePurchaseOrderSensitiveDatas(Integer) started");
        sensitiveDataDao.deletePurchaseOrderSensitiveDatas(poId);
    }

    public SensitiveDataAssignment getLastSensitiveDataAssignment(Integer poId) {
        LOG.debug("getLastSensitiveDataAssignment(Integer) started");
        return sensitiveDataDao.getLastSensitiveDataAssignment(poId);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    // known user: UCI
    protected PurchaseOrderDao getPurchaseOrderDao() {
        return purchaseOrderDao;
    }

    public void setPurchaseOrderDao(PurchaseOrderDao purchaseOrderDao) {
        this.purchaseOrderDao = purchaseOrderDao;
    }

    public void setSensitiveDataDao(SensitiveDataDao sensitiveDataDao) {
        this.sensitiveDataDao = sensitiveDataDao;
    }
}
