/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.document.ElectronicInvoiceRejectDocument;

public class ElectronicInvoiceRejectItem
extends PersistableBusinessObjectBase {
    private Integer invoiceRejectItemIdentifier;
    private Integer purapDocumentIdentifier;
    private Integer invoiceItemLineNumber;
    private BigDecimal invoiceItemQuantity;
    private String invoiceItemUnitOfMeasureCode;
    private String invoiceItemCatalogNumber;
    private String invoiceItemUnitPriceCurrencyCode;
    private String invoiceItemSubTotalCurrencyCode;
    private String invoiceItemSpecialHandlingCurrencyCode;
    private String invoiceItemShippingCurrencyCode;
    private String invoiceItemShippingDescription;
    private String invoiceItemTaxCurrencyCode;
    private String invoiceItemTaxDescription;
    private String invoiceItemGrossCurrencyCode;
    private String invoiceItemDiscountCurrencyCode;
    private String invoiceItemNetCurrencyCode;
    private BigDecimal invoiceItemUnitPrice;
    private BigDecimal invoiceItemSubTotalAmount;
    private BigDecimal invoiceItemSpecialHandlingAmount;
    private BigDecimal invoiceItemShippingAmount;
    private BigDecimal invoiceItemTaxAmount;
    private BigDecimal invoiceItemGrossAmount;
    private BigDecimal invoiceItemDiscountAmount;
    private BigDecimal invoiceItemNetAmount;
    private Integer invoiceReferenceItemLineNumber;
    private String invoiceReferenceItemSerialNumber;
    private String invoiceReferenceItemSupplierPartIdentifier;
    private String invoiceReferenceItemSupplierPartAuxiliaryIdentifier;
    private String invoiceReferenceItemDescription;
    private String invoiceReferenceItemManufacturerPartIdentifier;
    private String invoiceReferenceItemManufacturerName;
    private String invoiceReferenceItemCountryCode;
    private String invoiceReferenceItemCountryName;
    private boolean unitOfMeasureAcceptIndicator = false;
    private boolean catalogNumberAcceptIndicator = false;
    private ElectronicInvoiceRejectDocument electronicInvoiceRejectDocument;

    public ElectronicInvoiceRejectItem() {
    }

    public ElectronicInvoiceRejectItem(ElectronicInvoiceRejectDocument electronicInvoiceRejectDocument, ElectronicInvoiceItem eii) {
        this.electronicInvoiceRejectDocument = electronicInvoiceRejectDocument;
        try {
            this.invoiceItemLineNumber = Integer.parseInt(eii.getInvoiceLineNumber());
        }
        catch (NumberFormatException n) {
            this.invoiceItemLineNumber = null;
        }
        this.invoiceItemCatalogNumber = eii.getCatalogNumber();
        this.invoiceItemQuantity = eii.getInvoiceLineQuantityBigDecimal();
        this.invoiceItemUnitOfMeasureCode = eii.getUnitOfMeasure();
        this.invoiceReferenceItemLineNumber = eii.getReferenceLineNumberInteger();
        this.invoiceReferenceItemSerialNumber = eii.getReferenceSerialNumber();
        this.invoiceReferenceItemSupplierPartIdentifier = eii.getReferenceItemIDSupplierPartID();
        this.invoiceReferenceItemSupplierPartAuxiliaryIdentifier = eii.getReferenceItemIDSupplierPartAuxID();
        this.invoiceReferenceItemDescription = eii.getReferenceDescription();
        this.invoiceReferenceItemManufacturerPartIdentifier = eii.getReferenceManufacturerPartID();
        this.invoiceReferenceItemManufacturerName = eii.getReferenceManufacturerName();
        this.invoiceReferenceItemCountryCode = eii.getReferenceCountryCode();
        this.invoiceReferenceItemCountryName = eii.getReferenceCountryName();
        this.invoiceItemUnitPriceCurrencyCode = eii.getUnitPriceCurrency();
        this.invoiceItemSubTotalCurrencyCode = eii.getSubTotalAmountCurrency();
        this.invoiceItemSpecialHandlingCurrencyCode = eii.getInvoiceLineSpecialHandlingAmountCurrency();
        this.invoiceItemShippingCurrencyCode = eii.getInvoiceLineShippingAmountCurrency();
        this.invoiceItemShippingDescription = eii.getInvoiceLineShippingDescription();
        this.invoiceItemTaxCurrencyCode = eii.getTaxAmountCurrency();
        this.invoiceItemTaxDescription = eii.getTaxDescription();
        this.invoiceItemGrossCurrencyCode = eii.getInvoiceLineGrossAmountCurrency();
        this.invoiceItemDiscountCurrencyCode = eii.getInvoiceLineDiscountAmountCurrency();
        this.invoiceItemNetCurrencyCode = eii.getInvoiceLineNetAmountCurrency();
        this.invoiceItemUnitPrice = eii.getInvoiceLineUnitCostBigDecimal();
        this.invoiceItemSubTotalAmount = eii.getInvoiceLineSubTotalAmountBigDecimal();
        this.invoiceItemSpecialHandlingAmount = eii.getInvoiceLineSpecialHandlingAmountBigDecimal();
        this.invoiceItemShippingAmount = eii.getInvoiceLineShippingAmountBigDecimal();
        this.invoiceItemTaxAmount = eii.getInvoiceLineTaxAmountBigDecimal();
        this.invoiceItemGrossAmount = eii.getInvoiceLineGrossAmountBigDecimal();
        this.invoiceItemDiscountAmount = eii.getInvoiceLineDiscountAmountBigDecimal();
        this.invoiceItemNetAmount = eii.getInvoiceLineNetAmountBigDecimal();
        this.invoiceItemSubTotalAmount = StringUtils.isEmpty((CharSequence)eii.getSubTotalAmount()) ? (this.invoiceItemQuantity != null && BigDecimal.ZERO.compareTo(this.invoiceItemQuantity) != 0 && this.invoiceItemUnitPrice != null && BigDecimal.ZERO.compareTo(this.invoiceItemUnitPrice) != 0 ? this.invoiceItemQuantity.multiply(this.invoiceItemUnitPrice) : (this.invoiceItemQuantity == null && this.invoiceItemUnitPrice != null && BigDecimal.ZERO.compareTo(this.invoiceItemUnitPrice) != 0 ? this.invoiceItemUnitPrice : null)) : eii.getInvoiceLineSubTotalAmountBigDecimal();
    }

    public Integer getPurapDocumentIdentifier() {
        return this.purapDocumentIdentifier;
    }

    public void setPurapDocumentIdentifier(Integer purapDocumentIdentifier) {
        this.purapDocumentIdentifier = purapDocumentIdentifier;
    }

    public ElectronicInvoiceRejectDocument getElectronicInvoiceRejectDocument() {
        return this.electronicInvoiceRejectDocument;
    }

    public void setElectronicInvoiceRejectDocument(ElectronicInvoiceRejectDocument electronicInvoiceRejectDocument) {
        this.electronicInvoiceRejectDocument = electronicInvoiceRejectDocument;
    }

    public Integer getInvoiceRejectItemIdentifier() {
        return this.invoiceRejectItemIdentifier;
    }

    public void setInvoiceRejectItemIdentifier(Integer id) {
        this.invoiceRejectItemIdentifier = id;
    }

    public String getInvoiceItemCatalogNumber() {
        return this.invoiceItemCatalogNumber;
    }

    public void setInvoiceItemCatalogNumber(String invoiceCatalogNumber) {
        this.invoiceItemCatalogNumber = invoiceCatalogNumber;
    }

    public BigDecimal getInvoiceItemDiscountAmount() {
        return this.invoiceItemDiscountAmount;
    }

    public void setInvoiceItemDiscountAmount(BigDecimal invoiceDiscountAmount) {
        this.invoiceItemDiscountAmount = invoiceDiscountAmount;
    }

    public String getInvoiceItemDiscountCurrencyCode() {
        return this.invoiceItemDiscountCurrencyCode;
    }

    public void setInvoiceItemDiscountCurrencyCode(String invoiceDiscountCurrencyCode) {
        this.invoiceItemDiscountCurrencyCode = invoiceDiscountCurrencyCode;
    }

    public BigDecimal getInvoiceItemGrossAmount() {
        return this.invoiceItemGrossAmount;
    }

    public void setInvoiceItemGrossAmount(BigDecimal invoiceGrossAmount) {
        this.invoiceItemGrossAmount = invoiceGrossAmount;
    }

    public String getInvoiceItemGrossCurrencyCode() {
        return this.invoiceItemGrossCurrencyCode;
    }

    public void setInvoiceItemGrossCurrencyCode(String invoiceGrossCurrencyCode) {
        this.invoiceItemGrossCurrencyCode = invoiceGrossCurrencyCode;
    }

    public BigDecimal getInvoiceItemQuantity() {
        return this.invoiceItemQuantity;
    }

    public void setInvoiceItemQuantity(BigDecimal invoiceItemQuantity) {
        this.invoiceItemQuantity = invoiceItemQuantity;
    }

    public String getInvoiceItemUnitOfMeasureCode() {
        return this.invoiceItemUnitOfMeasureCode;
    }

    public void setInvoiceItemUnitOfMeasureCode(String invoiceItemUnitOfMeasureCode) {
        this.invoiceItemUnitOfMeasureCode = invoiceItemUnitOfMeasureCode;
    }

    public BigDecimal getInvoiceItemNetAmount() {
        BigDecimal returnValue = this.getInvoiceItemSubTotalAmount();
        if (returnValue != null) {
            if (this.getInvoiceItemShippingAmount() != null) {
                returnValue = returnValue.add(this.getInvoiceItemShippingAmount());
            }
            if (this.getInvoiceItemSpecialHandlingAmount() != null) {
                returnValue = returnValue.add(this.getInvoiceItemSpecialHandlingAmount());
            }
            if (this.getInvoiceItemTaxAmount() != null) {
                returnValue = returnValue.add(this.getInvoiceItemTaxAmount());
            }
            this.invoiceItemGrossAmount = returnValue;
            if (this.getInvoiceItemDiscountAmount() != null) {
                returnValue = returnValue.subtract(this.getInvoiceItemDiscountAmount());
            }
            returnValue = returnValue.setScale(4, RoundingMode.HALF_UP);
        }
        this.invoiceItemNetAmount = returnValue;
        return this.invoiceItemNetAmount;
    }

    public void setInvoiceItemNetAmount(BigDecimal invoiceNetAmount) {
        this.invoiceItemNetAmount = invoiceNetAmount;
    }

    public String getInvoiceItemNetCurrencyCode() {
        return this.invoiceItemNetCurrencyCode;
    }

    public void setInvoiceItemNetCurrencyCode(String invoiceNetCurrencyCode) {
        this.invoiceItemNetCurrencyCode = invoiceNetCurrencyCode;
    }

    public BigDecimal getInvoiceItemShippingAmount() {
        return this.invoiceItemShippingAmount;
    }

    public void setInvoiceItemShippingAmount(BigDecimal invoiceShippingAmount) {
        this.invoiceItemShippingAmount = invoiceShippingAmount;
    }

    public String getInvoiceItemShippingCurrencyCode() {
        return this.invoiceItemShippingCurrencyCode;
    }

    public void setInvoiceItemShippingCurrencyCode(String invoiceShippingCurrencyCode) {
        this.invoiceItemShippingCurrencyCode = invoiceShippingCurrencyCode;
    }

    public String getInvoiceItemShippingDescription() {
        return this.invoiceItemShippingDescription;
    }

    public void setInvoiceItemShippingDescription(String invoiceShippingDescription) {
        this.invoiceItemShippingDescription = invoiceShippingDescription;
    }

    public BigDecimal getInvoiceItemSpecialHandlingAmount() {
        return this.invoiceItemSpecialHandlingAmount;
    }

    public void setInvoiceItemSpecialHandlingAmount(BigDecimal invoiceSpecialHandlingAmount) {
        this.invoiceItemSpecialHandlingAmount = invoiceSpecialHandlingAmount;
    }

    public String getInvoiceItemSpecialHandlingCurrencyCode() {
        return this.invoiceItemSpecialHandlingCurrencyCode;
    }

    public void setInvoiceItemSpecialHandlingCurrencyCode(String invoiceSpecialHandlingCurrencyCode) {
        this.invoiceItemSpecialHandlingCurrencyCode = invoiceSpecialHandlingCurrencyCode;
    }

    public BigDecimal getInvoiceItemSubTotalAmount() {
        BigDecimal returnValue = this.invoiceItemQuantity != null && BigDecimal.ZERO.compareTo(this.invoiceItemQuantity) != 0 && this.invoiceItemUnitPrice != null && BigDecimal.ZERO.compareTo(this.invoiceItemUnitPrice) != 0 ? this.invoiceItemQuantity.multiply(this.invoiceItemUnitPrice) : (this.invoiceItemQuantity == null && this.invoiceItemUnitPrice != null && BigDecimal.ZERO.compareTo(this.invoiceItemUnitPrice) != 0 ? this.invoiceItemUnitPrice : null);
        this.invoiceItemSubTotalAmount = returnValue != null ? returnValue.setScale(4, RoundingMode.HALF_UP) : null;
        return this.invoiceItemSubTotalAmount;
    }

    public void setInvoiceItemSubTotalAmount(BigDecimal invoiceSubTotalAmount) {
        this.invoiceItemSubTotalAmount = invoiceSubTotalAmount;
    }

    public String getInvoiceItemSubTotalCurrencyCode() {
        return this.invoiceItemSubTotalCurrencyCode;
    }

    public void setInvoiceItemSubTotalCurrencyCode(String invoiceSubTotalCurrencyCode) {
        this.invoiceItemSubTotalCurrencyCode = invoiceSubTotalCurrencyCode;
    }

    public BigDecimal getInvoiceItemTaxAmount() {
        return this.invoiceItemTaxAmount;
    }

    public void setInvoiceItemTaxAmount(BigDecimal invoiceTaxAmount) {
        this.invoiceItemTaxAmount = invoiceTaxAmount;
    }

    public String getInvoiceItemTaxCurrencyCode() {
        return this.invoiceItemTaxCurrencyCode;
    }

    public void setInvoiceItemTaxCurrencyCode(String invoiceTaxCurrencyCode) {
        this.invoiceItemTaxCurrencyCode = invoiceTaxCurrencyCode;
    }

    public String getInvoiceItemTaxDescription() {
        return this.invoiceItemTaxDescription;
    }

    public void setInvoiceItemTaxDescription(String invoiceTaxDescription) {
        this.invoiceItemTaxDescription = invoiceTaxDescription;
    }

    public BigDecimal getInvoiceItemUnitPrice() {
        return this.invoiceItemUnitPrice;
    }

    public void setInvoiceItemUnitPrice(BigDecimal invoiceUnitPrice) {
        this.invoiceItemUnitPrice = invoiceUnitPrice;
    }

    public String getInvoiceItemUnitPriceCurrencyCode() {
        return this.invoiceItemUnitPriceCurrencyCode;
    }

    public void setInvoiceItemUnitPriceCurrencyCode(String invoiceUnitPriceCurrency) {
        this.invoiceItemUnitPriceCurrencyCode = invoiceUnitPriceCurrency;
    }

    public Integer getInvoiceItemLineNumber() {
        return this.invoiceItemLineNumber;
    }

    public void setInvoiceItemLineNumber(Integer itemLineNumber) {
        this.invoiceItemLineNumber = itemLineNumber;
    }

    public String getInvoiceReferenceItemCountryCode() {
        return this.invoiceReferenceItemCountryCode;
    }

    public void setInvoiceReferenceItemCountryCode(String itemReferenceCountryCode) {
        this.invoiceReferenceItemCountryCode = itemReferenceCountryCode;
    }

    public String getInvoiceReferenceItemCountryName() {
        return this.invoiceReferenceItemCountryName;
    }

    public void setInvoiceReferenceItemCountryName(String itemReferenceCountryName) {
        this.invoiceReferenceItemCountryName = itemReferenceCountryName;
    }

    public String getInvoiceReferenceItemDescription() {
        return this.invoiceReferenceItemDescription;
    }

    public void setInvoiceReferenceItemDescription(String itemReferenceDescription) {
        this.invoiceReferenceItemDescription = itemReferenceDescription;
    }

    public Integer getInvoiceReferenceItemLineNumber() {
        return this.invoiceReferenceItemLineNumber;
    }

    public void setInvoiceReferenceItemLineNumber(Integer itemReferenceLineNumber) {
        this.invoiceReferenceItemLineNumber = itemReferenceLineNumber;
    }

    public String getInvoiceReferenceItemManufacturerName() {
        return this.invoiceReferenceItemManufacturerName;
    }

    public void setInvoiceReferenceItemManufacturerName(String itemReferenceManufacturerName) {
        this.invoiceReferenceItemManufacturerName = itemReferenceManufacturerName;
    }

    public String getInvoiceReferenceItemManufacturerPartIdentifier() {
        return this.invoiceReferenceItemManufacturerPartIdentifier;
    }

    public void setInvoiceReferenceItemManufacturerPartIdentifier(String itemReferenceManufacturerPartId) {
        this.invoiceReferenceItemManufacturerPartIdentifier = itemReferenceManufacturerPartId;
    }

    public String getInvoiceReferenceItemSerialNumber() {
        return this.invoiceReferenceItemSerialNumber;
    }

    public void setInvoiceReferenceItemSerialNumber(String itemReferenceSerialNumber) {
        this.invoiceReferenceItemSerialNumber = itemReferenceSerialNumber;
    }

    public String getInvoiceReferenceItemSupplierPartAuxiliaryIdentifier() {
        return this.invoiceReferenceItemSupplierPartAuxiliaryIdentifier;
    }

    public void setInvoiceReferenceItemSupplierPartAuxiliaryIdentifier(String itemReferenceSupplierPartAuxId) {
        this.invoiceReferenceItemSupplierPartAuxiliaryIdentifier = itemReferenceSupplierPartAuxId;
    }

    public String getInvoiceReferenceItemSupplierPartIdentifier() {
        return this.invoiceReferenceItemSupplierPartIdentifier;
    }

    public void setInvoiceReferenceItemSupplierPartIdentifier(String itemReferenceSupplierPartId) {
        this.invoiceReferenceItemSupplierPartIdentifier = itemReferenceSupplierPartId;
    }

    public boolean isUnitOfMeasureAcceptIndicator() {
        return this.unitOfMeasureAcceptIndicator;
    }

    public void setUnitOfMeasureAcceptIndicator(boolean unitOfMeasureAcceptIndicator) {
        this.unitOfMeasureAcceptIndicator = unitOfMeasureAcceptIndicator;
    }

    public boolean isCatalogNumberAcceptIndicator() {
        return this.catalogNumberAcceptIndicator;
    }

    public void setCatalogNumberAcceptIndicator(boolean catalogNumberAcceptIndicator) {
        this.catalogNumberAcceptIndicator = catalogNumberAcceptIndicator;
    }
}

