/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.businessobject.ContractManagerAssignmentDetail;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.sys.DynamicCollectionComparator;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;

public class ContractManagerAssignmentDocument
extends FinancialSystemTransactionalDocumentBase {
    private static final Logger LOG = LogManager.getLogger();
    protected List<ContractManagerAssignmentDetail> contractManagerAssignmentDetails = new ArrayList<ContractManagerAssignmentDetail>();
    protected String requisitionNumber;
    protected String deliveryCampusCode;
    protected String vendorName;
    protected String generalDescription;
    protected String requisitionTotalAmount;
    protected String requisitionCreateDate;
    protected String firstItemDescription;
    protected String firstItemCommodityCode;
    protected String firstObjectCode;
    protected String universityFiscalYear;

    public ContractManagerAssignmentDetail getContractManagerAssignmentDetail(int index) {
        while (this.contractManagerAssignmentDetails.size() <= index) {
            this.contractManagerAssignmentDetails.add(new ContractManagerAssignmentDetail());
        }
        return this.contractManagerAssignmentDetails.get(index);
    }

    public void populateDocumentWithRequisitions() {
        LOG.debug("populateDocumentWithRequisitions() Entering method.");
        ArrayList<RequisitionDocument> unassignedRequisitions = new ArrayList<RequisitionDocument>(((RequisitionService)SpringContext.getBean(RequisitionService.class)).getRequisitionsAwaitingContractManagerAssignment());
        ArrayList<String> documentHeaderIds = new ArrayList<String>();
        for (RequisitionDocument requisitionDocument : unassignedRequisitions) {
            documentHeaderIds.add(requisitionDocument.getDocumentNumber());
        }
        List requisitionDocumentsFromDocService = new ArrayList();
        if (documentHeaderIds.size() > 0) {
            requisitionDocumentsFromDocService = ((DocumentService)SpringContext.getBean(DocumentService.class)).getDocumentsByListOfDocumentHeaderIds(RequisitionDocument.class, documentHeaderIds);
        }
        for (Document req : requisitionDocumentsFromDocService) {
            this.contractManagerAssignmentDetails.add(new ContractManagerAssignmentDetail(this, (RequisitionDocument)req));
        }
        String[] stringArray = new String[]{"deliveryCampusCode", "vendorName", "requisitionIdentifier"};
        DynamicCollectionComparator.sort(this.contractManagerAssignmentDetails, (String[])stringArray);
        LOG.debug("populateDocumentWithRequisitions() Leaving method.");
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        LOG.debug("doRouteStatusChange() Entering method.");
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).processACMReq(this);
        }
        LOG.debug("doRouteStatusChange() Leaving method.");
    }

    public String getDocumentTitle() {
        String title = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(ContractManagerAssignmentDocument.class, "OVERRIDE_DOCUMENT_TITLE_IND") != false ? "Contract Manager Assignment" : super.getDocumentTitle();
        return title;
    }

    public List getContractManagerAssignmentDetails() {
        return this.contractManagerAssignmentDetails;
    }

    public void setContractManagerAssignmentDetailss(List contractManagerAssignmentDetails) {
        this.contractManagerAssignmentDetails = contractManagerAssignmentDetails;
    }

    public String getFirstObjectCode() {
        return this.firstObjectCode;
    }

    public String getDeliveryCampusCode() {
        return this.deliveryCampusCode;
    }

    public String getFirstItemDescription() {
        return this.firstItemDescription;
    }

    public String getFirstItemCommodityCode() {
        return this.firstItemCommodityCode;
    }

    public String getGeneralDescription() {
        return this.generalDescription;
    }

    public String getRequisitionCreateDate() {
        return this.requisitionCreateDate;
    }

    public String getRequisitionNumber() {
        return this.requisitionNumber;
    }

    public String getRequisitionTotalAmount() {
        return this.requisitionTotalAmount;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getUniversityFiscalYear() {
        return this.universityFiscalYear;
    }
}

