/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.batch.ScrubberStep;
import org.kuali.kfs.kew.api.KewApiServiceLocator;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.action.DocumentActionParameters;
import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.kew.routeheader.DocumentStatusTransition;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.api.services.KimApiServiceLocator;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kim.impl.identity.principal.Principal;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.AccountsPayableDocumentSpecificService;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.PurapGeneralLedgerService;
import org.kuali.kfs.module.purap.util.ExpiredOrClosedAccount;
import org.kuali.kfs.module.purap.util.ExpiredOrClosedAccountEntry;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AccountsPayableServiceImpl
implements AccountsPayableService {
    protected PurapAccountingService purapAccountingService;
    protected PurapGeneralLedgerService purapGeneralLedgerService;
    protected DocumentService documentService;
    protected PurapService purapService;
    protected ParameterService parameterService;
    protected DateTimeService dateTimeService;
    protected PurchaseOrderService purchaseOrderService;
    protected AccountService accountService;
    private ConfigurationService configurationService;
    private PersonService personService;
    private AccountsPayableService accountsPayableService;
    private NoteService noteService;
    private BusinessObjectService businessObjectService;
    private WorkflowDocumentService workflowDocumentService;

    @Override
    public HashMap<String, ExpiredOrClosedAccountEntry> getExpiredOrClosedAccountList(AccountsPayableDocument document) {
        return this.expiredOrClosedAccountsList(document);
    }

    @Override
    public void generateExpiredOrClosedAccountNote(AccountsPayableDocument document, HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList) {
        if (ObjectUtils.isNotNull(expiredOrClosedAccountList) && !expiredOrClosedAccountList.isEmpty()) {
            this.addContinuationAccountsNote(document, expiredOrClosedAccountList);
        }
    }

    @Override
    public void generateExpiredOrClosedAccountWarning(AccountsPayableDocument document) {
        Person user = GlobalVariables.getUserSession().getPerson();
        String showContinuationAccountWaringFO = this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "SHOW_CONTINUATION_ACCOUNT_WARNING_FISCAL_OFFICERS_IND");
        String showContinuationAccountWaringAP = this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "SHOW_CONTINUATION_ACCOUNT_WARNING_AP_USERS_IND");
        if (this.isFiscalUser(document, user) && "Y".equals(showContinuationAccountWaringFO) && document.isContinuationAccountIndicator()) {
            KNSGlobalVariables.getMessageList().add("message.closed.or.expired.accounts.replaced", new String[0]);
        }
        if (this.isAPUser(document, user) && "Y".equals(showContinuationAccountWaringAP) && document.isContinuationAccountIndicator()) {
            KNSGlobalVariables.getMessageList().add("message.closed.or.expired.accounts.replaced", new String[0]);
        }
    }

    @Override
    public void processExpiredOrClosedAccount(PurApAccountingLineBase acctLineBase, HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList) {
        ExpiredOrClosedAccountEntry accountEntry;
        String acctKey = acctLineBase.getChartOfAccountsCode() + "-" + acctLineBase.getAccountNumber();
        if (expiredOrClosedAccountList.containsKey(acctKey) && !(accountEntry = expiredOrClosedAccountList.get(acctKey)).getOriginalAccount().isContinuationAccountMissing()) {
            acctLineBase.setChartOfAccountsCode(accountEntry.getReplacementAccount().getChartOfAccountsCode());
            acctLineBase.setAccountNumber(accountEntry.getReplacementAccount().getAccountNumber());
            acctLineBase.setSubAccountNumber(null);
            acctLineBase.setFinancialSubObjectCode(null);
            acctLineBase.refreshReferenceObject("chart");
            acctLineBase.refreshReferenceObject("account");
        }
    }

    protected void addContinuationAccountsNote(AccountsPayableDocument document, HashMap<String, ExpiredOrClosedAccountEntry> accounts) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, ExpiredOrClosedAccountEntry>> entries = accounts.entrySet();
        for (Map.Entry<String, ExpiredOrClosedAccountEntry> entry : entries) {
            ExpiredOrClosedAccountEntry accountEntry = entry.getValue();
            ExpiredOrClosedAccount originalAccount = accountEntry.getOriginalAccount();
            ExpiredOrClosedAccount replacementAccount = accountEntry.getReplacementAccount();
            if (originalAccount.isContinuationAccountMissing()) continue;
            String nteMsg = this.configurationService.getPropertyValueAsString("note.acct.expired.using.continuation.acct");
            sb.append(MessageFormat.format(nteMsg, originalAccount.getAccountString(), replacementAccount.getAccountString()));
        }
        if (sb.toString().length() > 0) {
            try {
                Note resetNote = this.documentService.createNoteFromDocument((Document)document, sb.toString());
                Principal kfs = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("kfs");
                resetNote.setAuthorUniversalIdentifier(kfs.getPrincipalId());
                document.addNote(resetNote);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create a note on this document. " + e);
            }
        }
    }

    protected Account getReplaceAccountForClosedAccount(Account account, AccountsPayableDocument document) {
        if (account == null) {
            return null;
        }
        return this.accountService.getByPrimaryId(account.getContinuationFinChrtOfAcctCd(), account.getContinuationAccountNumber());
    }

    protected Account getReplaceAccountForExpiredAccount(Account account, AccountsPayableDocument document) {
        if (account == null) {
            return null;
        }
        return this.accountService.getByPrimaryId(account.getContinuationFinChrtOfAcctCd(), account.getContinuationAccountNumber());
    }

    protected HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountsList(AccountsPayableDocument document) {
        PurchaseOrderDocument po = document.getPurchaseOrderDocument();
        if (po == null && document instanceof VendorCreditMemoDocument) {
            PaymentRequestDocument preq = ((VendorCreditMemoDocument)document).getPaymentRequestDocument();
            if (preq == null) {
                return null;
            }
            po = ((VendorCreditMemoDocument)document).getPaymentRequestDocument().getPurchaseOrderDocument();
        }
        if (po == null) {
            return null;
        }
        List<SourceAccountingLine> acctLines = this.purapAccountingService.generateSummary(po.getItemsActiveOnly());
        HashMap<String, ExpiredOrClosedAccountEntry> eocAcctMap = new HashMap<String, ExpiredOrClosedAccountEntry>();
        for (SourceAccountingLine acctLine : acctLines) {
            ExpiredOrClosedAccount replaceAcct;
            Account account = this.accountService.getByPrimaryId(acctLine.getChartOfAccountsCode(), acctLine.getAccountNumber());
            Account repAccount = null;
            boolean replace = false;
            if (!account.isActive()) {
                repAccount = this.getReplaceAccountForClosedAccount(account, document);
                replace = true;
            } else if (account.isExpired()) {
                String expirationExtensionDays = this.parameterService.getParameterValueAsString(ScrubberStep.class, "CG_ACCOUNT_EXPIRATION_EXTENSION_DAYS");
                int expirationExtensionDaysInt = 90;
                if (expirationExtensionDays.trim().length() > 0) {
                    expirationExtensionDaysInt = new Integer(expirationExtensionDays);
                }
                if (account.isForContractsAndGrants() && this.dateTimeService.dateDiff((Date)account.getAccountExpirationDate(), this.dateTimeService.getCurrentDate(), true) > expirationExtensionDaysInt) {
                    repAccount = this.getReplaceAccountForExpiredAccount(account, document);
                    replace = true;
                }
            }
            if (!replace) continue;
            ExpiredOrClosedAccountEntry eocAcctEntry = new ExpiredOrClosedAccountEntry();
            ExpiredOrClosedAccount originAcct = new ExpiredOrClosedAccount(acctLine.getChartOfAccountsCode(), acctLine.getAccountNumber(), acctLine.getSubAccountNumber());
            if (repAccount == null) {
                replaceAcct = new ExpiredOrClosedAccount();
                originAcct.setContinuationAccountMissing(true);
            } else {
                replaceAcct = new ExpiredOrClosedAccount(repAccount.getChartOfAccountsCode(), repAccount.getAccountNumber(), acctLine.getSubAccountNumber());
            }
            eocAcctEntry.setOriginalAccount(originAcct);
            eocAcctEntry.setReplacementAccount(replaceAcct);
            eocAcctMap.put(this.createChartAccountString(originAcct), eocAcctEntry);
        }
        return eocAcctMap;
    }

    @Override
    public HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountsList(PurchaseOrderDocument po) {
        HashMap<String, ExpiredOrClosedAccountEntry> list = new HashMap<String, ExpiredOrClosedAccountEntry>();
        if (po != null) {
            List<SourceAccountingLine> accountList = this.purapAccountingService.generateSummary(po.getItemsActiveOnly());
            for (SourceAccountingLine poAccountingLine : accountList) {
                ExpiredOrClosedAccount replaceAcct;
                Account continuationAccount;
                Account account = this.accountService.getByPrimaryId(poAccountingLine.getChartOfAccountsCode(), poAccountingLine.getAccountNumber());
                ExpiredOrClosedAccountEntry entry = new ExpiredOrClosedAccountEntry();
                ExpiredOrClosedAccount originalAcct = new ExpiredOrClosedAccount(poAccountingLine.getChartOfAccountsCode(), poAccountingLine.getAccountNumber(), poAccountingLine.getSubAccountNumber());
                if (!account.isActive()) {
                    continuationAccount = this.accountService.getByPrimaryId(account.getContinuationFinChrtOfAcctCd(), account.getContinuationAccountNumber());
                    if (continuationAccount == null) {
                        replaceAcct = new ExpiredOrClosedAccount();
                        originalAcct.setContinuationAccountMissing(true);
                        entry.setOriginalAccount(originalAcct);
                        entry.setReplacementAccount(replaceAcct);
                        list.put(this.createChartAccountString(originalAcct), entry);
                        continue;
                    }
                    replaceAcct = new ExpiredOrClosedAccount(continuationAccount.getChartOfAccountsCode(), continuationAccount.getAccountNumber(), poAccountingLine.getSubAccountNumber());
                    entry.setOriginalAccount(originalAcct);
                    entry.setReplacementAccount(replaceAcct);
                    list.put(this.createChartAccountString(originalAcct), entry);
                    continue;
                }
                if (!account.isExpired()) continue;
                continuationAccount = this.accountService.getByPrimaryId(account.getContinuationFinChrtOfAcctCd(), account.getContinuationAccountNumber());
                String expirationExtensionDays = this.parameterService.getParameterValueAsString(ScrubberStep.class, "CG_ACCOUNT_EXPIRATION_EXTENSION_DAYS");
                int expirationExtensionDaysInt = 90;
                if (expirationExtensionDays.trim().length() > 0) {
                    expirationExtensionDaysInt = new Integer(expirationExtensionDays);
                }
                if (!account.isForContractsAndGrants() || this.dateTimeService.dateDiff((Date)account.getAccountExpirationDate(), this.dateTimeService.getCurrentDate(), true) <= expirationExtensionDaysInt) continue;
                if (continuationAccount == null) {
                    replaceAcct = new ExpiredOrClosedAccount();
                    originalAcct.setContinuationAccountMissing(true);
                    entry.setOriginalAccount(originalAcct);
                    entry.setReplacementAccount(replaceAcct);
                    list.put(this.createChartAccountString(originalAcct), entry);
                    continue;
                }
                replaceAcct = new ExpiredOrClosedAccount(continuationAccount.getChartOfAccountsCode(), continuationAccount.getAccountNumber(), poAccountingLine.getSubAccountNumber());
                entry.setOriginalAccount(originalAcct);
                entry.setReplacementAccount(replaceAcct);
                list.put(this.createChartAccountString(originalAcct), entry);
            }
        }
        return list;
    }

    protected String createChartAccountString(ExpiredOrClosedAccount ecAccount) {
        return ecAccount.getChartOfAccountsCode() + "-" + ecAccount.getAccountNumber();
    }

    protected boolean isFiscalUser(AccountsPayableDocument document, Person user) {
        boolean isFiscalUser = false;
        if ("Awaiting Fiscal Officer Approval".equals(document.getApplicationDocumentStatus()) && document.getDocumentHeader().getWorkflowDocument().isApprovalRequested()) {
            isFiscalUser = true;
        }
        return isFiscalUser;
    }

    protected boolean isAPUser(AccountsPayableDocument document, Person user) {
        boolean isFiscalUser = false;
        if ("Awaiting AP Review".equals(document.getApplicationDocumentStatus()) && document.getDocumentHeader().getWorkflowDocument().isApprovalRequested() || "In Process".equals(document.getApplicationDocumentStatus())) {
            isFiscalUser = true;
        }
        return isFiscalUser;
    }

    @Override
    public void cancelAccountsPayableDocument(AccountsPayableDocument apDocument, String currentNodeName) {
        if (this.purapService.isFullDocumentEntryCompleted(apDocument)) {
            this.purapGeneralLedgerService.generateEntriesCancelAccountsPayableDocument(apDocument);
        }
        AccountsPayableDocumentSpecificService accountsPayableDocumentSpecificService = apDocument.getDocumentSpecificService();
        accountsPayableDocumentSpecificService.updateStatusByNode(currentNodeName, apDocument);
        accountsPayableDocumentSpecificService.takePurchaseOrderCancelAction(apDocument);
    }

    @Override
    public void revertToPreviousAppDocStatus(AccountsPayableDocument accountsPayableDocument) {
        List history = this.workflowDocumentService.getDocumentStatusTransitionHistory(accountsPayableDocument.getDocumentNumber());
        history.sort(Comparator.comparing(DocumentStatusTransition::getStatusTransitionDate));
        String nodeName = ((DocumentStatusTransition)history.get(history.size() - 1)).getOldAppDocStatus();
        if (!StringUtils.isNotBlank((CharSequence)nodeName)) {
            throw new RuntimeException("No status found to set for document '" + nodeName + "'");
        }
        accountsPayableDocument.updateAndSaveAppDocStatus(nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAccountsPayableDocumentByCheckingDocumentStatus(AccountsPayableDocument document, String noteText) throws Exception {
        UserSession originalUserSession;
        if ("In Process".equals(document.getApplicationDocumentStatus())) {
            this.documentService.cancelDocument((Document)document, noteText);
        } else if ("Awaiting AP Review".equals(document.getApplicationDocumentStatus())) {
            originalUserSession = GlobalVariables.getUserSession();
            GlobalVariables.setUserSession((UserSession)new UserSession("kfs"));
            WorkflowDocument workflowDocument = this.workflowDocumentService.loadWorkflowDocument(document.getDocumentNumber(), GlobalVariables.getUserSession().getPerson());
            document.getDocumentHeader().setWorkflowDocument(workflowDocument);
            this.documentService.superUserDisapproveDocumentWithoutSaving((Document)document, noteText);
            GlobalVariables.setUserSession((UserSession)originalUserSession);
        } else if (document instanceof PaymentRequestDocument && "Awaiting Fiscal Officer Approval".equals(document.getApplicationDocumentStatus()) && ((PaymentRequestDocument)document).isPaymentRequestedCancelIndicator()) {
            DocumentActionParameters.Builder p = DocumentActionParameters.Builder.create((String)document.getDocumentNumber(), (String)document.getLastActionPerformedByPersonId());
            p.setAnnotation("Document cancelled after requested cancel by " + GlobalVariables.getUserSession().getUserToLog());
            KewApiServiceLocator.getWorkflowDocumentActionsService().disapprove(p.build());
        } else {
            originalUserSession = GlobalVariables.getUserSession();
            WorkflowDocument originalWorkflowDocument = document.getDocumentHeader().getWorkflowDocument();
            if (!document.getDocumentHeader().getWorkflowDocument().isApproved()) {
                try {
                    Person userRequestedCancel = this.personService.getPerson(document.getLastActionPerformedByPersonId());
                    GlobalVariables.setUserSession((UserSession)new UserSession("kfs"));
                    WorkflowDocument newWorkflowDocument = this.workflowDocumentService.loadWorkflowDocument(document.getDocumentNumber(), GlobalVariables.getUserSession().getPerson());
                    document.getDocumentHeader().setWorkflowDocument(newWorkflowDocument);
                    Object annotation = "Document Cancelled by user " + originalUserSession.getPerson().getName() + " (" + originalUserSession.getPerson().getPrincipalName() + ")";
                    if (ObjectUtils.isNotNull((Object)userRequestedCancel)) {
                        annotation = ((String)annotation).concat(" per request of user " + userRequestedCancel.getName() + " (" + userRequestedCancel.getPrincipalName() + ")");
                    }
                    this.documentService.superUserDisapproveDocument((Document)document, (String)annotation);
                }
                finally {
                    GlobalVariables.setUserSession((UserSession)originalUserSession);
                    document.getDocumentHeader().setWorkflowDocument(originalWorkflowDocument);
                }
            } else {
                this.accountsPayableService.cancelAccountsPayableDocument(document, "");
                document.getDocumentHeader().getWorkflowDocument().logAnnotation("Document Cancelled by user " + originalUserSession.getPerson().getName() + " (" + originalUserSession.getPerson().getPrincipalName() + ")");
            }
        }
        Note noteObj = this.documentService.createNoteFromDocument((Document)document, noteText);
        document.addNote(noteObj);
        this.noteService.save(noteObj);
    }

    @Override
    public void performLogicForFullEntryCompleted(PurchasingAccountsPayableDocument purapDocument) {
        AccountsPayableDocument apDocument = (AccountsPayableDocument)purapDocument;
        AccountsPayableDocumentSpecificService accountsPayableDocumentSpecificService = apDocument.getDocumentSpecificService();
        this.purapService.deleteUnenteredItems(apDocument);
        this.purapAccountingService.updateAccountAmounts(apDocument);
        apDocument.setAccountsPayableApprovalTimestamp(this.dateTimeService.getCurrentTimestamp());
        this.businessObjectService.save((PersistableBusinessObject)apDocument);
        accountsPayableDocumentSpecificService.generateGLEntriesCreateAccountsPayableDocument(apDocument);
    }

    @Override
    public void updateItemList(AccountsPayableDocument apDocument) {
        block11: {
            block9: {
                VendorCreditMemoDocument cm;
                block10: {
                    if (this.purapService.isFullDocumentEntryCompleted(apDocument)) {
                        return;
                    }
                    if (!(apDocument instanceof VendorCreditMemoDocument)) break block9;
                    cm = (VendorCreditMemoDocument)apDocument;
                    if (!cm.isSourceDocumentPaymentRequest()) break block10;
                    List items = cm.getPaymentRequestDocument().getItems();
                    for (PaymentRequestItem preqItem : items) {
                        if (preqItem.getItemType().isAdditionalChargeIndicator()) continue;
                        PurchaseOrderItem poItem = preqItem.getPurchaseOrderItem();
                        CreditMemoItem cmItem = (CreditMemoItem)cm.getAPItemFromPOItem(poItem);
                        this.updateEncumberances(preqItem, poItem, cmItem);
                    }
                    break block11;
                }
                if (!cm.isSourceDocumentPurchaseOrder()) break block11;
                PurchaseOrderDocument po = this.purchaseOrderService.getCurrentPurchaseOrder(apDocument.getPurchaseOrderIdentifier());
                List poItems = po.getItems();
                List cmItems = cm.getItems();
                for (PurchaseOrderItem purchaseOrderItem : poItems) {
                    if (purchaseOrderItem.getItemType().isAdditionalChargeIndicator()) continue;
                    CreditMemoItem cmItem = (CreditMemoItem)cm.getAPItemFromPOItem(purchaseOrderItem);
                    if (apDocument.getDocumentSpecificService().poItemEligibleForAp(apDocument, purchaseOrderItem)) {
                        if (ObjectUtils.isNull((Object)cmItem)) {
                            CreditMemoItem cmi = new CreditMemoItem(cm, purchaseOrderItem);
                            cmi.setPurapDocument(apDocument);
                            cmItems.add(cmi);
                            continue;
                        }
                        this.updateEncumberance(purchaseOrderItem, cmItem);
                        continue;
                    }
                    if (!ObjectUtils.isNotNull((Object)cmItem)) continue;
                    cmItems.remove(cmItem);
                }
                break block11;
            }
            if (apDocument instanceof PaymentRequestDocument) {
                PurchaseOrderDocument po = this.purchaseOrderService.getCurrentPurchaseOrder(apDocument.getPurchaseOrderIdentifier());
                PaymentRequestDocument preq = (PaymentRequestDocument)apDocument;
                List poItems = po.getItems();
                List preqItems = preq.getItems();
                for (PurchaseOrderItem purchaseOrderItem : poItems) {
                    if (purchaseOrderItem.getItemType().isAdditionalChargeIndicator()) continue;
                    PaymentRequestItem preqItem = (PaymentRequestItem)preq.getAPItemFromPOItem(purchaseOrderItem);
                    if (apDocument.getDocumentSpecificService().poItemEligibleForAp(apDocument, purchaseOrderItem)) {
                        if (ObjectUtils.isNull((Object)preqItem)) {
                            PaymentRequestItem pri = new PaymentRequestItem(purchaseOrderItem, preq);
                            pri.setPurapDocument(apDocument);
                            preqItems.add(pri);
                            continue;
                        }
                        this.updatePossibleAmmendedFields(purchaseOrderItem, preqItem);
                        continue;
                    }
                    if (!ObjectUtils.isNotNull((Object)preqItem)) continue;
                    preqItems.remove(preqItem);
                }
            }
        }
    }

    protected void updatePossibleAmmendedFields(PurchaseOrderItem sourceItem, PaymentRequestItem destItem) {
        destItem.setPurchaseOrderItemUnitPrice(sourceItem.getItemUnitPrice());
        destItem.setItemCatalogNumber(sourceItem.getItemCatalogNumber());
        destItem.setItemDescription(sourceItem.getItemDescription());
    }

    protected void updateEncumberances(PaymentRequestItem preqItem, PurchaseOrderItem poItem, CreditMemoItem cmItem) {
        if (poItem.getItemInvoicedTotalQuantity() != null && preqItem.getItemQuantity() != null && poItem.getItemInvoicedTotalQuantity().isLessThan((AbstractKualiDecimal)preqItem.getItemQuantity())) {
            cmItem.setPreqInvoicedTotalQuantity(poItem.getItemInvoicedTotalQuantity());
            cmItem.setPreqUnitPrice(poItem.getItemUnitPrice());
            cmItem.setPreqTotalAmount(poItem.getItemInvoicedTotalAmount());
        } else {
            cmItem.setPreqInvoicedTotalQuantity(preqItem.getItemQuantity());
            cmItem.setPreqUnitPrice(preqItem.getItemUnitPrice());
            cmItem.setPreqTotalAmount(preqItem.getTotalAmount());
        }
    }

    protected void updateEncumberance(PurchaseOrderItem purchaseOrderItem, CreditMemoItem cmItem) {
        cmItem.setPoInvoicedTotalQuantity(purchaseOrderItem.getItemInvoicedTotalQuantity());
        cmItem.setPreqUnitPrice(purchaseOrderItem.getItemUnitPrice());
        cmItem.setPoTotalAmount(purchaseOrderItem.getItemInvoicedTotalAmount());
    }

    @Override
    public boolean purchaseOrderItemEligibleForPayment(PurchaseOrderItem poi) {
        if (ObjectUtils.isNull((Object)poi)) {
            throw new RuntimeException("item null in purchaseOrderItemEligibleForPayment ... this should never happen");
        }
        if (!poi.isItemActiveIndicator()) {
            return false;
        }
        ItemType poiType = poi.getItemType();
        if (poiType.isQuantityBasedGeneralLedgerIndicator()) {
            return poi.getItemQuantity().isGreaterThan((AbstractKualiDecimal)poi.getItemInvoicedTotalQuantity());
        }
        return poi.getItemOutstandingEncumberedAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO);
    }

    @Override
    public boolean canCopyAccountingLinesWithZeroAmount() {
        String copyZeroAmountLine = this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "COPY_ACCOUNTING_LINES_WITH_ZERO_AMOUNT_FROM_PO_TO_PREQ_IND");
        return "Y".equalsIgnoreCase(copyZeroAmountLine);
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public void setPurapAccountingService(PurapAccountingService purapAccountingService) {
        this.purapAccountingService = purapAccountingService;
    }

    public void setPurapGeneralLedgerService(PurapGeneralLedgerService purapGeneralLedgerService) {
        this.purapGeneralLedgerService = purapGeneralLedgerService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAccountsPayableService(AccountsPayableService accountsPayableService) {
        this.accountsPayableService = accountsPayableService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }
}

