/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.web.format.CurrencyFormatter;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedExpiredAccountWarningEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedTradeInWarningEvent;
import org.kuali.kfs.module.purap.document.validation.impl.AccountsPayableDocumentPreRulesBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class PaymentRequestDocumentPreRules
extends AccountsPayableDocumentPreRulesBase {
    @Override
    public boolean doPrompts(Document document) {
        PaymentRequestDocument preq = (PaymentRequestDocument)document;
        if (!((PurapService)SpringContext.getBean(PurapService.class)).isFullDocumentEntryCompleted(preq) || StringUtils.equals((CharSequence)preq.getApplicationDocumentStatus(), (CharSequence)"Awaiting AP Review")) {
            if (!this.confirmPayDayNotOverThresholdDaysAway(preq)) {
                return false;
            }
            if (!this.confirmUnusedTradeIn(preq)) {
                return false;
            }
            if (!this.confirmEncumberNextFiscalYear(preq)) {
                return false;
            }
            if (!this.confirmEncumberPriorFiscalYear(preq)) {
                return false;
            }
        }
        if (((PurapService)SpringContext.getBean(PurapService.class)).isFullDocumentEntryCompleted(preq) && !this.confirmExpiredAccount(preq)) {
            return false;
        }
        return super.doPrompts(document);
    }

    protected boolean askForConfirmation(String questionType, String messageConstant) {
        String questionText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString(messageConstant);
        if (questionText.contains("{")) {
            questionText = this.prepareQuestionText(questionType, questionText);
        } else if (StringUtils.equals((CharSequence)messageConstant, (CharSequence)"error.gl.AccountExpired") || StringUtils.equals((CharSequence)messageConstant, (CharSequence)"warning.item.tradeIn.amount.unused")) {
            questionText = questionType;
        }
        boolean confirmOverride = super.askOrAnalyzeYesNoQuestion(questionType, questionText);
        if (!confirmOverride) {
            this.event.setActionForwardName("basic");
            return false;
        }
        return true;
    }

    protected String prepareQuestionText(String questionType, String questionText) {
        if (StringUtils.equals((CharSequence)questionType, (CharSequence)"Threshold Days Override Question")) {
            questionText = StringUtils.replace((String)questionText, (String)"{0}", (String)Integer.toString(60));
        }
        return questionText;
    }

    public boolean confirmPayDayNotOverThresholdDaysAway(PaymentRequestDocument preq) {
        int thresholdDays = 60;
        if (preq.getPaymentRequestPayDate() != null && ((PurapService)SpringContext.getBean(PurapService.class)).isDateMoreThanANumberOfDaysAway(preq.getPaymentRequestPayDate(), thresholdDays)) {
            return this.askForConfirmation("Threshold Days Override Question", "message.paymentRequest.payDate.over.threshold.days");
        }
        return true;
    }

    public boolean confirmUnusedTradeIn(PaymentRequestDocument preq) {
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedTradeInWarningEvent("", (Document)preq));
        if (!rulePassed) {
            return this.askForConfirmation("There is an unused trade in amount from PO that you could apply to line item; are you sure you want to proceed ?", "warning.item.tradeIn.amount.unused");
        }
        return true;
    }

    public boolean confirmExpiredAccount(PaymentRequestDocument preq) {
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedExpiredAccountWarningEvent("", (Document)preq));
        if (!rulePassed) {
            return this.askForConfirmation("There is an expired account on the document; do you want to continue ?", "error.gl.AccountExpired");
        }
        return true;
    }

    public boolean confirmEncumberNextFiscalYear(PaymentRequestDocument preq) {
        Integer fiscalYear = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
        if (preq.getPurchaseOrderDocument().getPostingYear() > fiscalYear) {
            return this.askForConfirmation("Encumber Next Fiscal Year Question", "warning.encumber.nextFY");
        }
        return true;
    }

    public boolean confirmEncumberPriorFiscalYear(PaymentRequestDocument preq) {
        Integer fiscalYear = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
        if (preq.getPurchaseOrderDocument().getPostingYear().intValue() == fiscalYear.intValue() && ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).allowBackpost(preq)) {
            return this.askForConfirmation("Encumber Prior Fiscal Year Question", "warning.encumber.priorFY");
        }
        return true;
    }

    @Override
    public String getDocumentName() {
        return "Payment Request";
    }

    @Override
    public String createInvoiceNoMatchQuestionText(AccountsPayableDocument accountsPayableDocument) {
        boolean salesTaxInd;
        String questionText = super.createInvoiceNoMatchQuestionText(accountsPayableDocument);
        CurrencyFormatter cf = new CurrencyFormatter();
        PaymentRequestDocument preq = (PaymentRequestDocument)accountsPayableDocument;
        StringBuffer questionTextBuffer = new StringBuffer();
        questionTextBuffer.append(questionText);
        questionTextBuffer.append("[br][br][b]Summary Detail Below:[b][br][br][table questionTable]");
        questionTextBuffer.append("[tr][td left]Vendor Invoice Amount entered on start screen:[/td][td right]").append(cf.format((Object)preq.getInitialAmount())).append("[/td][/tr]");
        questionTextBuffer.append("[tr][td left]Invoice Total Prior to Additional Charges:[/td][td right]").append(cf.format((Object)preq.getTotalPreTaxDollarAmountAboveLineItems())).append("[/td][/tr]");
        if (preq.isDiscount()) {
            questionTextBuffer.append("[tr][td left]Total Before Discount:[/td][td right]").append(cf.format((Object)preq.getGrandPreTaxTotalExcludingDiscount())).append("[/td][/tr]");
        }
        if (salesTaxInd = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_SALES_TAX_IND").booleanValue()) {
            questionTextBuffer.append("[tr][td left]Grand Total Prior to Tax:[/td][td right]").append(cf.format((Object)preq.getGrandPreTaxTotal())).append("[/td][/tr]");
            questionTextBuffer.append("[tr][td left]Grand Total Tax:[/td][td right]").append(cf.format((Object)preq.getGrandTaxAmount())).append("[/td][/tr]");
        }
        questionTextBuffer.append("[tr][td left]Grand Total:[/td][td right]").append(cf.format((Object)preq.getGrandTotal())).append("[/td][/tr][/table]");
        return questionTextBuffer.toString();
    }

    @Override
    protected boolean checkCAMSWarningStatus(PurchasingAccountsPayableDocument purapDocument) {
        return PurapConstants.CAMSWarningStatuses.PAYMENT_REQUEST_STATUS_WARNING_NO_CAMS_DATA.contains(purapDocument.getApplicationDocumentStatus());
    }

    @Override
    protected boolean validateInvoiceTotalsAreMismatched(AccountsPayableDocument accountsPayableDocument) {
        boolean mismatched = false;
        PaymentRequestDocument payReqDoc = (PaymentRequestDocument)accountsPayableDocument;
        String[] excludeArray = new String[]{"DISC"};
        if (payReqDoc.isUseTaxIndicator()) {
            if (payReqDoc.getTotalPreTaxDollarAmountAllItems(excludeArray).compareTo((AbstractKualiDecimal)accountsPayableDocument.getInitialAmount()) != 0 && !accountsPayableDocument.isUnmatchedOverride()) {
                mismatched = true;
            }
        } else if (accountsPayableDocument.getTotalDollarAmountAllItems(excludeArray).compareTo((AbstractKualiDecimal)accountsPayableDocument.getInitialAmount()) != 0 && !accountsPayableDocument.isUnmatchedOverride()) {
            mismatched = true;
        }
        return mismatched;
    }
}

