/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AddAccountingLineEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class VendorCreditMemoAccountPercentBetween0And100Validation
extends GenericValidation {
    private DataDictionaryService dataDictionaryService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean isValid = true;
        PurApAccountingLine account = (PurApAccountingLine)((AddAccountingLineEvent)event).getAccountingLine();
        if (this.validateRequiredField((BusinessObject)account, "accountLinePercent")) {
            double pct = account.getAccountLinePercent().doubleValue();
            if (pct <= 0.0 || pct > 100.0) {
                GlobalVariables.getMessageMap().putError("accountLinePercent", "errors.creditMemo.line.percent", new String[0]);
                isValid = false;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    protected boolean validateRequiredField(BusinessObject businessObject, String fieldName) {
        boolean valid = true;
        Object fieldValue = ObjectUtils.getPropertyValue((Object)businessObject, (String)fieldName);
        if (fieldValue == null || fieldValue instanceof String && StringUtils.isBlank((CharSequence)fieldName)) {
            String label = this.dataDictionaryService.getAttributeErrorLabel(businessObject.getClass(), fieldName);
            GlobalVariables.getMessageMap().putError(fieldName, "error.required", new String[]{label});
            valid = false;
        }
        return valid;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

