/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.util.PurApDateFormatUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.util.KfsDateUtils;

public final class ElectronicInvoiceUtils {
    private static DateTimeService dateTimeService;

    private ElectronicInvoiceUtils() {
    }

    public static java.sql.Date getDate(String invoiceDateString) {
        boolean formatInvalid = true;
        String stringToParse = null;
        if (StringUtils.isNotEmpty((CharSequence)invoiceDateString)) {
            String formattedDateString = invoiceDateString.replaceAll("\\d", "0");
            if (PurApDateFormatUtils.getFormattingString(PurapConstants.NamedDateFormats.CXML_DATE_FORMAT).equals(formattedDateString)) {
                formatInvalid = false;
                stringToParse = invoiceDateString;
            } else {
                if (PurApDateFormatUtils.getFormattingString(PurapConstants.NamedDateFormats.KUALI_DATE_FORMAT).equals(formattedDateString)) {
                    try {
                        Date javaDate = ElectronicInvoiceUtils.getDateTimeService().convertToDate(invoiceDateString);
                        return KfsDateUtils.convertToSqlDate((Date)javaDate);
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                if (PurApDateFormatUtils.getFormattingString(PurapConstants.NamedDateFormats.CXML_DATE_FORMAT).length() != formattedDateString.length()) {
                    formattedDateString = formattedDateString.substring(0, PurApDateFormatUtils.getFormattingString(PurapConstants.NamedDateFormats.CXML_DATE_FORMAT).length());
                    if (PurApDateFormatUtils.getFormattingString(PurapConstants.NamedDateFormats.CXML_DATE_FORMAT).equals(formattedDateString)) {
                        formatInvalid = false;
                        stringToParse = invoiceDateString.substring(0, PurApDateFormatUtils.getFormattingString(PurapConstants.NamedDateFormats.CXML_DATE_FORMAT).length());
                    }
                }
            }
        }
        if (formatInvalid) {
            return null;
        }
        SimpleDateFormat sdf = PurApDateFormatUtils.getSimpleDateFormat(PurapConstants.NamedDateFormats.CXML_SIMPLE_DATE_FORMAT);
        try {
            return KfsDateUtils.convertToSqlDate((Date)sdf.parse(stringToParse));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getDateDisplayText(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        String monthPart = "" + (c.get(2) + 1);
        String dayPart = "" + c.get(5);
        if (monthPart.length() == 1) {
            monthPart = "0" + monthPart;
        }
        if (dayPart.length() == 1) {
            dayPart = "0" + dayPart;
        }
        return monthPart + "/" + dayPart + "/" + c.get(1);
    }

    public static String stripSplChars(String data) {
        if (data != null) {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < data.length(); ++i) {
                if (!Character.isLetterOrDigit(data.charAt(i))) continue;
                result.append(data.charAt(i));
            }
            return result.toString();
        }
        return null;
    }

    private static DateTimeService getDateTimeService() {
        if (dateTimeService == null) {
            dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        }
        return dateTimeService;
    }
}

