/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import org.kuali.kfs.kew.api.document.DocumentStatus;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.LineItemReceivingItem;
import org.kuali.kfs.module.purap.document.LineItemReceivingDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.fixture.LineItemReceivingDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class LineItemReceivingDocumentIntegTest
extends KualiIntegTestBase {
    public static final Class<LineItemReceivingDocument> DOCUMENT_CLASS = LineItemReceivingDocument.class;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private int getExpectedPrePeCount() {
        return 0;
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public final void testRouteDocument() throws Exception {
        PurchaseOrderDocument po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS.createPurchaseOrderDocument();
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        po.prepareForSave();
        AccountingDocumentTestUtils.routeDocument((FinancialSystemTransactionalDocument)po, (String)"saving copy source document", null, (DocumentService)documentService);
        WorkflowTestUtils.waitForDocumentApproval((String)po.getDocumentNumber());
        PurchaseOrderDocument poResult = (PurchaseOrderDocument)documentService.getByDocumentHeaderId(po.getDocumentNumber());
        LineItemReceivingDocument receivingLineDocument = LineItemReceivingDocumentFixture.EMPTY_LINE_ITEM_RECEIVING.createLineItemReceivingDocument();
        receivingLineDocument.populateReceivingLineFromPurchaseOrder(poResult);
        for (LineItemReceivingItem rli : receivingLineDocument.getItems()) {
            rli.setItemReceivedTotalQuantity(rli.getItemOrderedQuantity());
            rli.setLineItemReceivingDocument(receivingLineDocument);
        }
        receivingLineDocument.prepareForSave();
        LineItemReceivingDocumentIntegTest.assertFalse((boolean)DocumentStatus.ENROUTE.equals((Object)receivingLineDocument.getDocumentHeader().getWorkflowDocument().getStatus()));
        this.routeDocument((Document)receivingLineDocument, "routing line item receiving document", documentService);
        WorkflowTestUtils.waitForDocumentApproval((String)receivingLineDocument.getDocumentNumber());
        Document document = documentService.getByDocumentHeaderId(receivingLineDocument.getDocumentNumber());
        LineItemReceivingDocumentIntegTest.assertTrue((String)"Document should now be final.", (boolean)receivingLineDocument.getDocumentHeader().getWorkflowDocument().isFinal());
    }

    private void routeDocument(Document document, String annotation, DocumentService documentService) {
        try {
            documentService.routeDocument(document, annotation, null);
        }
        catch (ValidationException e) {
            LineItemReceivingDocumentIntegTest.fail((String)(e.getMessage() + ", " + GlobalVariables.getMessageMap()));
        }
    }
}

