/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderDocumentPreRules;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PurchaseOrderDocumentPreRulesTest {
    private PurchaseOrderDocumentPreRules cut;
    @Mock
    private PurchaseOrderDocument poDocMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PurchaseOrderDocumentPreRules();
        KNSGlobalVariables.getMessageList().clear();
    }

    @Test
    public void validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit_ZeroAmountSmallLimit() {
        Mockito.when((Object)this.poDocMock.getTotalDollarAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)this.poDocMock.getPurchaseOrderTotalLimit()).thenReturn((Object)new KualiDecimal(32));
        Assert.assertTrue((boolean)this.cut.validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit((PurchasingDocument)this.poDocMock));
    }

    @Test
    public void validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit_SmallAmountSmallLimit() {
        Mockito.when((Object)this.poDocMock.getTotalDollarAmount()).thenReturn((Object)new KualiDecimal(32));
        Mockito.when((Object)this.poDocMock.getPurchaseOrderTotalLimit()).thenReturn((Object)new KualiDecimal(32));
        Assert.assertTrue((boolean)this.cut.validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit((PurchasingDocument)this.poDocMock));
    }

    @Test
    public void validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit_LargeAmountSmallLimit() {
        Mockito.when((Object)this.poDocMock.getTotalDollarAmount()).thenReturn((Object)new KualiDecimal(1024));
        Mockito.when((Object)this.poDocMock.getPurchaseOrderTotalLimit()).thenReturn((Object)new KualiDecimal(32));
        Assert.assertFalse((boolean)this.cut.validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit((PurchasingDocument)this.poDocMock));
        Assert.assertTrue((boolean)KNSGlobalVariables.getMessageList().contains((Object)new ErrorMessage("warning.purchaseOrderTotalLimit", new String[0])));
    }
}

