/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.validation.event.AttributedAddPurchasingAccountsPayableItemEvent;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderEmptyItemWithAccountsValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PurchaseOrderEmptyItemWithAccountsValidationTest {
    private PurchaseOrderEmptyItemWithAccountsValidation cut;
    @Mock
    private ItemType itemTypeMock;
    @Mock
    private PurchaseOrderItem poItemMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.poItemMock.getItemType()).thenReturn((Object)this.itemTypeMock);
        this.cut = new PurchaseOrderEmptyItemWithAccountsValidation();
        this.cut.setItemForValidation(this.poItemMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    public void validate_LineItemType_NullItem_WithAccount() {
        Mockito.when((Object)this.itemTypeMock.isLineItemIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.poItemMock.isItemDetailEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.poItemMock.isAccountListEmpty()).thenReturn((Object)false);
        this.cut.setItemForValidation(this.poItemMock);
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", null, (PurApItem)this.poItemMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.notallowed"));
    }

    @Test
    public void validate_LineItemType_WithItem_WithAccount() {
        Mockito.when((Object)this.itemTypeMock.isLineItemIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.poItemMock.isItemDetailEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.poItemMock.isAccountListEmpty()).thenReturn((Object)false);
        this.cut.setItemForValidation(this.poItemMock);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", null, (PurApItem)this.poItemMock)));
    }

    @Test
    public void validate_LineItemType_WithItem_WithoutAccount() {
        Mockito.when((Object)this.itemTypeMock.isLineItemIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.poItemMock.isItemDetailEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.poItemMock.isAccountListEmpty()).thenReturn((Object)true);
        this.cut.setItemForValidation(this.poItemMock);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", null, (PurApItem)this.poItemMock)));
    }

    @Test
    public void validate_NonLineItemType_NullItem_WithAccount() {
        Mockito.when((Object)this.itemTypeMock.isLineItemIndicator()).thenReturn((Object)false);
        Mockito.when((Object)this.poItemMock.isItemDetailEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.poItemMock.isAccountListEmpty()).thenReturn((Object)false);
        this.cut.setItemForValidation(this.poItemMock);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", null, (PurApItem)this.poItemMock)));
    }

    @Test
    public void validate_NonLineItemType_WithItem_WithAccount() {
        Mockito.when((Object)this.itemTypeMock.isLineItemIndicator()).thenReturn((Object)false);
        Mockito.when((Object)this.poItemMock.isItemDetailEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.poItemMock.isAccountListEmpty()).thenReturn((Object)false);
        this.cut.setItemForValidation(this.poItemMock);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", null, (PurApItem)this.poItemMock)));
    }

    @Test
    public void validate_NonLineItemType_WithItem_WithoutAccount() {
        Mockito.when((Object)this.itemTypeMock.isLineItemIndicator()).thenReturn((Object)false);
        Mockito.when((Object)this.poItemMock.isItemDetailEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.poItemMock.isAccountListEmpty()).thenReturn((Object)true);
        this.cut.setItemForValidation(this.poItemMock);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", null, (PurApItem)this.poItemMock)));
    }
}

