/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorStipulation;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderProcessVendorStipulationValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PurchaseOrderProcessVendorStipulationValidationTest {
    private PurchaseOrderProcessVendorStipulationValidation cut;
    @Mock
    private PurchaseOrderDocument poDocMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PurchaseOrderProcessVendorStipulationValidation();
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    public void validate_StipulationDescription_NotBlank() {
        PurchaseOrderVendorStipulation vendorStipulation = new PurchaseOrderVendorStipulation();
        vendorStipulation.setVendorStipulationDescription("test");
        Mockito.when((Object)this.poDocMock.getPurchaseOrderVendorStipulations()).thenReturn(Collections.singletonList(vendorStipulation));
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.poDocMock)));
    }

    @Test
    public void validate_StipulationDescription_Blank() {
        PurchaseOrderVendorStipulation vendorStipulation = new PurchaseOrderVendorStipulation();
        vendorStipulation.setVendorStipulationDescription("");
        Mockito.when((Object)this.poDocMock.getPurchaseOrderVendorStipulations()).thenReturn(Collections.singletonList(vendorStipulation));
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.poDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.purchaseOrderVendorStipulations[0].vendorStipulationDescription", "error.purchaseOrder.stipulationDescriptionEmpty"));
    }
}

