/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Map;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.datadictionary.validation.fieldlevel.PhoneNumberValidationPattern;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.validation.PurapRuleIntegTestBase;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingPaymentInfoValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingProcessVendorValidation;
import org.kuali.kfs.module.purap.document.validation.impl.RequisitionProcessAdditionalValidation;
import org.kuali.kfs.module.purap.fixture.AmountsLimitsFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class RequisitionDocumentRuleIntegTest
extends PurapRuleIntegTestBase {
    private Map<String, GenericValidation> validations;
    RequisitionDocument req;

    protected void setUp() throws Exception {
        super.setUp();
        this.req = new RequisitionDocument();
        this.validations = SpringContext.getBeansOfType(GenericValidation.class);
    }

    protected void tearDown() throws Exception {
        this.validations = null;
        this.req = null;
        super.tearDown();
    }

    public void testValidateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit_ZeroAmountSmallLimit() {
        this.req = AmountsLimitsFixture.ZERO_AMOUNT_SMALL_LIMIT.populateRequisition();
        RequisitionProcessAdditionalValidation validation = (RequisitionProcessAdditionalValidation)this.validations.get("Requisition-processAdditionalValidation-test");
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.req)));
    }

    public void testValidateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit_SmallAmountSmallLimit() {
        this.req = AmountsLimitsFixture.SMALL_AMOUNT_SMALL_LIMIT.populateRequisition();
        RequisitionProcessAdditionalValidation validation = (RequisitionProcessAdditionalValidation)this.validations.get("Requisition-processAdditionalValidation-test");
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.req)));
    }

    public void testValidateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit_LargeAmountSmallLimit() {
        this.req = AmountsLimitsFixture.LARGE_AMOUNT_SMALL_LIMIT.populateRequisition();
        RequisitionProcessAdditionalValidation validation = (RequisitionProcessAdditionalValidation)this.validations.get("Requisition-processAdditionalValidation-test");
        RequisitionDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.req)));
    }

    public void testProcessVendorValidation_REQ_B2B_With_Debarred_Vendor() {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_B2B_WITH_DEBARRED_VENDOR.createRequisitionDocument();
        PurchasingProcessVendorValidation validation = (PurchasingProcessVendorValidation)this.validations.get("Purchasing-processVendorValidation-test");
        RequisitionDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
        if (((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean("KFS-PURAP", "Requisition", "SHOW_DEBARRED_VENDOR_WARNING_IND").booleanValue()) {
            RequisitionDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasWarnings());
        } else {
            RequisitionDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.debarred.vendor"));
        }
    }

    public void testProcessVendorValidation_REQ_B2B_With_Inactive_Vendor() {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_B2B_WITH_INACTIVE_VENDOR.createRequisitionDocument();
        PurchasingProcessVendorValidation validation = (PurchasingProcessVendorValidation)this.validations.get("Purchasing-processVendorValidation-test");
        RequisitionDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.inactive.vendor"));
    }

    public void testProcessVendorValidation_REQ_B2B_With_DV_Vendor() {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_B2B_WITH_DV_VENDOR.createRequisitionDocument();
        PurchasingProcessVendorValidation validation = (PurchasingProcessVendorValidation)this.validations.get("Purchasing-processVendorValidation-test");
        RequisitionDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.vendorType.invalid"));
    }

    public void testProcessVendorValidation_REQ_Invalid_Vendor_Fax_Number_Contains_Letter() {
        boolean validationFailed = false;
        RequisitionDocument req = RequisitionDocumentFixture.REQ_INVALID_VENDOR_FAX_NUMBER_CONTAINS_LETTER.createRequisitionDocument();
        PurchasingProcessVendorValidation validation = (PurchasingProcessVendorValidation)this.validations.get("Purchasing-processVendorValidation-test");
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
        try {
            req.validateBusinessRules((KualiDocumentEvent)new SaveDocumentEvent((Document)req));
        }
        catch (ValidationException e) {
            validationFailed = true;
        }
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)validationFailed);
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey(new PhoneNumberValidationPattern().getValidationErrorMessageKey()));
    }

    public void testProcessVendorValidation_REQ_Invalid_Vendor_Fax_Number_Bad_Format() {
        boolean validationFailed = false;
        RequisitionDocument req = RequisitionDocumentFixture.REQ_INVALID_VENDOR_FAX_NUMBER_BAD_FORMAT.createRequisitionDocument();
        PurchasingProcessVendorValidation validation = (PurchasingProcessVendorValidation)this.validations.get("Purchasing-processVendorValidation-test");
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
        try {
            req.validateBusinessRules((KualiDocumentEvent)new SaveDocumentEvent((Document)req));
        }
        catch (ValidationException e) {
            validationFailed = true;
        }
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)validationFailed);
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey(new PhoneNumberValidationPattern().getValidationErrorMessageKey()));
    }

    public void testProcessVendorValidation_REQ_Valid_Vendor_Fax_Number() {
        boolean validationFailed = false;
        RequisitionDocument req = RequisitionDocumentFixture.REQ_VALID_VENDOR_FAX_NUMBER.createRequisitionDocument();
        PurchasingProcessVendorValidation validation = (PurchasingProcessVendorValidation)this.validations.get("Purchasing-processVendorValidation-test");
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
        try {
            req.validateBusinessRules((KualiDocumentEvent)new SaveDocumentEvent((Document)req));
        }
        catch (ValidationException e) {
            validationFailed = true;
        }
        RequisitionDocumentRuleIntegTest.assertFalse((boolean)validationFailed);
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasNoErrors());
    }

    public void testProcessVendorValidation_REQ_B2B_WITH_INVALID_US_VENDOR_ZIP_CODE_CONTAINS_LETTER() {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_B2B_WITH_INVALID_US_VENDOR_ZIP_CODE_CONTAINS_LETTER.createRequisitionDocument();
        PurchasingProcessVendorValidation validation = (PurchasingProcessVendorValidation)this.validations.get("Purchasing-processVendorValidation-test");
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
    }

    public void testProcessVendorValidation_REQ_WITH_INVALID_NON_US_VENDOR_ZIP_CODE_CONTAINS_LETTER() {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_WITH_INVALID_NON_US_VENDOR_ZIP_CODE_CONTAINS_LETTER.createRequisitionDocument();
        PurchasingProcessVendorValidation validation = (PurchasingProcessVendorValidation)this.validations.get("Purchasing-processVendorValidation-test");
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
    }

    public void testCheckBeginDateAfterEndDate() {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_PO_BEGIN_DATE_AFTER_END_DATE.createRequisitionDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        RequisitionDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.purchaseOrder.beginDateAfterEnd"));
    }

    public void testCheckBeginDateNoEndDate() {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_PO_BEGIN_DATE_NO_END_DATE.createRequisitionDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        RequisitionDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.purchaseOrder.beginDateNoEndDate"));
    }

    public void testCheckEndDateNoBeginDate() {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_PO_END_DATE_NO_BEGIN_DATE.createRequisitionDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        RequisitionDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.purchaseOrder.endDateNoBeginDate"));
    }

    public void testRecurringPaymentTypeNullWhenBeginAndEndDatesAreEntered() {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_PO_BEGIN_DATE_AND_END_DATE_NO_RECURRING_PAYMENT_TYPE.createRequisitionDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        RequisitionDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.recurring.type"));
    }

    public void testRecurringPaymentTypeEnteredWithoutBeginNorEndDates() {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_WITH_RECURRING_PAYMENT_TYPE_WITHOUT_BEGIN_NOR_END_DATE.createRequisitionDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        RequisitionDocumentRuleIntegTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("errors.recurring.dates"));
    }

    public void testRecurringPaymentTypeBeginAndEndDatesEntered() {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_WITH_RECURRING_PAYMENT_TYPE_BEGIN_AND_END_DATE.createRequisitionDocument();
        PurchasingPaymentInfoValidation validation = (PurchasingPaymentInfoValidation)this.validations.get("Purchasing-paymentInfoValidation-test");
        RequisitionDocumentRuleIntegTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)req)));
    }
}

