/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentAuthorizer;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentPresentationController;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.validation.impl.RequisitionNewIndividualItemValidation;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class RequisitionNewIndividualItemValidationTest {
    private RequisitionNewIndividualItemValidation cut;
    @Mock
    private DocumentDictionaryService documentDictionarySvcMock;
    @Mock
    private ParameterService parameterSvcMock;
    @Mock
    private PurchasingAccountsPayableDocument purchasingAccountsPayableDocMock;
    @Mock
    private TransactionalDocumentAuthorizer documentAuthorizerMock;
    @Mock
    private TransactionalDocumentPresentationController documentPresentationControllerMock;
    @Mock
    private UserSession userSessionMock;

    RequisitionNewIndividualItemValidationTest() {
    }

    @BeforeEach
    void setUp() {
        RequisitionItem itemForValidation = new RequisitionItem();
        itemForValidation.setPurapDocument(this.purchasingAccountsPayableDocMock);
        this.cut = new RequisitionNewIndividualItemValidation();
        this.cut.setItemForValidation((PurApItem)itemForValidation);
        this.cut.setDocumentDictionaryService(this.documentDictionarySvcMock);
        this.cut.setParameterService(this.parameterSvcMock);
    }

    @Test
    void commodityCodeIsRequired_commodityCodeNotEnabled_false() {
        Assertions.assertFalse((boolean)this.cut.commodityCodeIsRequired());
    }

    @Test
    void commodityCodeIsRequired_commodityCodeEnabled_itemsDoNotRequireCommodityCode_false() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean("KFS-PURAP", "Document", "ENABLE_COMMODITY_CODE_IND")).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cut.commodityCodeIsRequired());
    }

    @Test
    void commodityCodeIsRequired_commodityCodeEnabled_itemsDoRequireCommodityCode_userCannotEditDoc_false() {
        boolean commodityCodeIsRequired;
        this.setupMockingForItemsRequireCommodityCode();
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);){
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)this.userSessionMock);
            commodityCodeIsRequired = this.cut.commodityCodeIsRequired();
        }
        Assertions.assertFalse((boolean)commodityCodeIsRequired);
    }

    private void setupMockingForItemsRequireCommodityCode() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean("KFS-PURAP", "Document", "ENABLE_COMMODITY_CODE_IND")).thenReturn((Object)true);
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(RequisitionDocument.class, "ITEMS_REQUIRE_COMMODITY_CODE_IND")).thenReturn((Object)true);
        Mockito.when((Object)this.documentDictionarySvcMock.getDocumentAuthorizer((Document)this.purchasingAccountsPayableDocMock)).thenReturn((Object)this.documentAuthorizerMock);
        Mockito.when((Object)this.documentDictionarySvcMock.getDocumentPresentationController((Document)this.purchasingAccountsPayableDocMock)).thenReturn((Object)this.documentPresentationControllerMock);
    }

    @Test
    void commodityCodeIsRequired_commodityCodeEnabled_itemsDoRequireCommodityCode_userCanEditDoc_true() {
        boolean commodityCodeIsRequired;
        Mockito.when((Object)this.documentAuthorizerMock.getDocumentActions((Document)this.purchasingAccountsPayableDocMock, this.userSessionMock.getActualPerson(), Set.of())).thenReturn(Set.of("canEdit"));
        this.setupMockingForItemsRequireCommodityCode();
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);){
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)this.userSessionMock);
            commodityCodeIsRequired = this.cut.commodityCodeIsRequired();
        }
        Assertions.assertTrue((boolean)commodityCodeIsRequired);
    }
}

