/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoTotalOverZeroValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class VendorCreditMemoTotalOverZeroValidationTest {
    private VendorCreditMemoTotalOverZeroValidation cut;
    @Mock
    private VendorCreditMemoDocument creditMemoDocMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new VendorCreditMemoTotalOverZeroValidation();
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    public void validate_PositiveTotal() {
        Mockito.when((Object)this.creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(32));
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    public void validate_NegativeTotal() {
        Mockito.when((Object)this.creditMemoDocMock.getGrandTotal()).thenReturn((Object)new KualiDecimal(-32));
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.item", "errors.creditMemo.total.zero"));
    }
}

