/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.purap.businessobject.CapitalAssetSystemState;
import org.kuali.kfs.module.purap.businessobject.CapitalAssetSystemType;
import org.kuali.kfs.module.purap.document.web.struts.PurchaseOrderForm;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingActionBase;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingFormBase;
import org.kuali.kfs.module.purap.document.web.struts.RequisitionForm;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PurchasingActionBaseTest {
    private PurchasingActionBase cut;
    @Mock
    private PurchaseOrderForm purchaseOrderFormMock;
    @Mock
    private RequisitionForm requisitionFormMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PurchasingActionBase();
    }

    @Test
    public void requiresCalculate_PurchaseOrderForm_UserCanCalculate_NotCalculated_True() {
        Mockito.when((Object)this.purchaseOrderFormMock.canUserCalculate()).thenReturn((Object)true);
        Mockito.when((Object)this.purchaseOrderFormMock.isCalculated()).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.cut.requiresCalculate((PurchasingFormBase)this.purchaseOrderFormMock));
    }

    @Test
    public void requiresCalculate_PurchaseOrderForm_UserCanCalculate_Calculated_False() {
        Mockito.when((Object)this.purchaseOrderFormMock.canUserCalculate()).thenReturn((Object)true);
        Mockito.when((Object)this.purchaseOrderFormMock.isCalculated()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cut.requiresCalculate((PurchasingFormBase)this.purchaseOrderFormMock));
    }

    @Test
    public void requiresCalculate_PurchaseOrderForm_UserCannotCalculate_NotCalculated_False() {
        Mockito.when((Object)this.purchaseOrderFormMock.canUserCalculate()).thenReturn((Object)false);
        Mockito.when((Object)this.purchaseOrderFormMock.isCalculated()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.cut.requiresCalculate((PurchasingFormBase)this.purchaseOrderFormMock));
    }

    @Test
    public void requiresCalculate_PurchaseOrderForm_UserCannotCalculate_Calculated_False() {
        Mockito.when((Object)this.purchaseOrderFormMock.canUserCalculate()).thenReturn((Object)false);
        Mockito.when((Object)this.purchaseOrderFormMock.isCalculated()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cut.requiresCalculate((PurchasingFormBase)this.purchaseOrderFormMock));
    }

    @Test
    public void requiresCalculate_RequisitionForm_UserCanCalculate_NotCalculated_True() {
        Mockito.when((Object)this.requisitionFormMock.canUserCalculate()).thenReturn((Object)true);
        Mockito.when((Object)this.requisitionFormMock.isCalculated()).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.cut.requiresCalculate((PurchasingFormBase)this.requisitionFormMock));
    }

    @Test
    public void requiresCalculate_RequisitionForm_UserCanCalculate_Calculated_False() {
        Mockito.when((Object)this.requisitionFormMock.canUserCalculate()).thenReturn((Object)true);
        Mockito.when((Object)this.requisitionFormMock.isCalculated()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cut.requiresCalculate((PurchasingFormBase)this.requisitionFormMock));
    }

    @Test
    public void requiresCalculate_RequisitionForm_UserCannotCalculate_NotCalculated_False() {
        Mockito.when((Object)this.requisitionFormMock.canUserCalculate()).thenReturn((Object)false);
        Mockito.when((Object)this.requisitionFormMock.isCalculated()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.cut.requiresCalculate((PurchasingFormBase)this.requisitionFormMock));
    }

    @Test
    public void requiresCalculate_RequisitionForm_UserCannotCalculate_Calculated_False() {
        Mockito.when((Object)this.requisitionFormMock.canUserCalculate()).thenReturn((Object)false);
        Mockito.when((Object)this.requisitionFormMock.isCalculated()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cut.requiresCalculate((PurchasingFormBase)this.requisitionFormMock));
    }

    @Test
    public void validateCapitalAssetSystemStateAllowed_success() {
        CapitalAssetSystemType capitalAssetSystemType = (CapitalAssetSystemType)Mockito.mock(CapitalAssetSystemType.class);
        CapitalAssetSystemState capitalAssetSystemState = (CapitalAssetSystemState)Mockito.mock(CapitalAssetSystemState.class);
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeCode()).thenReturn((Object)"IND");
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeDescription()).thenReturn((Object)"doesn't matter A");
        Mockito.when((Object)capitalAssetSystemType.getAllowedCapitalAssetSystemStateCodes()).thenReturn((Object)"MOD;NEW");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateCode()).thenReturn((Object)"MOD");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateDescription()).thenReturn((Object)"doesn't matter B");
        Assert.assertTrue((boolean)PurchasingActionBase.validateCapitalAssetSystemStateAllowed((CapitalAssetSystemType)capitalAssetSystemType, (CapitalAssetSystemState)capitalAssetSystemState));
    }

    @Test
    public void validateCapitalAssetSystemStateAllowed_failure_type_individual() {
        CapitalAssetSystemType capitalAssetSystemType = (CapitalAssetSystemType)Mockito.mock(CapitalAssetSystemType.class);
        CapitalAssetSystemState capitalAssetSystemState = (CapitalAssetSystemState)Mockito.mock(CapitalAssetSystemState.class);
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeCode()).thenReturn((Object)"IND");
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeDescription()).thenReturn((Object)"doesn't matter A");
        Mockito.when((Object)capitalAssetSystemType.getAllowedCapitalAssetSystemStateCodes()).thenReturn((Object)"MOD");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateCode()).thenReturn((Object)"NEW");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateDescription()).thenReturn((Object)"doesn't matter B");
        Assert.assertFalse((boolean)PurchasingActionBase.validateCapitalAssetSystemStateAllowed((CapitalAssetSystemType)capitalAssetSystemType, (CapitalAssetSystemState)capitalAssetSystemState));
    }

    @Test
    public void validateCapitalAssetSystemStateAllowed_failure_type_multiple() {
        CapitalAssetSystemType capitalAssetSystemType = (CapitalAssetSystemType)Mockito.mock(CapitalAssetSystemType.class);
        CapitalAssetSystemState capitalAssetSystemState = (CapitalAssetSystemState)Mockito.mock(CapitalAssetSystemState.class);
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeCode()).thenReturn((Object)"MUL");
        Mockito.when((Object)capitalAssetSystemType.getCapitalAssetSystemTypeDescription()).thenReturn((Object)"doesn't matter A");
        Mockito.when((Object)capitalAssetSystemType.getAllowedCapitalAssetSystemStateCodes()).thenReturn((Object)"MOD");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateCode()).thenReturn((Object)"NEW");
        Mockito.when((Object)capitalAssetSystemState.getCapitalAssetSystemStateDescription()).thenReturn((Object)"doesn't matter B");
        Assert.assertFalse((boolean)PurchasingActionBase.validateCapitalAssetSystemStateAllowed((CapitalAssetSystemType)capitalAssetSystemType, (CapitalAssetSystemState)capitalAssetSystemState));
    }
}

