/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.fixture;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.fixture.PurApItemFixture;
import org.kuali.kfs.module.purap.fixture.PurapTestConstants;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderItemFixture;

public enum ItemAccountsFixture {
    WITH_QUANTITY_WITH_PRICE_WITH_ACCOUNT(PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "1F742", "Test item description", PurapTestConstants.ItemsAccounts.UNIT_PRICE, PurapTestConstants.ItemsAccounts.PO_ACCOUNT),
    NULL_QUANTITY_WITH_PRICE_WITH_ACCOUNT(null, "Test item description", "EA", "1F742", PurapTestConstants.ItemsAccounts.UNIT_PRICE, PurapTestConstants.ItemsAccounts.PO_ACCOUNT),
    WITH_QUANTITY_NULL_PRICE_WITH_ACCOUNT(PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "1F742", "Test item description", null, PurapTestConstants.ItemsAccounts.PO_ACCOUNT),
    WITH_QUANTITY_WITH_PRICE_NULL_ACCOUNT(PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "1F742", "Test item description", PurapTestConstants.ItemsAccounts.UNIT_PRICE, null),
    NULL_ITEM_WITH_ACCOUNT(null, null, null, null, null, PurapTestConstants.ItemsAccounts.PO_ACCOUNT);

    private PurchaseOrderItem poItem = (PurchaseOrderItem)PurchaseOrderItemFixture.PO_QTY_UNRESTRICTED_ITEM_1.createPurchaseOrderItem(PurApItemFixture.BASIC_QTY_ITEM_1);
    private String itemDescription;
    private KualiDecimal quantity;
    private String unitOfMeasure;
    private String catNbr;
    private BigDecimal unitPrice;
    private PurchaseOrderAccount poAccount;

    private ItemAccountsFixture(KualiDecimal quantity, String unitOfMeasure, String catNbr, String itemDesc, BigDecimal unitPrice, PurchaseOrderAccount acct) {
        this.quantity = quantity;
        this.unitOfMeasure = unitOfMeasure;
        this.catNbr = catNbr;
        this.itemDescription = itemDesc;
        this.unitPrice = unitPrice;
        this.poAccount = acct;
    }

    public PurchaseOrderItem populateItem() {
        this.poItem.setItemQuantity(this.quantity);
        this.poItem.setItemUnitOfMeasureCode(this.unitOfMeasure);
        this.poItem.setItemCatalogNumber(this.catNbr);
        this.poItem.setItemDescription(this.itemDescription);
        this.poItem.setItemUnitPrice(this.unitPrice);
        if (ObjectUtils.isNotNull((Object)this.poAccount)) {
            this.poAccount.setAccountNumber("1031400");
            ArrayList<PurchaseOrderAccount> lines = new ArrayList<PurchaseOrderAccount>();
            lines.add(this.poAccount);
            this.poItem.setSourceAccountingLines(lines);
        }
        this.poItem.setItemTypeCode("ITEM");
        this.poItem.setItemLineNumber(Integer.valueOf(1));
        this.poItem.refreshNonUpdateableReferences();
        return this.poItem;
    }
}

