/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.sql.Date;
import java.util.Objects;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.core.api.config.property.ConfigContext;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.impl.config.property.Config;
import org.kuali.kfs.core.impl.datetime.DateTimeServiceImpl;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ElectronicInvoiceUtilsTest {
    @Mock
    private ParameterService parameterSvcMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.CXML_DATE_FORMAT)).thenReturn((Object)"0000-00-00");
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.KUALI_DATE_FORMAT)).thenReturn((Object)"00/00/0000");
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.CXML_SIMPLE_DATE_FORMAT)).thenReturn((Object)"yyyy-MM-dd");
    }

    @After
    public void tearDown() {
        ConfigContext.destroy();
    }

    @Test
    public void getDate_CDW_xml() {
        Date formattedDate;
        String invoiceDate = "2008-08-11T00:00:00-06:00";
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)this.parameterSvcMock);
            formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        }
        Assert.assertEquals((Object)"2008-08-11", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    public void getDate_VWR_xml() {
        Date formattedDate;
        String invoiceDate = "2008-07-29";
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)this.parameterSvcMock);
            formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        }
        Assert.assertEquals((Object)"2008-07-29", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    public void getDate_GuyBrown_xml() {
        Date formattedDate;
        String invoiceDate = "2008-07-29T12:00:00";
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)this.parameterSvcMock);
            formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        }
        Assert.assertEquals((Object)"2008-07-29", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    public void getDate_BarnesAndNoble_xml() {
        Date formattedDate;
        String invoiceDate = "2008-07-23T12:00:00-12:00";
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)this.parameterSvcMock);
            formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        }
        Assert.assertEquals((Object)"2008-07-23", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    public void getDate_RejectDocDate_KualiFormat() throws Exception {
        Date formattedDate;
        String invoiceDate = "07/23/2008";
        try (MockedStatic configContextMockedStatic = Mockito.mockStatic(ConfigContext.class);
             MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            Properties props = new Properties();
            props.put("STRING_TO_DATE_FORMATS", "MM/dd/yyyy hh:mm a;MM/dd/yy;MM/dd/yyyy;MM-dd-yy;MM-dd-yyyy;MMddyy;MMMM dd;yyyy;MM/dd/yy HH:mm:ss;MM/dd/yyyy HH:mm:ss;MM-dd-yy HH:mm:ss;MMddyy HH:mm:ss;MMMM dd HH:mm:ss;yyyy HH:mm:ss");
            Config config = new Config(props);
            configContextMockedStatic.when(ConfigContext::getCurrentContextConfig).thenReturn((Object)config);
            DateTimeServiceImpl dateTimeService = new DateTimeServiceImpl();
            dateTimeService.afterPropertiesSet();
            springContextMockedStatic.when(() -> SpringContext.getBean(DateTimeService.class)).thenReturn((Object)dateTimeService);
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)this.parameterSvcMock);
            formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        }
        Assert.assertEquals((Object)"2008-07-23", (Object)Objects.requireNonNull(formattedDate).toString());
    }

    @Test
    public void getDate_invalidFormat() {
        Date formattedDate;
        String invoiceDate = "2008|07|23";
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)this.parameterSvcMock);
            formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        }
        Assert.assertNull((Object)formattedDate);
    }

    @Test
    public void getDate_invalidFormat_null() {
        String invoiceDate = null;
        Date formattedDate = ElectronicInvoiceUtils.getDate(invoiceDate);
        Assert.assertNull((Object)formattedDate);
    }

    @Test
    public void stripSplChars() {
        String rawInvoiceId = "A1!B2#C3$D4%";
        String stripped = ElectronicInvoiceUtils.stripSplChars((String)rawInvoiceId);
        Assert.assertEquals((Object)"A1B2C3D4", (Object)stripped);
    }
}

