/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util.cxml;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.util.cxml.B2BPOResponseFileType;
import org.kuali.kfs.module.purap.util.cxml.PurchaseOrderResponse;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.core.io.ClassPathResource;

@ExtendWith(value={MockitoExtension.class})
class B2BPOResponseFileTypeTest {
    private static final String B2B_PO_RESPONSE_XML_FILE_PATH = "org/kuali/kfs/module/purap/fixture/b2bPoResponseSample.xml";
    private static final String B2B_PO_RESPONSE_XSD = "classpath:org/kuali/kfs/module/purap/util/cxml/b2bPOResponse.xsd";
    private static final String CLASSPATH_URL_PREFIX = "classpath:";
    private B2BPOResponseFileType cut;

    B2BPOResponseFileTypeTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.clear();
        this.cut = new B2BPOResponseFileType();
        this.cut.setSchemaLocation(B2B_PO_RESPONSE_XSD);
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.clear();
    }

    @Test
    void parse_ShouldUnmarshallToIdenticalB2BPOResponse() throws Exception {
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);
             InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(B2B_PO_RESPONSE_XML_FILE_PATH);){
            ClassPathResource resource = new ClassPathResource(B2B_PO_RESPONSE_XSD.substring(CLASSPATH_URL_PREFIX.length()), this.getClass().getClassLoader());
            springContextMockedStatic.when(() -> SpringContext.getResource((String)B2B_PO_RESPONSE_XSD)).thenReturn((Object)resource);
            byte[] xmlBytes = Objects.requireNonNull(inputStream).readAllBytes();
            PurchaseOrderResponse poResponse = (PurchaseOrderResponse)this.cut.parse(xmlBytes);
            Assertions.assertNotNull((Object)poResponse);
            Assertions.assertEquals((Object)"300", (Object)poResponse.getStatusCode());
            Assertions.assertEquals((Object)"FAILED", (Object)poResponse.getStatusText());
            List errorMessages = poResponse.getPOResponseErrorMessages();
            Assertions.assertEquals((int)3, (int)errorMessages.size());
            Assertions.assertEquals((Object)"Failed to create B2BPOResponse", errorMessages.get(0));
            Assertions.assertEquals((Object)"invalid status", errorMessages.get(1));
            Assertions.assertEquals((Object)"Wrong PO Number", errorMessages.get(2));
        }
    }
}

