/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util.cxml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.B2BShoppingCartItem;
import org.kuali.kfs.module.purap.util.cxml.B2BParserHelper;
import org.kuali.kfs.module.purap.util.cxml.B2BPunchOutOrderFileType;
import org.kuali.kfs.module.purap.util.cxml.B2BShoppingCart;
import org.kuali.kfs.module.purap.util.cxml.B2BShoppingCartTestHelper;
import org.kuali.kfs.module.purap.util.cxml.Classification;
import org.kuali.kfs.module.purap.util.cxml.CxmlExtrinsic;
import org.kuali.kfs.module.purap.util.cxml.CxmlHeader;
import org.kuali.kfs.module.purap.util.cxml.ItemDetail;
import org.kuali.kfs.module.purap.util.cxml.ItemIn;
import org.kuali.kfs.module.purap.util.cxml.PunchOutOrderMessage;
import org.kuali.kfs.sys.batch.service.BatchInputFileService;
import org.kuali.kfs.sys.batch.service.impl.BatchInputFileServiceImpl;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.core.io.ClassPathResource;

@ExtendWith(value={MockitoExtension.class})
class B2BParserHelperTest {
    private B2BParserHelper cut;
    private B2BPunchOutOrderFileType b2BPunchOutOrderFileType;
    private BatchInputFileServiceImpl batchInputFileService;

    B2BParserHelperTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.clear();
        this.cut = B2BParserHelper.getInstance();
        this.b2BPunchOutOrderFileType = new B2BPunchOutOrderFileType();
        this.b2BPunchOutOrderFileType.setSchemaLocation("classpath:org/kuali/kfs/module/purap/util/cxml/b2bPunchOutOrder.xsd");
        this.batchInputFileService = new BatchInputFileServiceImpl();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.clear();
    }

    @Test
    void parseShoppingCartXML() throws IOException {
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);
             InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/purap/fixture/b2bShoppingCartSample.xml");){
            springContextMockedStatic.when(() -> SpringContext.getBean(B2BPunchOutOrderFileType.class)).thenReturn((Object)this.b2BPunchOutOrderFileType);
            springContextMockedStatic.when(() -> SpringContext.getBean(BatchInputFileService.class)).thenReturn((Object)this.batchInputFileService);
            ClassPathResource resource = new ClassPathResource("classpath:org/kuali/kfs/module/purap/util/cxml/b2bPunchOutOrder.xsd".substring("classpath:".length()), this.getClass().getClassLoader());
            springContextMockedStatic.when(() -> SpringContext.getResource((String)"classpath:org/kuali/kfs/module/purap/util/cxml/b2bPunchOutOrder.xsd")).thenReturn((Object)resource);
            String xml = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            B2BShoppingCart expectedShoppingCart = B2BShoppingCartTestHelper.getExpectedShoppingCart();
            B2BShoppingCart shoppingCart = this.cut.parseShoppingCartXML(xml);
            Assertions.assertNotNull((Object)shoppingCart);
            CxmlHeader expectedHeader = expectedShoppingCart.getCxmlHeader();
            CxmlHeader actualHeader = shoppingCart.getCxmlHeader();
            Assertions.assertEquals((Object)expectedHeader.getFromDomain(), (Object)actualHeader.getFromDomain());
            Assertions.assertEquals((Object)expectedHeader.getToDomain(), (Object)actualHeader.getToDomain());
            Assertions.assertEquals((Object)expectedHeader.getSenderDomain(), (Object)actualHeader.getSenderDomain());
            Assertions.assertEquals((Object)expectedHeader.getFromIdentity(), (Object)actualHeader.getFromIdentity());
            Assertions.assertEquals((Object)expectedHeader.getToIdentity(), (Object)actualHeader.getToIdentity());
            Assertions.assertEquals((Object)expectedHeader.getSenderIdentity(), (Object)actualHeader.getSenderIdentity());
            Assertions.assertEquals((Object)expectedHeader.getSenderUserAgent(), (Object)actualHeader.getSenderUserAgent());
            Assertions.assertEquals((Object)expectedShoppingCart.getMessageStatusCode(), (Object)shoppingCart.getMessageStatusCode());
            Assertions.assertEquals((Object)expectedShoppingCart.getMessageStatusText(), (Object)shoppingCart.getMessageStatusText());
            Assertions.assertEquals((Object)expectedShoppingCart.getBuyerCookieText(), (Object)shoppingCart.getBuyerCookieText());
            Assertions.assertEquals((Object)expectedShoppingCart.getTotal(), (Object)shoppingCart.getTotal());
            PunchOutOrderMessage expectedPunchOutOrder = expectedShoppingCart.getMessage().getPunchOutOrderMessage();
            PunchOutOrderMessage punchOutOrderMessage = shoppingCart.getMessage().getPunchOutOrderMessage();
            Assertions.assertEquals((int)1, (int)punchOutOrderMessage.getItemInList().size());
            ItemIn expectedItemIn = (ItemIn)expectedPunchOutOrder.getItemInList().get(0);
            ItemIn itemIn = (ItemIn)punchOutOrderMessage.getItemInList().get(0);
            Assertions.assertEquals((Long)expectedItemIn.getQuantity(), (Long)itemIn.getQuantity());
            Assertions.assertEquals((Object)expectedItemIn.getItemID().getSupplierPartAuxiliaryID(), (Object)itemIn.getItemID().getSupplierPartAuxiliaryID());
            Assertions.assertEquals((Object)expectedItemIn.getItemID().getSupplierPartID(), (Object)itemIn.getItemID().getSupplierPartID());
            B2BShoppingCartItem expectedShoppingCartItem = expectedItemIn.toB2BShoppingCartItem();
            B2BShoppingCartItem actualShoppingCartItem = itemIn.toB2BShoppingCartItem();
            Assertions.assertEquals((Object)expectedShoppingCartItem.getDescription(), (Object)actualShoppingCartItem.getDescription());
            Assertions.assertEquals((Object)expectedShoppingCartItem.getQuantity(), (Object)actualShoppingCartItem.getQuantity());
            Assertions.assertEquals((Object)expectedShoppingCartItem.getManufacturerName(), (Object)actualShoppingCartItem.getManufacturerName());
            Assertions.assertEquals((Object)expectedShoppingCartItem.getManufacturerPartID(), (Object)actualShoppingCartItem.getManufacturerPartID());
            Assertions.assertEquals((Object)expectedShoppingCartItem.getSupplierPartAuxiliaryId(), (Object)actualShoppingCartItem.getSupplierPartAuxiliaryId());
            Assertions.assertEquals((Object)expectedShoppingCartItem.getSupplierPartId(), (Object)actualShoppingCartItem.getSupplierPartId());
            Assertions.assertEquals((Object)expectedShoppingCartItem.getUnitOfMeasure(), (Object)actualShoppingCartItem.getUnitOfMeasure());
            Assertions.assertEquals((Object)expectedShoppingCartItem.getUnitPrice(), (Object)actualShoppingCartItem.getUnitPrice());
            Assertions.assertEquals((Object)expectedShoppingCartItem.getUnitPriceCurrency(), (Object)actualShoppingCartItem.getUnitPriceCurrency());
            Map expectedCartItemSuppliers = expectedShoppingCartItem.getSupplier();
            Map actualCartItemSuppliers = actualShoppingCartItem.getSupplier();
            Assertions.assertEquals((int)expectedCartItemSuppliers.size(), (int)actualCartItemSuppliers.size());
            for (Map.Entry entry : expectedCartItemSuppliers.entrySet()) {
                String key = (String)entry.getKey();
                Assertions.assertTrue((boolean)actualCartItemSuppliers.containsKey(key));
                Assertions.assertEquals(entry.getValue(), actualCartItemSuppliers.get(key));
            }
            Map expectedShoppingCartItemClassification = expectedShoppingCartItem.getClassification();
            Map actualClassifications = actualShoppingCartItem.getClassification();
            for (Map.Entry entry : expectedShoppingCartItemClassification.entrySet()) {
                String key = (String)entry.getKey();
                Assertions.assertTrue((boolean)actualClassifications.containsKey(key));
                Assertions.assertEquals(entry.getValue(), actualClassifications.get(key));
            }
            Map expectedShoppingCartItemExtrinsics = expectedShoppingCartItem.getExtrinsic();
            Map map = actualShoppingCartItem.getExtrinsic();
            for (Map.Entry entry : expectedShoppingCartItemExtrinsics.entrySet()) {
                String key = (String)entry.getKey();
                Assertions.assertTrue((boolean)map.containsKey(key));
                Assertions.assertEquals(entry.getValue(), map.get(key));
            }
            ItemDetail expectedItemDetail = expectedItemIn.getItemDetail();
            ItemDetail itemDetail = itemIn.getItemDetail();
            Assertions.assertEquals((Object)expectedItemDetail.getUnitPrice().getMoney().getCurrency(), (Object)itemDetail.getUnitPrice().getMoney().getCurrency());
            Assertions.assertEquals((Object)expectedItemDetail.getUnitPrice().getMoney().getValue(), (Object)itemDetail.getUnitPrice().getMoney().getValue());
            Assertions.assertEquals((Object)expectedItemDetail.getDescription().getLang(), (Object)itemDetail.getDescription().getLang());
            Assertions.assertEquals((Object)expectedItemDetail.getDescription().getValue(), (Object)itemDetail.getDescription().getValue());
            Assertions.assertEquals((Object)expectedItemDetail.getUnitOfMeasure(), (Object)itemDetail.getUnitOfMeasure());
            List expectedClassifications = expectedItemDetail.getClassificationList();
            List classifications = itemDetail.getClassificationList();
            Assertions.assertEquals((int)expectedClassifications.size(), (int)classifications.size());
            for (int i = 0; i < classifications.size(); ++i) {
                Assertions.assertEquals((Object)((Classification)expectedClassifications.get(i)).getDomain(), (Object)((Classification)classifications.get(i)).getDomain());
                Assertions.assertEquals((Object)((Classification)expectedClassifications.get(i)).getValue(), (Object)((Classification)classifications.get(i)).getValue());
            }
            List expectedExtrinsics = expectedItemDetail.getExtrinsicList();
            List extrinsics = itemDetail.getExtrinsicList();
            Assertions.assertEquals((int)expectedExtrinsics.size(), (int)extrinsics.size());
            for (int i = 0; i < extrinsics.size(); ++i) {
                Assertions.assertEquals((Object)((CxmlExtrinsic)expectedExtrinsics.get(i)).getName(), (Object)((CxmlExtrinsic)extrinsics.get(i)).getName());
                Assertions.assertEquals((Object)((CxmlExtrinsic)expectedExtrinsics.get(i)).getValue(), (Object)((CxmlExtrinsic)extrinsics.get(i)).getValue());
            }
        }
    }
}

