/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.module.purap.businessobject.FundingSource;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.sys.context.SpringContext;

public class FundingSourceRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger();

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomApproveDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkForSystemParametersExistence();
        return success && super.processCustomApproveDocumentBusinessRules(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomRouteDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkForSystemParametersExistence();
        return success && super.processCustomRouteDocumentBusinessRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomSaveDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkForSystemParametersExistence();
        return success && super.processCustomSaveDocumentBusinessRules(document);
    }

    protected boolean checkForSystemParametersExistence() {
        LOG.info("checkForSystemParametersExistence called");
        boolean success = true;
        ArrayList parameterValues = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(RequisitionDocument.class, "FUNDING_SOURCE"));
        FundingSource newFundingSource = (FundingSource)((Object)this.getNewBo());
        FundingSource oldFundingSource = (FundingSource)((Object)this.getOldBo());
        if (parameterValues.contains(newFundingSource.getFundingSourceCode()) && !newFundingSource.isActive() && oldFundingSource.isActive()) {
            success = false;
            String documentLabel = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentLabelByClass(((Object)((Object)newFundingSource)).getClass());
            this.putGlobalError("error.document.cannot.inactivate.used.in.system.parameters", documentLabel);
        }
        return success;
    }
}

