/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kew.api.KewApiServiceLocator;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.document.DocumentRefreshQueue;
import org.kuali.kfs.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.kfs.kew.service.KEWServiceLocator;
import org.kuali.kfs.kns.datadictionary.DocumentEntry;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.DefaultPrincipalAddress;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedAddPurchasingAccountsPayableItemEvent;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingActionBase;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingFormBase;
import org.kuali.kfs.module.purap.document.web.struts.RequisitionForm;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.FinancialSystemWorkflowHelperService;
import org.kuali.kfs.vnd.businessobject.VendorCommodityCode;
import org.kuali.kfs.vnd.businessobject.VendorDetail;

public class RequisitionAction
extends PurchasingActionBase {
    private static final Logger LOG = LogManager.getLogger();
    private RequisitionService requisitionService;
    private FinancialSystemWorkflowHelperService financialSystemWorkflowHelperService;

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.save(mapping, form, request, response);
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        PurchasingFormBase baseForm = (PurchasingFormBase)form;
        PurchasingAccountsPayableDocument purapDocument = (PurchasingAccountsPayableDocument)kualiDocumentFormBase.getDocument();
        baseForm.setCalculated(false);
        purapDocument.setCalculated(false);
        return mapping.findForward("basic");
    }

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) {
        super.createDocument(kualiDocumentFormBase);
        ((RequisitionDocument)kualiDocumentFormBase.getDocument()).initiateDocument();
    }

    public ActionForward setAsDefaultBuilding(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequisitionDocument req = (RequisitionDocument)((RequisitionForm)form).getDocument();
        if (ObjectUtils.isNotNull((Object)req.getDeliveryCampusCode()) && ObjectUtils.isNotNull((Object)req.getDeliveryBuildingCode())) {
            DefaultPrincipalAddress defaultPrincipalAddress = new DefaultPrincipalAddress(GlobalVariables.getUserSession().getPerson().getPrincipalId());
            Map addressKeys = ((PersistenceService)SpringContext.getBean(PersistenceService.class)).getPrimaryKeyFieldValues((Object)defaultPrincipalAddress);
            defaultPrincipalAddress = (DefaultPrincipalAddress)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(DefaultPrincipalAddress.class, addressKeys);
            if (ObjectUtils.isNull((Object)((Object)defaultPrincipalAddress))) {
                defaultPrincipalAddress = new DefaultPrincipalAddress(GlobalVariables.getUserSession().getPerson().getPrincipalId());
            }
            defaultPrincipalAddress.setDefaultBuilding(req.getDeliveryCampusCode(), req.getDeliveryBuildingCode(), req.getDeliveryBuildingRoomNumber());
            ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)defaultPrincipalAddress);
            KNSGlobalVariables.getMessageList().add("message.default.building.saved", new String[0]);
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.refresh(mapping, form, request, response);
        RequisitionForm rqForm = (RequisitionForm)form;
        RequisitionDocument document = (RequisitionDocument)rqForm.getDocument();
        document.setOrganizationAutomaticPurchaseOrderLimit(((PurapService)SpringContext.getBean(PurapService.class)).getApoLimit(document.getVendorContractGeneratedIdentifier(), document.getChartOfAccountsCode(), document.getOrganizationCode()));
        return forward;
    }

    @Override
    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequisitionForm rqForm = (RequisitionForm)form;
        RequisitionDocument document = (RequisitionDocument)rqForm.getDocument();
        if (document.getDocumentHeader().getWorkflowDocument().getCurrentNodeNames().contains("Organization")) {
            boolean approver = false;
            String principalId = GlobalVariables.getUserSession().getPrincipalId();
            WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
            ChartOrgHolder initiatorPrimaryOrg = ((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class)).getPrimaryOrganization(workflowDocument.getInitiatorPrincipalId(), "KFS-PURAP");
            if (document.getChartOfAccountsCode().equals(initiatorPrimaryOrg.getChartOfAccountsCode()) || document.getOrganizationCode().equals(initiatorPrimaryOrg.getOrganizationCode())) {
                approver = true;
            }
            if (this.getRequisitionService().getContentReviewers(document.getOrganizationCode(), document.getChartOfAccountsCode()).stream().anyMatch(roleMembership -> roleMembership.getMemberId().equals(principalId))) {
                approver = true;
            }
            if (this.getFinancialSystemWorkflowHelperService().isAdhocApprovalRequestedForPrincipal(workflowDocument, principalId)) {
                approver = true;
            }
            if (!approver) {
                this.getDocumentService().saveDocument((Document)document);
                DocumentRouteHeaderValue routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentNumber());
                DocumentRefreshQueue docRequeue = KewApiServiceLocator.getDocumentRequeuerService((String)routeHeader.getDocumentId(), (long)0L);
                docRequeue.refreshDocument(routeHeader.getDocumentId());
                this.sendAdHocRequests(mapping, form, request, response);
                return this.returnToSender(request, mapping, (KualiDocumentFormBase)rqForm);
            }
        }
        return super.approve(mapping, form, request, response);
    }

    public String getRoleName() {
        return "Content Reviewer";
    }

    public String getRoleNamespace() {
        return "KFS-PURAP";
    }

    public ActionForward addAsset(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequisitionForm rqForm = (RequisitionForm)form;
        RequisitionDocument document = (RequisitionDocument)rqForm.getDocument();
        return mapping.findForward("basic");
    }

    public ActionForward displayB2BRequisition(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequisitionForm reqForm = (RequisitionForm)form;
        reqForm.setDocId((String)request.getSession().getAttribute("docId"));
        this.loadDocument((KualiDocumentFormBase)reqForm);
        String multipleB2BReqs = (String)request.getSession().getAttribute("multipleB2BRequisitions");
        if (StringUtils.isNotEmpty((CharSequence)multipleB2BReqs)) {
            KNSGlobalVariables.getMessageList().add("message.b2b.multiple.requisitions", new String[0]);
        }
        request.getSession().removeAttribute("docId");
        request.getSession().removeAttribute("multipleB2BRequisitions");
        if (reqForm.getAdditionalScriptFiles().isEmpty()) {
            DocumentEntry docEntry = this.getDocumentDictionaryService().getDocumentEntry(reqForm.getDocument().getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            reqForm.getAdditionalScriptFiles().addAll(docEntry.getWebScriptFiles());
        }
        return mapping.findForward("basic");
    }

    public ActionForward clearVendor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase baseForm = (PurchasingFormBase)form;
        RequisitionDocument document = (RequisitionDocument)baseForm.getDocument();
        document.setVendorHeaderGeneratedIdentifier(null);
        document.setVendorDetailAssignedIdentifier(null);
        document.setVendorDetail(null);
        document.setVendorName("");
        document.setVendorLine1Address("");
        document.setVendorLine2Address("");
        document.setVendorAddressInternationalProvinceName("");
        document.setVendorCityName("");
        document.setVendorStateCode("");
        document.setVendorPostalCode("");
        document.setVendorCountryCode("");
        document.setVendorContractGeneratedIdentifier(null);
        document.setVendorContract(null);
        document.setVendorFaxNumber("");
        document.setVendorCustomerNumber("");
        document.setVendorAttentionName("");
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequisitionDocument document = (RequisitionDocument)((PurchasingFormBase)form).getDocument();
        document.setBlanketApproveRequest(true);
        return super.blanketApprove(mapping, form, request, response);
    }

    @Override
    public ActionForward addItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean rulePassed;
        RequisitionDocument reqs;
        VendorDetail dtl;
        boolean commCodeParam;
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        PurApItem item = purchasingForm.getNewPurchasingItemLine();
        RequisitionItem requisitionItem = (RequisitionItem)item;
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        if (StringUtils.isBlank((CharSequence)requisitionItem.getPurchasingCommodityCode()) && (commCodeParam = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(RequisitionDocument.class, "ENABLE_DEFAULT_VENDOR_COMMODITY_CODE_IND").booleanValue()) && purchasingForm instanceof RequisitionForm && ObjectUtils.isNotNull((Object)(dtl = (reqs = (RequisitionDocument)purchasingForm.getDocument()).getVendorDetail()))) {
            List vcc = dtl.getVendorCommodities();
            for (VendorCommodityCode commodity : vcc) {
                if (!commodity.isCommodityDefaultIndicator()) continue;
                requisitionItem.setPurchasingCommodityCode(commodity.getPurchasingCommodityCode());
            }
        }
        if (rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", (Document)purDocument, item))) {
            item = purchasingForm.getAndResetNewPurchasingItemLine();
            purDocument.addItem(item);
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.shouldWarnIfNoAccountingLines(form)) {
            String question = request.getParameter("questionIndex");
            if (StringUtils.equals((CharSequence)question, (CharSequence)"RequisitionAccountingLinesQuestion")) {
                String answer = request.getParameter("buttonClicked");
                if (!StringUtils.equals((CharSequence)answer, (CharSequence)"0")) {
                    LOG.info("add a warning and refresh the page ");
                    GlobalVariables.getMessageMap().putWarning("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "message.requisition.no.accounting.lines", new String[0]);
                    return this.refresh(mapping, form, request, response);
                }
            } else {
                return this.performQuestionWithoutInput(mapping, form, request, response, "RequisitionAccountingLinesQuestion", "This document is missing accounting lines on one or more items. Are you sure you want to continue?", "confirmationQuestion", "route", "1");
            }
        }
        return super.route(mapping, form, request, response);
    }

    protected boolean shouldWarnIfNoAccountingLines(ActionForm form) {
        RequisitionDocument doc = (RequisitionDocument)((PurchasingFormBase)form).getDocument();
        RequisitionService reqs = this.getRequisitionService();
        return doc.isMissingAccountingLines() && !reqs.getContentReviewers(doc.getOrganizationCode(), doc.getChartOfAccountsCode()).isEmpty();
    }

    protected synchronized RequisitionService getRequisitionService() {
        if (this.requisitionService == null) {
            this.requisitionService = (RequisitionService)SpringContext.getBean(RequisitionService.class);
        }
        return this.requisitionService;
    }

    protected synchronized FinancialSystemWorkflowHelperService getFinancialSystemWorkflowHelperService() {
        if (this.financialSystemWorkflowHelperService == null) {
            this.financialSystemWorkflowHelperService = (FinancialSystemWorkflowHelperService)SpringContext.getBean(FinancialSystemWorkflowHelperService.class);
        }
        return this.financialSystemWorkflowHelperService;
    }
}

