/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.module.purap.PurapConstants;

import java.util.List;

public class RequisitionView extends AbstractRelatedView {

    private Integer requisitionIdentifier;

    public Integer getRequisitionIdentifier() {
        return requisitionIdentifier;
    }

    public void setRequisitionIdentifier(Integer requisitionIdentifier) {
        this.requisitionIdentifier = requisitionIdentifier;
    }

    /**
     * The next three methods are overridden but shouldn't be! If they aren't overridden, they dont show up in the tag,
     * not sure why at this point! (AAP)
     */
    @Override
    public Integer getPurapDocumentIdentifier() {
        return super.getPurapDocumentIdentifier();
    }

    @Override
    public String getDocumentIdentifierString() {
        return super.getDocumentIdentifierString();
    }

    @Override
    public List<Note> getNotes() {
        return super.getNotes();
    }

    @Override
    public String getUrl() {
        return super.getUrl();
    }

    @Override
    public String getDocumentTypeName() {
        return PurapConstants.PurapDocTypeCodes.REQUISITION_DOCUMENT_TYPE;
    }
}
