/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;

/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType&gt;
 *   &lt;simpleContent&gt;
 *     &lt;extension base="&lt;http://www.kuali.org/kfs/purap/types&gt;emptyType"&gt;
 *       &lt;attribute name="isHeaderInvoice"&gt;
 *         &lt;simpleType&gt;
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *             &lt;enumeration value="yes"/&gt;
 *           &lt;/restriction&gt;
 *         &lt;/simpleType&gt;
 *       &lt;/attribute&gt;
 *       &lt;attribute name="isVatRecoverable"&gt;
 *         &lt;simpleType&gt;
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *             &lt;enumeration value="yes"/&gt;
 *           &lt;/restriction&gt;
 *         &lt;/simpleType&gt;
 *       &lt;/attribute&gt;
 *     &lt;/extension&gt;
 *   &lt;/simpleContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = "value")
public class InvoiceDetailHeaderIndicator {

    @XmlAttribute(name = "isHeaderInvoice")
    String isHeaderInvoice;

    @XmlAttribute(name = "isVatRecoverable")
    String isVatRecoverable;

    @XmlValue
    String value;

    public InvoiceDetailHeaderIndicator() {
    }

    public InvoiceDetailHeaderIndicator(
            final String isHeaderInvoice, final String isVatRecoverable, final String value
    ) {
        this.isHeaderInvoice = isHeaderInvoice;
        this.isVatRecoverable = isVatRecoverable;
        this.value = value;
    }

    public InvoiceDetailHeaderIndicator(final String isHeaderInvoice) {
        this.isHeaderInvoice = isHeaderInvoice;
    }

    /**
     * Gets the value of the isHeaderInvoice property.
     *
     * @return possible object is {@link String }
     */
    public String getIsHeaderInvoice() {
        return isHeaderInvoice;
    }

    /**
     * Sets the value of the isHeaderInvoice property.
     *
     * @param isHeaderInvoice allowed object is {@link String }
     */
    public void setIsHeaderInvoice(final String isHeaderInvoice) {
        this.isHeaderInvoice = isHeaderInvoice;
    }

    /**
     * Gets the value of the isVatRecoverable property.
     *
     * @return possible object is {@link String }
     */
    public String getIsVatRecoverable() {
        return isVatRecoverable;
    }

    /**
     * Sets the value of the isVatRecoverable property.
     *
     * @param isVatRecoverable allowed object is {@link String }
     */
    public void setIsVatRecoverable(final String isVatRecoverable) {
        this.isVatRecoverable = isVatRecoverable;
    }

    /**
     * Gets the value of the value property.
     *
     * @return possible object is {@link String }
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     *
     * @param value allowed object is {@link String }
     */
    public void setValue(final String value) {
        this.value = value;
    }

}
